/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.tokenizer.annotators;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArrayCoreMap;
import eu.fbk.dh.tint.tokenizer.ItalianTokenizer;
import eu.fbk.dh.tint.tokenizer.models.ItalianTokenizerModel;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ItalianTokenizerAnnotator
implements Annotator {
    boolean newlineIsSentenceBreak;
    boolean tokenizeOnlyOnSpace;
    boolean ssplitOnlyOnNewLine;
    ItalianTokenizer tokenizer;

    public ItalianTokenizerAnnotator(String annotatorName, Properties props) {
        String modelFile = props.getProperty(annotatorName + ".model", null);
        this.newlineIsSentenceBreak = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".newlineIsSentenceBreak"), (boolean)true);
        this.tokenizeOnlyOnSpace = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".tokenizeOnlyOnSpace"), (boolean)false);
        this.ssplitOnlyOnNewLine = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".ssplitOnlyOnNewLine"), (boolean)false);
        if (this.ssplitOnlyOnNewLine) {
            this.newlineIsSentenceBreak = true;
        }
        File model = null;
        if (modelFile != null) {
            model = new File(modelFile);
        }
        this.tokenizer = ItalianTokenizerModel.getInstance(model).getTokenizer();
    }

    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        List<List<CoreLabel>> sTokens = this.tokenizer.parse(text, this.newlineIsSentenceBreak, this.tokenizeOnlyOnSpace, this.ssplitOnlyOnNewLine);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        int sIndex = 0;
        int tokenIndex = 0;
        for (List<CoreLabel> sentence : sTokens) {
            if (sentence.size() == 0) continue;
            ArrayCoreMap sent = new ArrayCoreMap(1);
            for (CoreLabel coreLabel : sentence) {
                coreLabel.setSentIndex(sIndex);
            }
            int begin = sentence.get(0).beginPosition();
            int end = sentence.get(sentence.size() - 1).endPosition();
            sent.set(CoreAnnotations.TokensAnnotation.class, sentence);
            sent.set(CoreAnnotations.SentenceIndexAnnotation.class, (Object)sIndex++);
            sent.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, (Object)begin);
            sent.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, (Object)end);
            sent.set(CoreAnnotations.TokenBeginAnnotation.class, (Object)tokenIndex);
            sent.set(CoreAnnotations.TokenEndAnnotation.class, (Object)(tokenIndex += sentence.size()));
            sent.set(CoreAnnotations.TextAnnotation.class, (Object)text.substring(begin, end));
            sentences.add(sent);
            tokens.addAll(sentence);
        }
        annotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return TOKENIZE_AND_SSPLIT;
    }

    public Set<Annotator.Requirement> requires() {
        return Collections.emptySet();
    }
}

