/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.it;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import eu.fbk.dh.tint.readability.GlossarioEntry;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.it.EasyLanguage;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItalianReadabilityModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItalianReadabilityModel.class);
    private static ItalianReadabilityModel ourInstance = null;
    private HashMap<String, GlossarioEntry> glossario = new HashMap();
    private HashMap<Integer, HashMultimap<String, String>> easyWords = new HashMap();

    public static ItalianReadabilityModel getInstance(Properties globalProperties, Properties localProperties) {
        if (ourInstance == null) {
            boolean useGlossario = PropertiesUtils.getBoolean((String)localProperties.getProperty("glossario.use"), (boolean)false);
            String easyWordsFileName = localProperties.getProperty("easyWords");
            Gson gson = new Gson();
            EasyLanguage easyLanguage = new EasyLanguage();
            LOGGER.info("Loading easy lemmas");
            try {
                InputStream stream = Readability.getStream(easyWordsFileName, "/models/easy-output.json");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
                easyLanguage = (EasyLanguage)gson.fromJson(reader, EasyLanguage.class);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to load easyWords file: {}", (Object)e.getMessage());
            }
            HashMap<Integer, HashMultimap<String, String>> easyWords = new HashMap<Integer, HashMultimap<String, String>>();
            easyWords.put(1, HashMultimap.create());
            ((HashMultimap)easyWords.get(1)).putAll((Object)"S", Arrays.asList(easyLanguage.level1.n));
            ((HashMultimap)easyWords.get(1)).putAll((Object)"V", Arrays.asList(easyLanguage.level1.v));
            easyWords.put(2, HashMultimap.create());
            ((HashMultimap)easyWords.get(2)).putAll((Object)"S", Arrays.asList(easyLanguage.level2.n));
            ((HashMultimap)easyWords.get(2)).putAll((Object)"A", Arrays.asList(easyLanguage.level2.a));
            ((HashMultimap)easyWords.get(2)).putAll((Object)"B", Arrays.asList(easyLanguage.level2.r));
            ((HashMultimap)easyWords.get(2)).putAll((Object)"V", Arrays.asList(easyLanguage.level2.v));
            easyWords.put(3, HashMultimap.create());
            ((HashMultimap)easyWords.get(3)).putAll((Object)"S", Arrays.asList(easyLanguage.level3.n));
            ((HashMultimap)easyWords.get(3)).putAll((Object)"A", Arrays.asList(easyLanguage.level3.a));
            ((HashMultimap)easyWords.get(3)).putAll((Object)"B", Arrays.asList(easyLanguage.level3.r));
            ((HashMultimap)easyWords.get(3)).putAll((Object)"V", Arrays.asList(easyLanguage.level3.v));
            HashMap<String, GlossarioEntry> glossario = new HashMap<String, GlossarioEntry>();
            if (useGlossario) {
                Properties stanfordProperties = PropertiesUtils.dotConvertedProperties((Properties)localProperties, (String)"glossario.stanford");
                for (String key : globalProperties.stringPropertyNames()) {
                    if (stanfordProperties.getProperty(key) != null) continue;
                    stanfordProperties.setProperty(key, globalProperties.getProperty(key));
                }
                String glossarioFileName = localProperties.getProperty("glossario");
                Boolean parseGlossario = PropertiesUtils.getBoolean((String)localProperties.getProperty("glossario.parse", "true"), (boolean)true);
                StanfordCoreNLP pipeline = new StanfordCoreNLP(stanfordProperties);
                LOGGER.info("Loading glossario");
                try {
                    GlossarioEntry[] entries;
                    InputStream stream = Readability.getStream(glossarioFileName, "/models/glossario-parsed-edited.json");
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
                    for (GlossarioEntry entry : entries = (GlossarioEntry[])gson.fromJson(reader, GlossarioEntry[].class)) {
                        for (String form : entry.getForms()) {
                            if (parseGlossario.booleanValue()) {
                                Annotation annotation = new Annotation(form);
                                pipeline.annotate(annotation);
                                StringBuffer stringBuffer = new StringBuffer();
                                List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
                                for (CoreLabel token : tokens) {
                                    stringBuffer.append((String)token.get(CoreAnnotations.LemmaAnnotation.class)).append(" ");
                                }
                                String pos = entry.getPos();
                                String annotatedPos = (String)((CoreLabel)tokens.get(0)).get(CoreAnnotations.PartOfSpeechAnnotation.class);
                                if (pos == null || annotatedPos.substring(0, 1).equals("S")) {
                                    glossario.put(stringBuffer.toString().trim(), entry);
                                }
                            }
                            glossario.put(form, entry);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to load glossario file: {}", (Object)e.getMessage());
                }
            }
            ourInstance = new ItalianReadabilityModel(glossario, easyWords);
        } else {
            LOGGER.info("Readability model already loaded");
        }
        return ourInstance;
    }

    private ItalianReadabilityModel(HashMap<String, GlossarioEntry> glossario, HashMap<Integer, HashMultimap<String, String>> easyWords) {
        this.glossario = glossario;
        this.easyWords = easyWords;
    }

    public HashMap<String, GlossarioEntry> getGlossario() {
        return this.glossario;
    }

    public HashMap<Integer, HashMultimap<String, String>> getEasyWords() {
        return this.easyWords;
    }
}

