/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.it;

import com.google.common.collect.HashMultimap;
import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.DescriptionForm;
import eu.fbk.dh.tint.readability.GlossarioEntry;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.it.ItalianReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

abstract class ItalianReadability
extends Readability {
    @JSONExclude
    ItalianReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;
    @JSONExclude
    StringBuilder buffer = new StringBuilder();
    @JSONExclude
    int lemmaIndex = 0;
    @JSONExclude
    HashMap<Integer, Integer> lemmaIndexes = new HashMap();
    @JSONExclude
    HashMap<Integer, Integer> tokenIndexes = new HashMap();
    TreeMap<Integer, DescriptionForm> forms = new TreeMap();

    @Override
    public void finalizeReadability() {
        double gulpease = 89.0 + (double)(300 * this.getSentenceCount() - 10 * this.getDocLenLettersOnly()) / ((double)this.getWordCount() * 1.0);
        this.measures.put("gulpease", gulpease);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentEasyWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
        String lemmaText = this.buffer.toString().trim();
        String text = (String)this.annotation.get(CoreAnnotations.TextAnnotation.class);
        HashMap<String, GlossarioEntry> glossario = this.model.getGlossario();
        ArrayList<String> glossarioKeys = new ArrayList<String>(glossario.keySet());
        Collections.sort(glossarioKeys, new StringLenComparator());
        for (String form : glossarioKeys) {
            int numberOfTokens = form.split("\\s+").length;
            List<Integer> allOccurrences = ItalianReadability.findAllOccurrences(text, form);
            List<Integer> allLemmaOccurrences = ItalianReadability.findAllOccurrences(lemmaText, form);
            for (Integer occurrence : allOccurrences) {
                ItalianReadability.addDescriptionForm(form, this.tokenIndexes, occurrence, numberOfTokens, this.forms, this.annotation, glossario);
            }
            for (Integer occurrence : allLemmaOccurrences) {
                ItalianReadability.addDescriptionForm(form, this.lemmaIndexes, occurrence, numberOfTokens, this.forms, this.annotation, glossario);
            }
        }
    }

    public ItalianReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("it", annotation);
        this.hyphenator = new Hyphenator("it", "it", 1, 1);
        this.model = ItalianReadabilityModel.getInstance(globalProperties, localProperties);
    }

    public static List<Integer> findAllOccurrences(String haystack, String needle) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int index = haystack.indexOf(needle);
        while (index >= 0) {
            try {
                String afterChar = haystack.substring(index + needle.length(), index + needle.length() + 1);
                if (!afterChar.matches("\\w+")) {
                    ret.add(index);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            index = haystack.indexOf(needle, index + 1);
        }
        return ret;
    }

    private static void addDescriptionForm(String form, HashMap<Integer, Integer> indexes, int start, int numberOfTokens, TreeMap<Integer, DescriptionForm> forms, Annotation annotation, HashMap<String, GlossarioEntry> glossario) {
        Integer lemmaIndex = indexes.get(start);
        if (lemmaIndex == null) {
            return;
        }
        CoreLabel firstToken = (CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(lemmaIndex);
        CoreLabel endToken = (CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(lemmaIndex + numberOfTokens - 1);
        Integer beginOffset = (Integer)firstToken.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        Integer endOffset = (Integer)endToken.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        GlossarioEntry glossarioEntry = glossario.get(form);
        if (glossarioEntry == null) {
            return;
        }
        DescriptionForm descriptionForm = new DescriptionForm(beginOffset, endOffset, glossarioEntry);
        forms.put(beginOffset, descriptionForm);
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        HashMap<Integer, HashMultimap<String, String>> easyWords = this.model.getEasyWords();
        String simplePos = this.getGenericPos((String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
        String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
        if (easyWords.get(3).get((Object)simplePos).contains(lemma)) {
            ++this.level3WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)3);
        }
        if (easyWords.get(2).get((Object)simplePos).contains(lemma)) {
            ++this.level2WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)2);
        }
        if (easyWords.get(1).get((Object)simplePos).contains(lemma)) {
            ++this.level1WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)1);
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
    }

    @Override
    public void addingToken(CoreLabel token) {
        this.lemmaIndexes.put(this.buffer.length(), this.lemmaIndex);
        this.tokenIndexes.put((Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), this.lemmaIndex);
        ++this.lemmaIndex;
        this.buffer.append((String)token.get(CoreAnnotations.LemmaAnnotation.class)).append(" ");
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }

    static class StringLenComparator
    implements Comparator<String> {
        StringLenComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    }
}

