/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.es;

import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.es.SpanishReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.Properties;

abstract class SpanishReadability
extends Readability {
    @JSONExclude
    SpanishReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;

    @Override
    public void finalizeReadability() {
        double fleschSzigriszt = 206.835 - 62.3 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 1.0 * (double)this.getWordCount() / (double)this.getSentenceCount();
        double fernandezHuerta = 206.84 - 0.6 * (100.0 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount()) - 1.02 * (100.0 * (double)this.getSentenceCount() / (double)this.getWordCount());
        this.measures.put("flesch-szigriszt", fleschSzigriszt);
        this.measures.put("fernandez-huerta", fernandezHuerta);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
    }

    public SpanishReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("es", annotation);
        this.hyphenator = new Hyphenator("es", "es", 1, 1);
        this.model = SpanishReadabilityModel.getInstance(globalProperties, localProperties);
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        String lemma = token.lemma();
        if (this.model.getLevel1Lemmas().contains(lemma)) {
            ++this.level1WordSize;
        }
        if (this.model.getLevel2Lemmas().contains(lemma)) {
            ++this.level2WordSize;
        }
        if (this.model.getLevel3Lemmas().contains(lemma)) {
            ++this.level3WordSize;
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
    }

    @Override
    public void addingToken(CoreLabel token) {
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }
}

