/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.en;

import edu.stanford.nlp.pipeline.Annotation;
import eu.fbk.dh.tint.readability.en.EnglishReadability;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnglishStandardReadability
extends EnglishReadability {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnglishStandardReadability.class);
    private static final Pattern startsWithLetter = Pattern.compile("^[a-zA-Z].*");
    private static final Set<String> immutablePos = new HashSet<String>();

    @Override
    protected String getGenericPos(String pos) {
        if (immutablePos.contains(pos)) {
            return pos;
        }
        if (pos.equals("SYM")) {
            return "X";
        }
        if (pos.equals("MD")) {
            return "V";
        }
        Matcher matcher = startsWithLetter.matcher(pos);
        if (matcher.find()) {
            return super.getGenericPos(pos);
        }
        return "X";
    }

    public EnglishStandardReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super(globalProperties, localProperties, annotation);
        this.contentPosList.add("N");
        this.contentPosList.add("J");
        this.contentPosList.add("V");
        this.contentPosList.add("R");
        this.simplePosList.add("N");
        this.simplePosList.add("V");
        this.nonWordPosList.add("X");
        this.genericPosDescription.put("J", "Adjective");
        this.genericPosDescription.put("CC", "Conjunction");
        this.genericPosDescription.put("CD", "Number");
        this.genericPosDescription.put("D", "Determiner");
        this.genericPosDescription.put("X", "Punctuation");
        this.genericPosDescription.put("F", "Foreign word");
        this.genericPosDescription.put("IN", "Subordinating (prep. or conj.)");
        this.genericPosDescription.put("L", "List item marker");
        this.genericPosDescription.put("PDT", "Pre-determiner");
        this.genericPosDescription.put("POS", "Possessive");
        this.genericPosDescription.put("P", "Pronoun");
        this.genericPosDescription.put("R", "Adverb");
        this.genericPosDescription.put("N", "Noun");
        this.genericPosDescription.put("TO", "To");
        this.genericPosDescription.put("U", "Interjection");
        this.genericPosDescription.put("V", "Verb");
        this.genericPosDescription.put("W", "Wh-stuff");
    }

    static {
        immutablePos.add("POS");
        immutablePos.add("CC");
        immutablePos.add("CD");
        immutablePos.add("PDT");
        immutablePos.add("TO");
        immutablePos.add("IN");
    }
}

