/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.en;

import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.utils.core.FrequencyHashSet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnglishReadabilityModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnglishReadabilityModel.class);
    private static EnglishReadabilityModel ourInstance = null;
    private static final int LIMIT_EASY = 1000;
    private static final int LIMIT_MEDIUM = 5000;
    private static final int LIMIT_HARD = 10000;
    private Set<String> level1Lemmas = new HashSet<String>();
    private Set<String> level2Lemmas = new HashSet<String>();
    private Set<String> level3Lemmas = new HashSet<String>();

    public static EnglishReadabilityModel getInstance(Properties globalProperties, Properties localProperties) {
        if (ourInstance == null) {
            String freqLemmaFile = localProperties.getProperty("lemmasFile");
            LOGGER.info("Loading lemmas");
            HashSet<String> level1Lemmas = new HashSet<String>();
            HashSet<String> level2Lemmas = new HashSet<String>();
            HashSet<String> level3Lemmas = new HashSet<String>();
            try {
                String line;
                FrequencyHashSet frequecies = new FrequencyHashSet();
                InputStream stream = Readability.getStream(freqLemmaFile, "/models/0_words.txt");
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split("\t");
                    if (parts.length < 2) continue;
                    String form = parts[0];
                    Integer frequency = Integer.parseInt(parts[1]);
                    frequecies.add((Object)form, frequency.intValue());
                }
                int i = 0;
                for (Map.Entry entry : frequecies.getSorted()) {
                    String form = (String)entry.getKey();
                    boolean done = false;
                    if (i < 1000) {
                        level1Lemmas.add(form);
                        done = true;
                    }
                    if (i < 5000) {
                        level2Lemmas.add(form);
                        done = true;
                    }
                    if (i < 10000) {
                        level3Lemmas.add(form);
                        done = true;
                    }
                    if (!done) break;
                    ++i;
                }
                reader.close();
            }
            catch (Exception e) {
                LOGGER.warn("Unable to load easyWords file: {}", (Object)e.getMessage());
            }
            ourInstance = new EnglishReadabilityModel(level1Lemmas, level2Lemmas, level3Lemmas);
        } else {
            LOGGER.info("Readability model already loaded");
        }
        return ourInstance;
    }

    private EnglishReadabilityModel(Set<String> level1Lemmas, Set<String> level2Lemmas, Set<String> level3Lemmas) {
        this.level1Lemmas = level1Lemmas;
        this.level2Lemmas = level2Lemmas;
        this.level3Lemmas = level3Lemmas;
    }

    public Set<String> getLevel1Lemmas() {
        return this.level1Lemmas;
    }

    public Set<String> getLevel2Lemmas() {
        return this.level2Lemmas;
    }

    public Set<String> getLevel3Lemmas() {
        return this.level3Lemmas;
    }
}

