/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.en;

import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.en.EnglishReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.Properties;

abstract class EnglishReadability
extends Readability {
    @JSONExclude
    EnglishReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;

    @Override
    public void finalizeReadability() {
        double flesch = 206.835 - 84.6 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 1.015 * (double)this.getWordCount() / (double)this.getSentenceCount();
        double fleschKincaid = 0.39 * (double)this.getWordCount() / (double)this.getSentenceCount() + 11.8 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 15.59;
        this.measures.put("flesch", flesch);
        this.measures.put("flesch-kincaid", fleschKincaid);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
    }

    public EnglishReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("en", annotation);
        this.hyphenator = new Hyphenator("en", "en", 1, 1);
        this.model = EnglishReadabilityModel.getInstance(globalProperties, localProperties);
        System.out.println(this.model.getLevel1Lemmas().size());
        System.out.println(this.model.getLevel2Lemmas().size());
        System.out.println(this.model.getLevel3Lemmas().size());
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        String lemma = token.word();
        if (this.model.getLevel1Lemmas().contains(lemma)) {
            ++this.level1WordSize;
        }
        if (this.model.getLevel2Lemmas().contains(lemma)) {
            ++this.level2WordSize;
        }
        if (this.model.getLevel3Lemmas().contains(lemma)) {
            ++this.level3WordSize;
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
    }

    @Override
    public void addingToken(CoreLabel token) {
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }
}

