/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability;

import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.es.SpanishReadabilityModel;
import eu.fbk.utils.core.FrequencyHashSet;
import eu.fbk.utils.gson.JSONExclude;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class Readability {
    private String language = null;
    private int contentWordSize = 0;
    private int contentEasyWordSize = 0;
    private int wordCount = 0;
    private int docLenWithSpaces = 0;
    private int docLenWithoutSpaces = 0;
    private int docLenLettersOnly = 0;
    private int sentenceCount = 0;
    private int tokenCount = 0;
    private int hyphenCount = 0;
    private int hyphenWordCount = 0;
    protected Map<String, Double> measures = new HashMap<String, Double>();
    @JSONExclude
    protected HashSet<String> contentPosList = new HashSet();
    @JSONExclude
    protected HashSet<String> simplePosList = new HashSet();
    @JSONExclude
    protected HashSet<String> nonWordPosList = new HashSet();
    protected HashMap<String, String> genericPosDescription = new HashMap();
    protected HashMap<String, String> posDescription = new HashMap();
    @JSONExclude
    boolean useGenericForContent = true;
    @JSONExclude
    boolean useGenericForSimple = true;
    @JSONExclude
    boolean useGenericForWord = true;
    Set<Integer> tooLongSentences = new HashSet<Integer>();
    FrequencyHashSet<String> posStats = new FrequencyHashSet();
    FrequencyHashSet<String> genericPosStats = new FrequencyHashSet();
    @JSONExclude
    protected Hyphenator hyphenator;
    @JSONExclude
    protected Annotation annotation;

    public int getHyphenWordCount() {
        return this.hyphenWordCount;
    }

    public Readability(String language, Annotation annotation) {
        this.language = language;
        this.annotation = annotation;
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        this.docLenWithSpaces = text.length();
        this.docLenWithoutSpaces = text.replaceAll("\\s+", "").length();
    }

    public abstract void finalizeReadability();

    public abstract void addingContentWord(CoreLabel var1);

    public abstract void addingEasyWord(CoreLabel var1);

    public abstract void addingWord(CoreLabel var1);

    public abstract void addingToken(CoreLabel var1);

    public abstract void addingSentence(CoreMap var1);

    public void addTooLongSentence(Integer sentenceID) {
        this.tooLongSentences.add(sentenceID);
    }

    public Set<Integer> getTooLongSentences() {
        return this.tooLongSentences;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getContentWordSize() {
        return this.contentWordSize;
    }

    public void setContentWordSize(int contentWordSize) {
        this.contentWordSize = contentWordSize;
    }

    public int getContentEasyWordSize() {
        return this.contentEasyWordSize;
    }

    public void setContentEasyWordSize(int contentEasyWordSize) {
        this.contentEasyWordSize = contentEasyWordSize;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public void setWordCount(int wordCount) {
        this.wordCount = wordCount;
    }

    public int getDocLenWithSpaces() {
        return this.docLenWithSpaces;
    }

    public void setDocLenWithSpaces(int docLenWithSpaces) {
        this.docLenWithSpaces = docLenWithSpaces;
    }

    public int getDocLenWithoutSpaces() {
        return this.docLenWithoutSpaces;
    }

    public void setDocLenWithoutSpaces(int docLenWithoutSpaces) {
        this.docLenWithoutSpaces = docLenWithoutSpaces;
    }

    public int getDocLenLettersOnly() {
        return this.docLenLettersOnly;
    }

    public void setDocLenLettersOnly(int docLenLettersOnly) {
        this.docLenLettersOnly = docLenLettersOnly;
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(int sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public void setTokenCount(int tokenCount) {
        this.tokenCount = tokenCount;
    }

    public FrequencyHashSet<String> getPosStats() {
        return this.posStats;
    }

    public FrequencyHashSet<String> getGenericPosStats() {
        return this.genericPosStats;
    }

    public String getTransformedPos(String pos) {
        return pos;
    }

    public int getHyphenCount() {
        return this.hyphenCount;
    }

    public void setHyphenCount(int hyphenCount) {
        this.hyphenCount = hyphenCount;
    }

    public void incrementHyphenCount(int increment) {
        this.hyphenCount += increment;
    }

    public static String flattenToAscii(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void addWord(CoreLabel token) {
        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
        String word = token.word();
        this.addingToken(token);
        if (this.isWordPos(pos)) {
            this.addingWord(token);
            ++this.wordCount;
            this.docLenLettersOnly += token.endPosition() - token.beginPosition();
            word = Readability.flattenToAscii(word);
            Hyphenation hyphenation = this.hyphenator.hyphenate(word);
            boolean done = false;
            if (hyphenation != null) {
                try {
                    String h = hyphenation.toString();
                    this.incrementHyphenCount(hyphenation.length() + 1);
                    token.set(ReadabilityAnnotations.HyphenationAnnotation.class, (Object)h);
                    done = true;
                    ++this.hyphenWordCount;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!done && word.length() < 5) {
                this.incrementHyphenCount(1);
                ++this.hyphenWordCount;
            }
            if (this.isContentPos(pos)) {
                ++this.contentWordSize;
                this.addingContentWord(token);
            }
            if (this.isEasyPos(pos)) {
                ++this.contentEasyWordSize;
                this.addingEasyWord(token);
            }
        }
        if (token.get(ReadabilityAnnotations.HyphenationAnnotation.class) == null) {
            token.set(ReadabilityAnnotations.HyphenationAnnotation.class, (Object)token.originalText());
        }
        String genericPos = this.getGenericPos(pos);
        this.posStats.add((Object)pos);
        this.genericPosStats.add((Object)genericPos);
    }

    protected String getGenericPos(String pos) {
        return pos.substring(0, 1);
    }

    protected boolean getGenericPosInfo(boolean constraint, Set<String> setToCheck, String pos, boolean reverse) {
        if (constraint) {
            pos = this.getGenericPos(pos);
        }
        boolean ret = setToCheck.contains(pos);
        if (reverse) {
            return !ret;
        }
        return ret;
    }

    public static InputStream getStream(String fileName, @Nullable String defaultFileName) throws FileNotFoundException {
        File streamFile;
        if (fileName != null && (streamFile = new File(fileName)).exists()) {
            return new FileInputStream(streamFile);
        }
        InputStream input = SpanishReadabilityModel.class.getResourceAsStream(defaultFileName);
        if (input != null) {
            return input;
        }
        if (defaultFileName != null) {
            return Readability.getStream(defaultFileName, null);
        }
        return null;
    }

    protected boolean isWordPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForWord, this.nonWordPosList, pos, true);
    }

    protected boolean isContentPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForContent, this.contentPosList, pos, false);
    }

    protected boolean isEasyPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForSimple, this.simplePosList, pos, false);
    }

    public String toString() {
        return "Readability{language='" + this.language + '\'' + ", contentWordSize=" + this.contentWordSize + ", contentEasyWordSize=" + this.contentEasyWordSize + ", wordCount=" + this.wordCount + ", docLenWithSpaces=" + this.docLenWithSpaces + ", docLenWithoutSpaces=" + this.docLenWithoutSpaces + ", docLenLettersOnly=" + this.docLenLettersOnly + ", sentenceCount=" + this.sentenceCount + ", tokenCount=" + this.tokenCount + ", hyphenCount=" + this.hyphenCount + ", hyphenWordCount=" + this.hyphenWordCount + ", measures=" + this.measures + ", contentPosList=" + this.contentPosList + ", simplePosList=" + this.simplePosList + ", nonWordPosList=" + this.nonWordPosList + ", tooLongSentences=" + this.tooLongSentences + ", posStats=" + this.posStats + ", genericPosStats=" + this.genericPosStats + '}';
    }
}

