/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class HighlightUtils {
    private HighlightUtils() {
    }

    public static boolean addHighlight(JTextField label, MouseEvent mouseEvent1, MouseEvent mouseEvent2) {
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int firstXpos = mouseEvent1.getX();
        int lastXpos = mouseEvent2.getX();
        int firstOffset = HighlightUtils.getCharOffset(fm, label.getText(), firstXpos);
        int lastOffset = HighlightUtils.getCharOffset(fm, label.getText(), lastXpos);
        if (lastOffset != firstOffset) {
            if (firstOffset > lastOffset) {
                int tmp = firstOffset;
                firstOffset = lastOffset;
                lastOffset = tmp;
            }
            try {
                label.getHighlighter().removeAllHighlights();
                label.getHighlighter().addHighlight(firstOffset, lastOffset, new DefaultHighlighter.DefaultHighlightPainter(Color.yellow));
                return true;
            }
            catch (BadLocationException e1) {
                return false;
            }
        }
        return false;
    }

    public static boolean isInHighlight(MouseEvent e, JTextField label, Highlighter h) {
        Highlighter.Highlight[] hls = h.getHighlights();
        if (hls == null || hls.length == 0) {
            return false;
        }
        Highlighter.Highlight hl = hls[0];
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int offset = HighlightUtils.getCharOffset(fm, label.getText(), e.getX());
        return hl.getStartOffset() <= offset && offset < hl.getEndOffset();
    }

    private static int getCharOffset(FontMetrics fm, String characters, int xPos) {
        int i;
        StringBuilder s = new StringBuilder();
        char[] sArray = characters.toCharArray();
        for (i = 0; i < characters.length() && fm.stringWidth(s.toString()) < xPos; ++i) {
            s.append(sArray[i]);
        }
        return i;
    }
}

