/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.ClauseSplitter;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IterableIterator;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Util {
    public static final Set<String> PRIVATIVE_ADJECTIVES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("believed");
            this.add("debatable");
            this.add("disputed");
            this.add("dubious");
            this.add("hypothetical");
            this.add("impossible");
            this.add("improbable");
            this.add("plausible");
            this.add("putative");
            this.add("questionable");
            this.add("so called");
            this.add("supposed");
            this.add("suspicious");
            this.add("theoretical");
            this.add("uncertain");
            this.add("unlikely");
            this.add("would - be");
            this.add("apparent");
            this.add("arguable");
            this.add("assumed");
            this.add("likely");
            this.add("ostensible");
            this.add("possible");
            this.add("potential");
            this.add("predicted");
            this.add("presumed");
            this.add("probable");
            this.add("seeming");
            this.add("anti");
            this.add("fake");
            this.add("fictional");
            this.add("fictitious");
            this.add("imaginary");
            this.add("mythical");
            this.add("phony");
            this.add("false");
            this.add("artificial");
            this.add("erroneous");
            this.add("mistaken");
            this.add("mock");
            this.add("pseudo");
            this.add("simulated");
            this.add("spurious");
            this.add("deputy");
            this.add("faulty");
            this.add("virtual");
            this.add("doubtful");
            this.add("erstwhile");
            this.add("ex");
            this.add("expected");
            this.add("former");
            this.add("future");
            this.add("onetime");
            this.add("past");
            this.add("proposed");
        }
    });

    public static String guessNER(List<CoreLabel> tokens, Span span) {
        ClassicCounter<String> nerGuesses = new ClassicCounter<String>();
        for (int i : span) {
            nerGuesses.incrementCount(tokens.get(i).ner());
        }
        nerGuesses.remove("O");
        nerGuesses.remove(null);
        if (nerGuesses.size() > 0 && Counters.max(nerGuesses) >= (double)(span.size() / 2)) {
            return (String)Counters.argmax(nerGuesses);
        }
        return "O";
    }

    public static String guessNER(List<CoreLabel> tokens) {
        return Util.guessNER(tokens, new Span(0, tokens.size()));
    }

    public static Span extractNER(List<CoreLabel> tokens, Span seed) {
        int end;
        int begin;
        if (seed == null) {
            return new Span(0, 1);
        }
        if (seed.start() < 0 || seed.end() < 0) {
            return new Span(0, 0);
        }
        if (seed.start() >= tokens.size() || seed.end() > tokens.size()) {
            return new Span(tokens.size(), tokens.size());
        }
        if (tokens.get(seed.start()).ner() == null) {
            return seed;
        }
        if (seed.start() < 0 || seed.end() > tokens.size()) {
            return Span.fromValues(Math.max(0, seed.start()), Math.min(tokens.size(), seed.end()));
        }
        for (begin = seed.start(); begin < seed.end() - 1 && "O".equals(tokens.get(begin).ner()); ++begin) {
        }
        String beginNER = tokens.get(begin).ner();
        if (!"O".equals(beginNER)) {
            while (begin > 0 && tokens.get(begin - 1).ner().equals(beginNER)) {
                --begin;
            }
        } else {
            begin = seed.start();
        }
        for (end = seed.end() - 1; end > begin && "O".equals(tokens.get(end).ner()); --end) {
        }
        String endNER = tokens.get(end).ner();
        if (!"O".equals(endNER)) {
            while (end < tokens.size() - 1 && tokens.get(end + 1).ner().equals(endNER)) {
                ++end;
            }
        } else {
            end = seed.end() - 1;
        }
        if (beginNER.equals(endNER)) {
            return Span.fromValues(begin, end + 1);
        }
        String bestNER = Util.guessNER(tokens, Span.fromValues(begin, end + 1));
        if (beginNER.equals(bestNER)) {
            return Util.extractNER(tokens, Span.fromValues(begin, begin + 1));
        }
        if (endNER.equals(bestNER)) {
            return Util.extractNER(tokens, Span.fromValues(end, end + 1));
        }
        return Span.fromValues(begin, end + 1);
    }

    public static void annotate(CoreMap sentence, AnnotationPipeline pipeline) {
        Annotation ann = new Annotation(StringUtils.join((Iterable)sentence.get(CoreAnnotations.TokensAnnotation.class), " "));
        ann.set(CoreAnnotations.TokensAnnotation.class, sentence.get(CoreAnnotations.TokensAnnotation.class));
        ann.set(CoreAnnotations.SentencesAnnotation.class, Collections.singletonList(sentence));
        pipeline.annotate(ann);
    }

    /*
     * WARNING - void declaration
     */
    public static List<SemanticGraphEdge> cleanTree(SemanticGraph tree) {
        ArrayList<IndexedWord> toDelete = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : tree.vertexSet()) {
            char tag;
            if (vertex.tag() == null || (tag = vertex.backingLabel().tag().charAt(0)) != '.' && tag != ',' && tag != '(' && tag != ')' && tag != ':' || tree.outgoingEdgeIterator(vertex).hasNext()) continue;
            toDelete.add(vertex);
        }
        toDelete.forEach(tree::removeVertex);
        Iterator<SemanticGraphEdge> iter = tree.edgeIterable().iterator();
        while (iter.hasNext()) {
            SemanticGraphEdge edge = iter.next();
            if (edge.getDependent().index() == edge.getGovernor().index()) {
                iter.remove();
                continue;
            }
            if (!edge.getRelation().toString().equals("punct") || tree.outgoingEdgeIterator(edge.getDependent()).hasNext()) continue;
            iter.remove();
        }
        ArrayList<SemanticGraphEdge> extraEdges = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : tree.edgeIterable()) {
            if (!edge.isExtra() || tree.incomingEdgeList(edge.getDependent()).size() <= 1) continue;
            extraEdges.add(edge);
        }
        extraEdges.forEach(tree::removeEdge);
        for (Object extraEdge : new ArrayList(extraEdges)) {
            for (SemanticGraphEdge semanticGraphEdge : tree.incomingEdgeIterable(((SemanticGraphEdge)extraEdge).getDependent())) {
                if (!semanticGraphEdge.getRelation().toString().equals("appos")) continue;
                extraEdges.add(new SemanticGraphEdge(((SemanticGraphEdge)extraEdge).getGovernor(), semanticGraphEdge.getGovernor(), ((SemanticGraphEdge)extraEdge).getRelation(), ((SemanticGraphEdge)extraEdge).getWeight(), ((SemanticGraphEdge)extraEdge).isExtra()));
            }
            for (SemanticGraphEdge semanticGraphEdge : tree.outgoingEdgeIterable(((SemanticGraphEdge)extraEdge).getDependent())) {
                if (!semanticGraphEdge.getRelation().toString().equals("appos")) continue;
                extraEdges.add(new SemanticGraphEdge(((SemanticGraphEdge)extraEdge).getGovernor(), semanticGraphEdge.getDependent(), ((SemanticGraphEdge)extraEdge).getRelation(), ((SemanticGraphEdge)extraEdge).getWeight(), ((SemanticGraphEdge)extraEdge).isExtra()));
            }
        }
        ArrayList<SemanticGraphEdge> rootIncomingEdges = new ArrayList<SemanticGraphEdge>();
        for (IndexedWord root : tree.getRoots()) {
            for (SemanticGraphEdge semanticGraphEdge : tree.incomingEdgeIterable(root)) {
                rootIncomingEdges.add(semanticGraphEdge);
            }
        }
        rootIncomingEdges.forEach(tree::removeEdge);
        boolean changed = true;
        while (changed) {
            changed = false;
            ArrayList<IndexedWord> danglingNodes = new ArrayList<IndexedWord>();
            ArrayList<SemanticGraphEdge> arrayList = new ArrayList<SemanticGraphEdge>();
            for (IndexedWord vertex : tree.vertexSet()) {
                Iterator<SemanticGraphEdge> incomingIter = tree.incomingEdgeIterator(vertex);
                boolean hasIncoming = incomingIter.hasNext();
                boolean hasMultipleIncoming = false;
                if (hasIncoming) {
                    incomingIter.next();
                    hasMultipleIncoming = incomingIter.hasNext();
                }
                if (!hasIncoming && !tree.getRoots().contains(vertex)) {
                    danglingNodes.add(vertex);
                    continue;
                }
                if (!hasMultipleIncoming) continue;
                for (SemanticGraphEdge edge : new IterableIterator<SemanticGraphEdge>(incomingIter)) {
                    arrayList.add(edge);
                }
            }
            for (IndexedWord vertex : danglingNodes) {
                tree.removeVertex(vertex);
                changed = true;
            }
            for (SemanticGraphEdge edge : arrayList) {
                tree.removeEdge(edge);
                changed = true;
            }
        }
        for (IndexedWord indexedWord : tree.vertexSet()) {
            void var8_25;
            Object var8_24 = null;
            int dobjCount = 0;
            for (SemanticGraphEdge edge : tree.outgoingEdgeIterable(indexedWord)) {
                if ("that".equalsIgnoreCase(edge.getDependent().word())) {
                    SemanticGraphEdge semanticGraphEdge = edge;
                }
                if (!"dobj".equals(edge.getRelation().toString())) continue;
                ++dobjCount;
            }
            if (dobjCount <= true || var8_25 == null) continue;
            tree.removeEdge((SemanticGraphEdge)var8_25);
            tree.addEdge(var8_25.getGovernor(), var8_25.getDependent(), GrammaticalRelation.valueOf(var8_25.getRelation().getLanguage(), "mark"), var8_25.getWeight(), var8_25.isExtra());
        }
        assert (Util.isTree(tree));
        return extraEdges;
    }

    public static void stripPrepCases(SemanticGraph tree) {
        ArrayList<SemanticGraphEdge> toClean = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : tree.edgeIterable()) {
            if (!"case".equals(edge.getRelation().toString())) continue;
            boolean isPrepTarget = false;
            for (SemanticGraphEdge incoming : tree.incomingEdgeIterable(edge.getGovernor())) {
                if (!"nmod".equals(incoming.getRelation().getShortName())) continue;
                isPrepTarget = true;
                break;
            }
            if (!isPrepTarget || tree.outgoingEdgeIterator(edge.getDependent()).hasNext()) continue;
            toClean.add(edge);
        }
        for (SemanticGraphEdge edge : toClean) {
            tree.removeEdge(edge);
            tree.removeVertex(edge.getDependent());
            assert (Util.isTree(tree));
        }
    }

    public static boolean isCyclic(SemanticGraph tree) {
        for (IndexedWord vertex : tree.vertexSet()) {
            if (tree.getRoots().contains(vertex)) continue;
            IndexedWord node = tree.incomingEdgeIterator(vertex).next().getGovernor();
            HashSet<IndexedWord> seen = new HashSet<IndexedWord>();
            seen.add(vertex);
            while (node != null) {
                if (seen.contains(node)) {
                    return true;
                }
                seen.add(node);
                if (tree.incomingEdgeIterator(node).hasNext()) {
                    node = tree.incomingEdgeIterator(node).next().getGovernor();
                    continue;
                }
                node = null;
            }
        }
        return false;
    }

    public static boolean isTree(SemanticGraph tree) {
        for (IndexedWord vertex : tree.vertexSet()) {
            boolean foundReverse;
            if (tree.getRoots().contains(vertex)) {
                if (tree.incomingEdgeIterator(vertex).hasNext()) {
                    return false;
                }
            } else {
                Iterator<SemanticGraphEdge> iter = tree.incomingEdgeIterator(vertex);
                if (!iter.hasNext()) {
                    return false;
                }
                iter.next();
                if (iter.hasNext()) {
                    return false;
                }
            }
            for (SemanticGraphEdge edge : tree.outgoingEdgeIterable(vertex)) {
                foundReverse = false;
                for (SemanticGraphEdge reverse : tree.incomingEdgeIterable(edge.getDependent())) {
                    if (reverse != edge) continue;
                    foundReverse = true;
                }
                if (foundReverse) continue;
                return false;
            }
            for (SemanticGraphEdge edge : tree.incomingEdgeIterable(vertex)) {
                foundReverse = false;
                for (SemanticGraphEdge reverse : tree.outgoingEdgeIterable(edge.getGovernor())) {
                    if (reverse != edge) continue;
                    foundReverse = true;
                }
                if (foundReverse) continue;
                return false;
            }
        }
        return !Util.isCyclic(tree);
    }

    public static boolean nerOverlap(List<CoreLabel> tokens, Span a, Span b, Optional<SemanticGraph> parse) {
        Span nerA = Util.extractNER(tokens, a);
        Span nerB = Util.extractNER(tokens, b);
        return nerA.equals(nerB);
    }

    public static boolean nerOverlap(List<CoreLabel> tokens, Span a, Span b) {
        return Util.nerOverlap(tokens, a, b, Optional.empty());
    }

    public static void dumpAccuracy(Classifier<ClauseSplitter.ClauseClassifierLabel, String> classifier, GeneralDataset<ClauseSplitter.ClauseClassifierLabel, String> dataset) {
        DecimalFormat df = new DecimalFormat("0.00%");
        Redwood.log("size:         " + dataset.size());
        Redwood.log("split count:  " + StreamSupport.stream(dataset.spliterator(), false).filter(x -> x.label() == ClauseSplitter.ClauseClassifierLabel.CLAUSE_SPLIT).collect(Collectors.toList()).size());
        Redwood.log("interm count: " + StreamSupport.stream(dataset.spliterator(), false).filter(x -> x.label() == ClauseSplitter.ClauseClassifierLabel.CLAUSE_INTERM).collect(Collectors.toList()).size());
        Pair<Double, Double> pr = classifier.evaluatePrecisionAndRecall(dataset, ClauseSplitter.ClauseClassifierLabel.CLAUSE_SPLIT);
        Redwood.log("p  (split):   " + df.format(pr.first));
        Redwood.log("r  (split):   " + df.format(pr.second));
        Redwood.log("f1 (split):   " + df.format(2.0 * (Double)pr.first * (Double)pr.second / ((Double)pr.first + (Double)pr.second)));
        pr = classifier.evaluatePrecisionAndRecall(dataset, ClauseSplitter.ClauseClassifierLabel.CLAUSE_INTERM);
        Redwood.log("p  (interm):  " + df.format(pr.first));
        Redwood.log("r  (interm):  " + df.format(pr.second));
        Redwood.log("f1 (interm):  " + df.format(2.0 * (Double)pr.first * (Double)pr.second / ((Double)pr.first + (Double)pr.second)));
    }

    public static Span tokensToSpan(List<? extends HasIndex> tokens) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (HasIndex hasIndex : tokens) {
            min = Math.min(hasIndex.index() - 1, min);
            max = Math.max(hasIndex.index(), max);
        }
        if (min < 0 || max == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Could not compute span from tokens!");
        }
        if (min >= max) {
            throw new IllegalStateException("Either logic is broken or Gabor can't code.");
        }
        return new Span(min, max);
    }
}

