/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import java.io.OutputStream;
import java.security.MessageDigest;

public abstract class SecurityHandler {
    protected byte[] mkey = new byte[0];
    protected byte[] nextObjectKey;
    protected int nextObjectKeySize;
    protected MessageDigest md5;
    protected byte[] extra = new byte[5];

    protected SecurityHandler() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
    }

    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
        this.md5.reset();
        this.extra[0] = (byte)objNumber;
        this.extra[1] = (byte)(objNumber >> 8);
        this.extra[2] = (byte)(objNumber >> 16);
        this.extra[3] = (byte)objGeneration;
        this.extra[4] = (byte)(objGeneration >> 8);
        this.md5.update(this.mkey);
        this.md5.update(this.extra);
        this.nextObjectKey = this.md5.digest();
        this.nextObjectKeySize = this.mkey.length + 5;
        if (this.nextObjectKeySize > 16) {
            this.nextObjectKeySize = 16;
        }
    }

    public abstract OutputStreamEncryption getEncryptionStream(OutputStream var1);

    public abstract IDecryptor getDecryptor();
}

