/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

public class LinkingTag
implements Serializable {
    private int offset;
    private String page;
    private double score;
    private String originalText;
    private int length;
    private String source;
    private boolean spotted = true;
    private String image;
    private HashMap<Category, HashSet<String>> types = new HashMap();

    public LinkingTag(int offset, String page, double score, String originalText, int length, String source) {
        this.offset = offset;
        this.page = page;
        this.score = score;
        this.originalText = originalText;
        this.length = length;
        this.source = source;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void addType(Category category, String type) {
        if (this.types.get((Object)category) == null) {
            this.types.put(category, new HashSet());
        }
        this.types.get((Object)category).add(type);
    }

    public void addTypesFromML(ArrayList classes) {
        for (Object aClass : classes) {
            LinkedHashMap map = (LinkedHashMap)aClass;
            String type = (String)map.get("label");
            type = type.replaceAll("\\s+", "");
            this.addType(Category.DBPEDIA, type);
        }
    }

    public void addTypesFromDBpedia(String types) {
        String[] parts;
        block8: for (String catType : parts = types.split(",")) {
            String[] typeParts = (catType = catType.trim()).split(":");
            if (typeParts.length < 2) continue;
            String cat = typeParts[0].trim();
            String type = typeParts[1].trim();
            switch (cat.toLowerCase()) {
                case "dbpedia": {
                    this.addType(Category.DBPEDIA, type);
                    continue block8;
                }
                case "schema": {
                    this.addType(Category.SCHEMA, type);
                }
            }
        }
    }

    public HashMap<String, HashSet<String>> getStringTypes() {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        for (Category category : this.types.keySet()) {
            String catString = category.toString();
            ret.put(catString, new HashSet());
            ret.get(catString).addAll((Collection<String>)this.types.get((Object)category));
        }
        return ret;
    }

    public HashMap<Category, HashSet<String>> getTypes() {
        return this.types;
    }

    public void setTypes(HashMap<Category, HashSet<String>> types) {
        this.types = types;
    }

    public String toString() {
        return "DBpediaSpotlightTag{offset=" + this.offset + ", page='" + this.page + '\'' + ", score=" + this.score + ", originalText='" + this.originalText + '\'' + ", length=" + this.length + ", source=" + this.source + ", spotted=" + this.spotted + ", types=" + this.types + '}';
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSpotted(boolean spotted) {
        this.spotted = spotted;
    }

    public boolean isSpotted() {
        return this.spotted;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkingTag) {
            return ((LinkingTag)obj).getPage().equals(this.getPage());
        }
        return false;
    }

    public static enum Category {
        DBPEDIA,
        SCHEMA;

    }
}

