/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dkm.pikes.twm.DBpediaSpotlightAnnotate;
import eu.fbk.dkm.pikes.twm.DBpediaSpotlightCandidates;
import eu.fbk.dkm.pikes.twm.Linking;
import eu.fbk.dkm.pikes.twm.LinkingTag;
import eu.fbk.dkm.pikes.twm.MachineLinking;
import eu.fbk.dkm.pikes.twm.TWMAnnotations;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.EOFException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class LinkingAnnotator
implements Annotator {
    Linking tagger;
    public static final String DBPS_ANNOTATOR = "dbpedia-candidates";
    private static HashMap<String, Class<? extends Linking>> annotators = new HashMap();

    public LinkingAnnotator(String annotatorName, Properties props) throws Exception {
        Properties newProps = PropertiesUtils.dotConvertedProperties((Properties)props, (String)annotatorName);
        String annotator = newProps.getProperty("annotator", DBPS_ANNOTATOR);
        Class<? extends Linking> myClass = annotators.get(annotator);
        Constructor<? extends Linking> myConstructor = myClass.getConstructor(Properties.class);
        this.tagger = myConstructor.newInstance(newProps);
    }

    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        if (text == null) {
            throw new RuntimeException("Text is null");
        }
        List<Object> tags = new ArrayList();
        try {
            tags = this.tagger.tag(text);
        }
        catch (EOFException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List annotatedEntities = (List)annotation.get(TWMAnnotations.LinkingAnnotations.class);
        ArrayList<LinkingTag> entities = new ArrayList<LinkingTag>();
        if (annotatedEntities != null) {
            entities.addAll(annotatedEntities);
        }
        HashMap<Integer, LinkingTag> index = new HashMap<Integer, LinkingTag>();
        for (LinkingTag linkingTag : tags) {
            entities.add(linkingTag);
            int end = linkingTag.getOffset() + linkingTag.getLength();
            for (int i = linkingTag.getOffset(); i < end; ++i) {
                index.put(i, linkingTag);
            }
        }
        annotation.set(TWMAnnotations.LinkingAnnotations.class, entities);
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap coreMap : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)coreMap.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel token : tokens) {
                    LinkingTag endEntity;
                    LinkingTag startEntity = (LinkingTag)index.get(token.beginPosition());
                    if (startEntity == null || (endEntity = (LinkingTag)index.get(token.endPosition() - 1)) == null || !startEntity.equals(endEntity)) continue;
                    token.set(TWMAnnotations.DBpediaSpotlightAnnotation.class, (Object)startEntity);
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet((Object[])new Annotator.Requirement[]{TWMAnnotations.DBPS_REQUIREMENT, TWMAnnotations.LINKING_REQUIREMENT}));
    }

    public Set<Annotator.Requirement> requires() {
        return Annotator.TOKENIZE_AND_SSPLIT;
    }

    static {
        annotators.put(DBPS_ANNOTATOR, DBpediaSpotlightCandidates.class);
        annotators.put("dbpedia-annotate", DBpediaSpotlightAnnotate.class);
        annotators.put("ml-annotate", MachineLinking.class);
    }
}

