/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import eu.fbk.dkm.pikes.twm.Linking;
import eu.fbk.dkm.pikes.twm.LinkingTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jackson.map.ObjectMapper;

public class DBpediaSpotlightCandidates
extends Linking {
    private static String LABEL = "dbpedia-candidates";
    private String firstAttemptConfidence;
    private String confidence;
    public static final double DBPSC_MIN_CONFIDENCE = 0.01;
    public static final double DBPSC_FIRST_CONFIDENCE = 0.5;

    public DBpediaSpotlightCandidates(Properties properties) {
        super(properties, properties.getProperty("address", "http://spotlight.sztaki.hu:2222/rest") + "/candidates");
        this.firstAttemptConfidence = properties.getProperty("first_confidence", Double.toString(0.5));
        this.confidence = properties.getProperty("min_confidence", Double.toString(0.01));
    }

    private List<LinkingTag> attempt(Map<String, String> pars) throws IOException {
        ArrayList<LinkingTag> ret = new ArrayList<LinkingTag>();
        String output = this.request(pars);
        LOGGER.trace(output);
        ObjectMapper mapper = new ObjectMapper();
        Map userData = (Map)mapper.readValue(output, Map.class);
        LinkedHashMap annotation = (LinkedHashMap)userData.get(new String("annotation"));
        if (annotation != null) {
            ArrayList surfaceForms = new ArrayList();
            Object surfaceFormJson = annotation.get(new String("surfaceForm"));
            if (surfaceFormJson instanceof ArrayList) {
                surfaceForms = (ArrayList)surfaceFormJson;
            } else {
                surfaceForms.add((LinkedHashMap)surfaceFormJson);
            }
            for (LinkedHashMap keyword : surfaceForms) {
                Object res = keyword.get("resource");
                if (res instanceof ArrayList) {
                    ArrayList resources = (ArrayList)res;
                    for (Object resourceObj : resources) {
                        LinkedHashMap resource = (LinkedHashMap)resourceObj;
                        LinkingTag tag = this.tagFromResource(resource, keyword);
                        ret.add(tag);
                    }
                    continue;
                }
                LinkedHashMap resource = (LinkedHashMap)res;
                LinkingTag tag = this.tagFromResource(resource, keyword);
                ret.add(tag);
            }
        }
        return ret;
    }

    @Override
    public List<LinkingTag> tag(String text) throws Exception {
        ArrayList<LinkingTag> ret = new ArrayList<LinkingTag>();
        HashSet<Integer> offsets = new HashSet<Integer>();
        LOGGER.debug("First attempt with confidence {}", (Object)this.firstAttemptConfidence);
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("confidence", this.firstAttemptConfidence);
        pars.put("text", text);
        List<LinkingTag> firstAttempt = this.attempt(pars);
        for (LinkingTag tag : firstAttempt) {
            offsets.add(tag.getOffset());
        }
        LOGGER.debug("Second attempt with confidence {}", (Object)this.confidence);
        pars = new HashMap();
        pars.put("confidence", this.confidence);
        pars.put("text", text);
        List<LinkingTag> secondAttempt = this.attempt(pars);
        for (LinkingTag tag : secondAttempt) {
            if (offsets.contains(tag.getOffset())) {
                ret.add(tag);
                continue;
            }
            tag.setSpotted(false);
            ret.add(tag);
        }
        return ret;
    }

    private LinkingTag tagFromResource(LinkedHashMap resource, LinkedHashMap keyword) {
        String originalText = (String)keyword.get("@name");
        LinkingTag tag = new LinkingTag(Integer.parseInt((String)keyword.get("@offset")), String.format("http://dbpedia.org/resource/%s", (String)resource.get("@uri")), Double.parseDouble((String)resource.get("@finalScore")), originalText, originalText.length(), LABEL);
        if (this.extractTypes.booleanValue()) {
            tag.addTypesFromDBpedia((String)resource.get("@types"));
        }
        return tag;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("address", "https://knowledgestore2.fbk.eu/dbps/rest/candidates");
        properties.setProperty("use_proxy", "0");
        properties.setProperty("proxy_url", "proxy.fbk.eu");
        properties.setProperty("proxy_port", "3128");
        properties.setProperty("min_confidence", "0.01");
        properties.setProperty("timeout", "2000");
        DBpediaSpotlightCandidates s = new DBpediaSpotlightCandidates(properties);
        try {
            String text = "First documented in the 13th century, Berlin was the capital of the Kingdom of Prussia (1701\u20131918), the German Empire (1871\u20131918), the Weimar Republic (1919\u201333) and the Third Reich (1933\u201345).";
            List<LinkingTag> tags = s.tag(text);
            for (LinkingTag tag : tags) {
                System.out.println(tag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
    }
}

