/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eu.fbk.dkm.pikes.twm.Linking;
import eu.fbk.dkm.pikes.twm.LinkingTag;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jackson.map.ObjectMapper;

public class DBpediaSpotlightAnnotate
extends Linking {
    private static String LABEL = "dbpedia-annotate";
    private String confidence;
    public static final String DBPS_ADDRESS = "http://spotlight.sztaki.hu:2222/rest";
    public static final double DBPS_MIN_CONFIDENCE = 0.33;

    public DBpediaSpotlightAnnotate(Properties properties) {
        super(properties, properties.getProperty("address", DBPS_ADDRESS) + "/annotate");
        this.confidence = properties.getProperty("min_confidence", Double.toString(0.33));
    }

    @Override
    public List<LinkingTag> tag(String text) throws Exception {
        ArrayList<LinkingTag> ret = new ArrayList<LinkingTag>();
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("confidence", this.confidence);
        pars.put("text", text);
        String output = this.request(pars);
        ObjectMapper mapper = new ObjectMapper();
        Map userData = (Map)mapper.readValue(output, Map.class);
        ArrayList annotation = (ArrayList)userData.get(new String("Resources"));
        if (annotation != null) {
            for (LinkedHashMap keyword : annotation) {
                String originalText = (String)keyword.get("@surfaceForm");
                if (originalText == null) continue;
                LinkingTag tag = new LinkingTag(Integer.parseInt((String)keyword.get("@offset")), (String)keyword.get("@URI"), Double.parseDouble((String)keyword.get("@similarityScore")), originalText, originalText.length(), LABEL);
                if (this.extractTypes.booleanValue()) {
                    tag.addTypesFromDBpedia((String)keyword.get("@types"));
                }
                ret.add(tag);
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("address", "https://knowledgestore2.fbk.eu/dbps/rest/annotate");
        properties.setProperty("use_proxy", "0");
        properties.setProperty("proxy_url", "proxy.fbk.eu");
        properties.setProperty("proxy_port", "3128");
        properties.setProperty("min_confidence", "0.05");
        properties.setProperty("timeout", "2000");
        DBpediaSpotlightAnnotate s = new DBpediaSpotlightAnnotate(properties);
        try {
            String text = Files.toString((File)new File("/Users/alessio/Desktop/elastic/test-dbps.txt"), (Charset)Charsets.UTF_8);
            List<LinkingTag> tags = s.tag(text);
            for (LinkingTag tag : tags) {
                System.out.println(tag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
    }
}

