/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph;

import eu.fbk.dh.tint.digimorph.DigiMorph;
import java.util.LinkedList;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private static void printUsage(Options opt) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("echo <word> | java -jar DigiMorph.jar \n       cat <path to file> | java -jar DigiMorph.jar\n\n", opt);
        System.exit(1);
    }

    private static void retrain(String filepath, boolean include_lemma) {
        DigiMorph dm = new DigiMorph("italian.db");
        dm.re_train(filepath, include_lemma);
        System.exit(0);
    }

    public static void main(String[] args) {
        String line;
        Options options = new Options();
        options.addOption(Option.builder((String)"r").hasArg().argName("path to file").desc("Retrain Morphological Analyzer").build());
        options.addOption("h", "help", false, "show help");
        options.addOption("l", "lemma", false, "include lemma");
        options.addOption("v", "version", false, "print the tool version");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("version")) {
                System.out.println(DigiMorph.getVersion());
                System.exit(0);
            }
            if (cmd.hasOption("help")) {
                Main.printUsage(options);
            }
            if (cmd.hasOption('r')) {
                if (cmd.getOptionValue('r') != null) {
                    Main.retrain(cmd.getOptionValue('r'), cmd.hasOption("lemma"));
                } else {
                    Main.printUsage(options);
                }
            }
        }
        catch (Exception e) {
            Main.printUsage(options);
        }
        LinkedList<String> text = new LinkedList<String>();
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextLine() && (line = scanner.nextLine()).compareToIgnoreCase("morph()") != 0) {
            text.add(line);
        }
        DigiMorph dm = new DigiMorph();
        for (String s : dm.getMorphology(text)) {
            System.out.println(s);
        }
    }
}

