/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.mapdb.SortedTableMap;

public class DigiMorph_Analizer
implements Callable<List<String>> {
    private SortedTableMap<String, String> map = null;
    List<String> tokens;
    private ArrayList<String> prefix = new ArrayList(){
        {
            this.add("anti");
            this.add("ante");
            this.add("arci");
            this.add("inter");
            this.add("super");
            this.add("trans");
            this.add("ultra");
            this.add("tri");
            this.add("bi");
            this.add("xeno");
            this.add("zoo");
            this.add("circon");
            this.add("circom");
            this.add("in");
        }
    };
    private ArrayList<String> suffix = new ArrayList(){
        {
            this.add("li");
            this.add("lo");
            this.add("la");
            this.add("le");
            this.add("ci");
            this.add("vi");
            this.add("ti");
            this.add("mi");
            this.add("si");
            this.add("ne");
            this.add("gli");
            this.add("glielo");
            this.add("gliela");
            this.add("gliele");
            this.add("gliene");
        }
    };
    private ArrayList<String> middle_suffix = new ArrayList(){
        {
            this.add("ci");
            this.add("vi");
            this.add("ce");
            this.add("me");
            this.add("te");
            this.add("ve");
            this.add("se");
        }
    };

    public DigiMorph_Analizer(List<String> tokens, SortedTableMap<String, String> map) {
        this.tokens = tokens;
        this.map = map;
    }

    @Override
    public List<String> call() {
        LinkedList<String> results = new LinkedList<String>();
        for (String s : this.tokens) {
            results.add(this.getMorphology(s));
        }
        return results;
    }

    public String getMorphology(String token) {
        String original_token = token;
        String output = "";
        String no_prefix_phase = this.process_token(token);
        if (no_prefix_phase.length() == 0) {
            for (String p : this.prefix) {
                String prefix_phase;
                if (!token.startsWith(p) || (prefix_phase = this.process_token(token = token.substring(p.length(), token.length()))).length() <= 0) continue;
                String prefisso = this.process_token(p);
                output = p + "/" + prefix_phase.replace(" ", " " + p);
            }
        } else {
            output = no_prefix_phase;
        }
        if (output.length() == 0) {
            return original_token;
        }
        return output;
    }

    private String process_token(String token) {
        String orginal_token = token;
        token = token.toLowerCase();
        StringBuffer out_buffer = new StringBuffer();
        String basic_result = (String)this.map.get((Object)token);
        out_buffer.append(basic_result != null ? basic_result : "");
        String suffix_substring = "";
        if (token.endsWith("gli")) {
            suffix_substring = "gli";
        } else {
            for (String suf : this.suffix) {
                if (!token.endsWith(suf)) continue;
                suffix_substring = suf;
            }
        }
        if (suffix_substring.length() > 0) {
            String possible_verb;
            String head = token.substring(0, token.length() - suffix_substring.length());
            String middle_suffix_substring = "";
            for (String suf : this.middle_suffix) {
                if (!head.endsWith(suf)) continue;
                middle_suffix_substring = suf;
            }
            head = head.substring(0, head.length() - middle_suffix_substring.length());
            String possible_middle_suffix = middle_suffix_substring.length() > 0 ? (String)this.map.get((Object)middle_suffix_substring) : "";
            String possible_suffix = suffix_substring.length() > 0 ? (String)this.map.get((Object)suffix_substring) : "";
            boolean ends_with_double = false;
            char head_ending = '\u0000';
            if (head.length() > 0) {
                head_ending = head.charAt(head.length() - 1);
            }
            char close_suffix_head = '\u0000';
            if (possible_middle_suffix.length() > 0) {
                close_suffix_head = middle_suffix_substring.charAt(0);
            } else if (possible_suffix.length() > 0) {
                close_suffix_head = suffix_substring.charAt(0);
            }
            if (head_ending == close_suffix_head) {
                head = head.substring(0, head.length() - 1);
                possible_verb = (String)this.map.get((Object)head);
            } else {
                possible_verb = (String)this.map.get((Object)(head + "e"));
            }
            if (possible_verb == null && head.endsWith("r")) {
                possible_verb = (String)this.map.get((Object)(head + "re"));
            } else if (possible_verb == null) {
                possible_verb = (String)this.map.get((Object)head);
            }
            if (possible_verb == null && possible_middle_suffix.length() > 0) {
                head = head + middle_suffix_substring;
                middle_suffix_substring = "";
                possible_middle_suffix = "";
                possible_verb = (String)this.map.get((Object)head);
            }
            if (possible_verb != null) {
                String inf = "";
                String suf = "";
                String mid_suf = "";
                String[] verb_items = possible_verb.split(" ");
                String[] suffix_items = possible_suffix.split(" ");
                String[] mid_suffix_items = possible_middle_suffix.split(" ");
                ArrayList<String> infiniti = new ArrayList<String>();
                ArrayList<String> mid_suff = new ArrayList<String>();
                ArrayList<String> suff = new ArrayList<String>();
                for (String v : verb_items) {
                    if (!v.contains("+infinito") && !v.contains("impr") && !v.contains("part") && !v.contains("gerundio")) continue;
                    infiniti.add(" " + v);
                    inf = inf + " " + v;
                }
                for (String f : mid_suffix_items) {
                    if (!f.contains("+pron")) continue;
                    mid_suff.add("/" + f);
                }
                for (String f : suffix_items) {
                    if (!f.contains("+pron")) continue;
                    suff.add("/" + f);
                }
                ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>();
                lists.add(infiniti);
                lists.add(mid_suff);
                lists.add(suff);
                ArrayList<String> results = new ArrayList<String>();
                if (inf.length() > 0) {
                    if (mid_suff.size() > 0) {
                        for (String verb_hypernym : infiniti) {
                            for (String object_hypernym : mid_suff) {
                                for (String subject_hypernym : suff) {
                                    results.add(verb_hypernym + object_hypernym + subject_hypernym);
                                }
                            }
                        }
                    } else {
                        for (String verb_hypernym : infiniti) {
                            for (String subject_hypernym : suff) {
                                results.add(verb_hypernym + subject_hypernym);
                            }
                        }
                    }
                    out_buffer.append(Joiner.on((String)" ").join(results));
                }
            }
        }
        if (out_buffer.length() == 0) {
            return "";
        }
        return orginal_token + out_buffer.toString();
    }
}

