/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.Iterator;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2IntHashMap;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet_impl;

public class CasCopier {
    private static final int FRC_SKIP = 0;
    private static final int FRC_STRING = 1;
    private static final int FRC_LONG = 2;
    private static final int FRC_DOUBLE = 3;
    private static final int FRC_INT_LIKE = 4;
    private static final int FRC_REF = 5;
    private static final int K_SRC_FEAT_OFFSET = 0;
    private static final int K_TGT_FEAT_CODE = 1;
    private final TypeInfo[] tInfoArray;
    private final CAS originalSrcCas;
    private final CAS originalTgtCas;
    private final CASImpl originalSrcCasImpl;
    private final CASImpl originalTgtCasImpl;
    private CASImpl srcCasViewImpl;
    private CASImpl tgtCasViewImpl;
    private String srcViewName;
    private String tgtViewName;
    private final TypeSystemImpl srcTsi;
    private final TypeSystemImpl tgtTsi;
    private final TypeImpl srcStringType;
    private final int srcStringTypeCode;
    private boolean isChangeViewName = false;
    private int srcCasDocumentAnnotation = 0;
    private final Feature mDestSofaFeature;
    private final int mDestSofaFeatureCode;
    private final int srcSofaTypeCode;
    private final boolean lenient;
    private final Int2IntHashMap mFsMap = new Int2IntHashMap();
    private IntVector fsToDo = new IntVector();

    public CasCopier(CAS aSrcCas, CAS aDestCas) {
        this(aSrcCas, aDestCas, false);
    }

    public CasCopier(CAS aSrcCas, CAS aDestCas, boolean lenient) {
        this.originalSrcCas = aSrcCas;
        this.originalTgtCas = aDestCas;
        this.originalSrcCasImpl = (CASImpl)aSrcCas.getLowLevelCAS();
        this.originalTgtCasImpl = (CASImpl)aDestCas.getLowLevelCAS();
        this.srcTsi = this.originalSrcCasImpl.getTypeSystemImpl();
        this.tgtTsi = this.originalTgtCasImpl.getTypeSystemImpl();
        this.tInfoArray = new TypeInfo[this.srcTsi.getLargestTypeCode() + 1];
        this.srcStringType = this.srcTsi.stringType;
        this.srcStringTypeCode = this.srcStringType.getCode();
        this.mDestSofaFeature = aDestCas.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
        this.mDestSofaFeatureCode = ((FeatureImpl)this.mDestSofaFeature).getCode();
        this.srcSofaTypeCode = this.originalSrcCasImpl.getTypeSystemImpl().sofaType.getCode();
        this.lenient = lenient;
        this.srcCasViewImpl = (CASImpl)this.originalSrcCas.getLowLevelCAS();
        this.tgtCasViewImpl = (CASImpl)this.originalTgtCas.getLowLevelCAS();
        this.srcViewName = this.srcCasViewImpl.getViewName();
        this.tgtViewName = this.tgtCasViewImpl.getViewName();
        this.isChangeViewName = this.srcViewName == null ? this.tgtViewName != null : !this.srcViewName.equals(this.tgtViewName);
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa) {
        CasCopier.copyCas(aSrcCas, aDestCas, aCopySofa, false);
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa, boolean lenient) {
        CasCopier copier = new CasCopier(aSrcCas, aDestCas, lenient);
        if (copier.originalSrcCasImpl.getBaseCAS() == copier.originalTgtCasImpl.getBaseCAS()) {
            throw new UIMARuntimeException("illegal_cas_copy_to_same_cas", null);
        }
        Iterator<CAS> viewIterator = aSrcCas.getViewIterator();
        while (viewIterator.hasNext()) {
            CAS view = viewIterator.next();
            copier.copyCasView(view, aCopySofa);
        }
    }

    public void copyCasView(CAS aSrcCasView, boolean aCopySofa) {
        this.copyCasViewDifferentCASs(aSrcCasView, CasCopier.getOrCreateView(this.originalTgtCas, aSrcCasView.getViewName()), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, boolean aCopySofa) {
        this.copyCasView(CasCopier.getOrCreateView(this.originalSrcCas, aSrcCasViewName), aCopySofa);
    }

    public void copyCasView(CAS aSrcCasView, String aTgtCasViewName, boolean aCopySofa) {
        this.copyCasView(aSrcCasView, (CAS)CasCopier.getOrCreateView(this.originalTgtCas, aTgtCasViewName), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, CAS aTgtCasView, boolean aCopySofa) {
        this.copyCasView((CAS)CasCopier.getOrCreateView(this.originalSrcCas, aSrcCasViewName), aTgtCasView, aCopySofa);
    }

    private void copyCasViewDifferentCASs(CAS aSrcCasView, CAS aTgtCasView, boolean aCopySofa) {
        if (this.originalSrcCasImpl.getBaseCAS() == this.originalTgtCasImpl.getBaseCAS()) {
            throw new UIMARuntimeException("illegal_cas_copy_to_same_cas", null);
        }
        this.copyCasView(aSrcCasView, aTgtCasView, aCopySofa);
    }

    public void copyCasView(CAS aSrcCasView, CAS aTgtCasView, boolean aCopySofa) {
        SofaFS sofa;
        if (!this.casViewsInSameCas(aSrcCasView, this.originalSrcCas)) {
            throw new UIMARuntimeException("view_not_part_of_cas", new Object[]{"Source"});
        }
        if (!this.casViewsInSameCas(aTgtCasView, this.originalTgtCas)) {
            throw new UIMARuntimeException("view_not_part_of_cas", new Object[]{"Destination"});
        }
        this.srcCasViewImpl = (CASImpl)aSrcCasView.getLowLevelCAS();
        this.tgtCasViewImpl = (CASImpl)aTgtCasView.getLowLevelCAS();
        this.srcViewName = this.srcCasViewImpl.getViewName();
        this.tgtViewName = this.tgtCasViewImpl.getViewName();
        boolean bl = this.isChangeViewName = !this.srcViewName.equals(this.tgtViewName);
        if (aSrcCasView == this.srcCasViewImpl.getBaseCAS() || aTgtCasView == this.tgtCasViewImpl.getBaseCAS()) {
            throw new UIMARuntimeException("unsupported_cas_copy_view_base_cas", null);
        }
        this.srcCasDocumentAnnotation = 0;
        if (aCopySofa && null != (sofa = this.srcCasViewImpl.getSofa())) {
            String sofaMime = sofa.getSofaMime();
            if (this.srcCasViewImpl.getDocumentText() != null) {
                aTgtCasView.setSofaDataString(this.srcCasViewImpl.getDocumentText(), sofaMime);
            } else if (this.srcCasViewImpl.getSofaDataURI() != null) {
                aTgtCasView.setSofaDataURI(this.srcCasViewImpl.getSofaDataURI(), sofaMime);
            } else if (this.srcCasViewImpl.getSofaDataArray() != null) {
                aTgtCasView.setSofaDataArray(this.copyFs2Fs(this.srcCasViewImpl.getSofaDataArray()), sofaMime);
            }
        }
        PositiveIntSet_impl indexedFs = new PositiveIntSet_impl();
        LowLevelIterator it = ((FSIndexRepositoryImpl)this.srcCasViewImpl.getIndexRepository()).ll_getAllIndexedFS(this.srcTsi.getTopType());
        while (it.isValid()) {
            int sofaRef;
            int fs = it.ll_get();
            it.moveToNext();
            if (indexedFs.contains(fs)) continue;
            int copyOfFs = this.copyFs2(fs);
            if (this.lenient && copyOfFs == 0) continue;
            if (this.originalSrcCasImpl.isSubtypeOfAnnotationBaseType(this.originalSrcCasImpl.getTypeCode(fs)) && 0 == (sofaRef = this.tgtCasViewImpl.ll_getRefValue(copyOfFs, this.mDestSofaFeatureCode))) {
                this.tgtCasViewImpl.ll_setRefValue(copyOfFs, this.mDestSofaFeatureCode, this.tgtCasViewImpl.getSofaRef());
            }
            if (!this.isDocumentAnnotation(fs)) {
                this.tgtCasViewImpl.ll_getIndexRepository().ll_addFS(copyOfFs);
            }
            indexedFs.add(fs);
        }
    }

    public FeatureStructure copyFs(FeatureStructure aFS) {
        if (null == this.srcCasViewImpl) {
            this.srcCasViewImpl = this.originalSrcCasImpl;
        }
        if (null == this.tgtCasViewImpl) {
            this.tgtCasViewImpl = this.originalTgtCasImpl;
        }
        this.srcCasDocumentAnnotation = 0;
        return this.copyFs2Fs(aFS);
    }

    private int copyFs2(int aFS) {
        int copy = this.copyFsInner(aFS);
        while (this.fsToDo.size() > 0) {
            int copyToFillSlots = this.fsToDo.remove(this.fsToDo.size() - 1);
            int srcToFillSlots = this.fsToDo.remove(this.fsToDo.size() - 1);
            this.copyFeatures(srcToFillSlots, copyToFillSlots);
        }
        return copy;
    }

    private FeatureStructure copyFs2Fs(FeatureStructure fs) {
        return this.originalTgtCasImpl.ll_getFSForRef(this.copyFs2(((FeatureStructureImpl)fs).getAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyFsInner(int aFS) {
        int copy = this.mFsMap.get(aFS);
        if (copy != 0) {
            return copy;
        }
        int srcTypeCode = this.originalSrcCasImpl.ll_getFSRefType(aFS);
        Type srcType = this.srcTsi.ll_getTypeForCode(srcTypeCode);
        if (srcTypeCode == this.srcSofaTypeCode) {
            String destSofaId = this.getDestSofaId(this.srcCasViewImpl.ll_getSofaID(aFS));
            return CasCopier.getOrCreateView(this.originalTgtCas, destSofaId).getSofaRef();
        }
        if (this.isDocumentAnnotation(aFS)) {
            String destViewName = this.getDestSofaId(this.srcCasViewImpl.ll_getSofaID(this.srcCasViewImpl.getSofaFeat(aFS)));
            CASImpl destView = CasCopier.getOrCreateView(this.originalTgtCas, destViewName);
            int destDocAnnot = destView.ll_getDocumentAnnotation();
            if (destDocAnnot == 0) {
                destDocAnnot = destView.ll_createDocumentAnnotationNoIndex(0, 0);
                this.copyFeatures(aFS, destDocAnnot);
                ((FSIndexRepositoryImpl)destView.getIndexRepository()).addFS(destDocAnnot);
            } else {
                AutoCloseable ac = this.tgtCasViewImpl.protectIndexes();
                try {
                    this.copyFeatures(aFS, destDocAnnot);
                }
                finally {
                    try {
                        ac.close();
                    }
                    catch (Exception e) {}
                }
            }
            return destDocAnnot;
        }
        if (srcType.isArray()) {
            copy = this.copyArray(aFS);
            this.mFsMap.put(aFS, copy);
            return copy;
        }
        TypeInfo tInfo = this.getTypeInfo(srcTypeCode);
        int tgtTypeCode = tInfo.tgtTypeCode;
        if (tgtTypeCode == 0) {
            return 0;
        }
        int tgtFsAddr = this.tgtCasViewImpl.ll_createFS(tgtTypeCode);
        this.mFsMap.put(aFS, tgtFsAddr);
        this.fsToDo.add(aFS);
        this.fsToDo.add(tgtFsAddr);
        return tgtFsAddr;
    }

    private String getDestSofaId(String id) {
        return this.isChangeViewName && id.equals(this.srcViewName) ? this.tgtViewName : id;
    }

    private TypeInfo getTypeInfo(int srcTypeCode) {
        TypeInfo tInfo = this.tInfoArray[srcTypeCode];
        if (tInfo == null) {
            this.tInfoArray[srcTypeCode] = new TypeInfo(srcTypeCode);
            return this.tInfoArray[srcTypeCode];
        }
        return tInfo;
    }

    private void copyFeatures(int srcFS, int tgtFS) {
        int srcTypeCode = this.srcCasViewImpl.getTypeCode(srcFS);
        TypeInfo tInfo = this.getTypeInfo(srcTypeCode);
        this.tgtCasViewImpl.setCacheNotInIndex(tgtFS);
        block8: for (int i = 0; i < tInfo.codesAndOffsets.length; i += 2) {
            int tgtFeatCode = tInfo.codesAndOffsets[i + 1];
            if (0 == tgtFeatCode) continue;
            int srcFeatOffset = tInfo.codesAndOffsets[i + 0];
            switch (tInfo.frc[i >> 1]) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    this.tgtCasViewImpl.ll_setStringValue(tgtFS, tgtFeatCode, this.srcCasViewImpl.ll_getStringValueFeatOffset(srcFS, srcFeatOffset));
                    continue block8;
                }
                case 4: {
                    this.tgtCasViewImpl.ll_setIntValue(tgtFS, tgtFeatCode, this.srcCasViewImpl.ll_getIntValueFeatOffset(srcFS, srcFeatOffset));
                    continue block8;
                }
                case 2: {
                    this.tgtCasViewImpl.ll_setLongValue(tgtFS, tgtFeatCode, this.srcCasViewImpl.ll_getLongValueFeatOffset(srcFS, srcFeatOffset));
                    continue block8;
                }
                case 3: {
                    this.tgtCasViewImpl.ll_setDoubleValue(tgtFS, tgtFeatCode, this.srcCasViewImpl.ll_getDoubleValueFeatOffset(srcFS, srcFeatOffset));
                    continue block8;
                }
                case 5: {
                    int refFS = this.srcCasViewImpl.ll_getRefValueFeatOffset(srcFS, srcFeatOffset);
                    if (refFS == 0) continue block8;
                    int copyRefFs = this.copyFsInner(refFS);
                    this.tgtCasViewImpl.ll_setRefValue(tgtFS, tgtFeatCode, copyRefFs);
                    continue block8;
                }
                default: {
                    throw new UIMARuntimeException();
                }
            }
        }
    }

    public boolean alreadyCopied(FeatureStructure aFS) {
        return this.alreadyCopied(((FeatureStructureImpl)aFS).getAddress());
    }

    public boolean alreadyCopied(int aFS) {
        return this.mFsMap.get(aFS) != 0;
    }

    private int copyArray(int srcFS) {
        int len = this.srcCasViewImpl.ll_getArraySize(srcFS);
        int srcTypeCode = this.srcCasViewImpl.getTypeCode(srcFS);
        if (srcTypeCode == 9) {
            int tgtFS = this.tgtCasViewImpl.ll_createArray(9, len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setStringArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getStringArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 8) {
            int tgtFS = this.tgtCasViewImpl.ll_createArray(8, len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setIntArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getIntArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 7) {
            int tgtFS = this.tgtCasViewImpl.ll_createArray(7, len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setFloatArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getFloatArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 6) {
            int tgtFS = this.tgtCasViewImpl.ll_createArray(6, len);
            for (int i = 0; i < len; ++i) {
                int srcItem = this.srcCasViewImpl.ll_getRefArrayValue(srcFS, i);
                this.tgtCasViewImpl.ll_setRefArrayValue(tgtFS, i, srcItem == 0 ? 0 : this.copyFsInner(srcItem));
            }
            return tgtFS;
        }
        if (srcTypeCode == 29) {
            int tgtFS = this.tgtCasViewImpl.ll_createByteArray(len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setByteArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getByteArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 30) {
            int tgtFS = this.tgtCasViewImpl.ll_createShortArray(len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setShortArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getShortArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 31) {
            int tgtFS = this.tgtCasViewImpl.ll_createLongArray(len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setLongArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getLongArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 32) {
            int tgtFS = this.tgtCasViewImpl.ll_createDoubleArray(len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setDoubleArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getDoubleArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        if (srcTypeCode == 28) {
            int tgtFS = this.tgtCasViewImpl.ll_createBooleanArray(len);
            for (int i = 0; i < len; ++i) {
                this.tgtCasViewImpl.ll_setBooleanArrayValue(tgtFS, i, this.srcCasViewImpl.ll_getBooleanArrayValue(srcFS, i));
            }
            return tgtFS;
        }
        assert (false);
        return 0;
    }

    private static CASImpl getOrCreateView(CAS aCas, String aViewName) {
        try {
            return (CASImpl)aCas.getView(aViewName).getLowLevelCAS();
        }
        catch (CASRuntimeException e) {
            return (CASImpl)aCas.createView(aViewName).getLowLevelCAS();
        }
    }

    private boolean isDocumentAnnotation(int aFS) {
        if (this.srcCasDocumentAnnotation == 0) {
            int docFs = this.srcCasViewImpl.ll_getDocumentAnnotation();
            this.srcCasDocumentAnnotation = docFs == 0 ? -1 : docFs;
        }
        return aFS == this.srcCasDocumentAnnotation;
    }

    private boolean casViewsInSameCas(CAS c1, CAS c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        CASImpl ci1 = (CASImpl)c1.getLowLevelCAS();
        CASImpl ci2 = (CASImpl)c2.getLowLevelCAS();
        return ci1.getBaseCAS() == ci2.getBaseCAS();
    }

    private class TypeInfo {
        final int[] codesAndOffsets;
        final byte[] frc;
        final int tgtTypeCode;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TypeInfo(int srcTypeCode) {
            if (CasCopier.this.tgtTsi == CasCopier.this.srcTsi) {
                this.tgtTypeCode = srcTypeCode;
            } else {
                Type srcType = CasCopier.this.srcTsi.ll_getTypeForCode(srcTypeCode);
                Type tgtType = CasCopier.this.tgtTsi.getType(srcType.getName());
                if (tgtType == null) {
                    if (!CasCopier.this.lenient) throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{srcType.getName()});
                    this.tgtTypeCode = 0;
                } else {
                    this.tgtTypeCode = CasCopier.this.tgtTsi.ll_getCodeForType(tgtType);
                }
            }
            int[] srcFeatCodes = CasCopier.this.srcTsi.ll_getAppropriateFeatures(srcTypeCode);
            int arrayLength = srcFeatCodes.length << 1;
            this.codesAndOffsets = new int[arrayLength];
            this.frc = new byte[srcFeatCodes.length];
            if (CasCopier.this.srcTsi == CasCopier.this.tgtTsi) {
                for (int i = 0; i < srcFeatCodes.length; ++i) {
                    int srcFeatCode = srcFeatCodes[i];
                    Feature srcFeat = CasCopier.this.srcTsi.ll_getFeatureForCode(srcFeatCode);
                    this.setRangeClass((TypeImpl)srcFeat.getRange(), i);
                    int i2 = i << 1;
                    this.codesAndOffsets[i2 + 0] = CasCopier.this.originalSrcCasImpl.getFeatureOffset(srcFeatCode);
                    this.codesAndOffsets[i2 + 1] = srcFeatCodes[i];
                }
                return;
            } else {
                for (int i = 0; i < srcFeatCodes.length; ++i) {
                    int srcFeatCode = srcFeatCodes[i];
                    Feature srcFeat = CasCopier.this.srcTsi.ll_getFeatureForCode(srcFeatCode);
                    String srcFeatName = srcFeat.getName();
                    Feature tgtFeat = CasCopier.this.tgtTsi.getFeatureByFullName(srcFeatName);
                    if (tgtFeat == null) {
                        if (CasCopier.this.lenient) continue;
                        throw new UIMARuntimeException("feature_not_found_during_cas_copy", new Object[]{srcFeatName});
                    }
                    int i2 = i << 1;
                    int tgtFeatCode = ((FeatureImpl)tgtFeat).getCode();
                    this.codesAndOffsets[i2 + 0] = CasCopier.this.originalSrcCasImpl.getFeatureOffset(srcFeatCode);
                    this.codesAndOffsets[i2 + 1] = tgtFeatCode;
                    TypeImpl srcRangeType = (TypeImpl)srcFeat.getRange();
                    if (!srcRangeType.getName().equals(tgtFeat.getRange().getName())) {
                        throw new UIMARuntimeException("copy_cas_range_type_names_not_equal", new Object[]{srcFeatName, srcFeat.getRange().getName(), tgtFeat.getRange().getName()});
                    }
                    this.setRangeClass(srcRangeType, i);
                }
            }
        }

        void setRangeClass(TypeImpl srcRangeType, int i) {
            this.frc[i] = CasCopier.this.srcTsi.ll_subsumes(CasCopier.this.srcStringTypeCode, srcRangeType.getCode()) ? 1 : (srcRangeType == ((CasCopier)CasCopier.this).srcTsi.intType || srcRangeType == ((CasCopier)CasCopier.this).srcTsi.floatType || srcRangeType == ((CasCopier)CasCopier.this).srcTsi.booleanType || srcRangeType == ((CasCopier)CasCopier.this).srcTsi.byteType || srcRangeType == ((CasCopier)CasCopier.this).srcTsi.shortType ? 4 : (srcRangeType == ((CasCopier)CasCopier.this).srcTsi.longType ? 2 : (srcRangeType == ((CasCopier)CasCopier.this).srcTsi.doubleType ? 3 : 5)));
        }
    }
}

