/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.AnnotationTreeImpl;
import org.apache.uima.cas.impl.AnnotationTreeNodeImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.Subiterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.cas.text.AnnotationTree;

public class AnnotationIndexImpl<T extends AnnotationFS>
implements AnnotationIndex<T> {
    private FSIndex<T> index;

    public AnnotationIndexImpl(FSIndex<T> index) {
        this.index = index;
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public Type getType() {
        return this.index.getType();
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.index.contains(fs);
    }

    @Override
    public FeatureStructure find(FeatureStructure fs) {
        return this.index.find(fs);
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return this.index.compare(fs1, fs2);
    }

    @Override
    public FSIterator<T> iterator() {
        return this.index.iterator();
    }

    @Override
    public FSIterator<T> iterator(FeatureStructure fs) {
        return this.index.iterator(fs);
    }

    @Override
    public int getIndexingStrategy() {
        return this.index.getIndexingStrategy();
    }

    @Override
    public FSIterator<T> iterator(boolean ambiguous) {
        if (ambiguous) {
            return this.index.iterator();
        }
        boolean strict = true;
        boolean isBounded = false;
        return new Subiterator<T>(this.index.iterator(), null, 0, 0, ambiguous, strict, isBounded, ((FSIndexRepositoryImpl.IndexImpl)this.index).getFsRepositoryImpl());
    }

    @Override
    public FSIterator<T> subiterator(AnnotationFS annot) {
        return this.subiterator(annot, true, true);
    }

    @Override
    public FSIterator<T> subiterator(AnnotationFS annot, boolean ambiguous, boolean strict) {
        boolean isBounded = true;
        return new Subiterator<T>(this.index.iterator(), annot, 0, 0, ambiguous, strict, isBounded, ((FSIndexRepositoryImpl.IndexImpl)this.index).getFsRepositoryImpl());
    }

    @Override
    public AnnotationTree<T> tree(T annot) {
        AnnotationTreeImpl tree = new AnnotationTreeImpl();
        AnnotationTreeNodeImpl<T> root = new AnnotationTreeNodeImpl<T>();
        tree.setRoot(root);
        root.set(annot);
        this.addChildren(root, this.subiterator((AnnotationFS)annot, false, true));
        return tree;
    }

    private void addChildren(AnnotationTreeNodeImpl<T> node, FSIterator<T> it) {
        while (it.isValid()) {
            AnnotationFS annot = (AnnotationFS)it.get();
            it.moveToNext();
            AnnotationTreeNodeImpl<AnnotationFS> dtr = new AnnotationTreeNodeImpl<AnnotationFS>();
            dtr.set(annot);
            node.addChild(dtr);
            this.addChildren(dtr, this.subiterator(annot, false, true));
        }
    }

    @Override
    public FSIndex<T> withSnapshotIterators() {
        return new AnnotationIndexImpl<T>(this.index.withSnapshotIterators());
    }
}

