/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.utils.corpus;

import com.google.common.collect.HashMultimap;
import eu.fbk.fcw.utils.corpus.Role;
import eu.fbk.fcw.utils.corpus.Srl;
import eu.fbk.fcw.utils.corpus.Word;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class Sentence
implements Iterable<Word>,
Serializable {
    private static final int LOOP_STOP = 100;
    private List<Word> words = new ArrayList<Word>();
    private List<Srl> srls = new ArrayList<Srl>();
    private String text;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Sentence(List<Word> words) {
        this.words = words;
    }

    public void addWord(Word word) {
        this.words.add(word);
    }

    public void addSrl(Srl srl) {
        this.srls.add(srl);
    }

    public List<Integer> getAncestors(int i) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int noLoop = 0;
        while (i >= 0 && this.words.get(i) != null) {
            ret.add(i);
            i = this.words.get(i).getDepParent() - 1;
            if (++noLoop <= 100) continue;
            break;
        }
        return ret;
    }

    public Set<Integer> getDescendants(int i) {
        HashSet<Integer> ret = new HashSet<Integer>();
        HashMultimap children = HashMultimap.create();
        for (Word word : this) {
            if (word.getDepParent() <= 0) continue;
            children.put((Object)word.getDepParent(), (Object)word.getId());
        }
        int noLoop = 0;
        this.addChildren((HashMultimap<Integer, Integer>)children, ret, i, noLoop);
        return ret;
    }

    public void addChildren(HashMultimap<Integer, Integer> map, Set<Integer> ret, Integer parent, int noLoop) {
        if (noLoop > 100) {
            return;
        }
        ret.add(parent);
        Set children = map.get((Object)parent);
        ret.addAll(children);
        for (Integer child : children) {
            this.addChildren(map, ret, child, noLoop + 1);
        }
    }

    public Integer searchHead(List<Integer> span) {
        List[] ancestorLists = new List[span.size()];
        for (int i = 0; i < span.size(); ++i) {
            Integer integer = span.get(i);
            ancestorLists[i] = this.getAncestors(integer);
        }
        return this.giveHead(ancestorLists);
    }

    private Integer giveHead(List<Integer> ... ancestorLists) {
        if (ancestorLists.length == 1) {
            return ancestorLists[0].get(0);
        }
        int k = 1;
        int last = 0;
        while (true) {
            HashSet<Integer> integers = new HashSet<Integer>();
            for (int i = 0; i < ancestorLists.length; ++i) {
                try {
                    integers.add(ancestorLists[i].get(ancestorLists[i].size() - k));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return last;
                }
            }
            if (integers.size() == 1) {
                for (Integer integer : integers) {
                    last = integer;
                }
            } else {
                return last;
            }
            ++k;
        }
    }

    public Sentence() {
    }

    public List<Word> getWords() {
        return this.words;
    }

    public List<Srl> getSrls() {
        return this.srls;
    }

    public String toConllString() {
        TreeMap<Integer, Srl> srlMap = new TreeMap<Integer, Srl>();
        for (Srl srl : this.srls) {
            Word word = srl.getTarget().get(0);
            srlMap.put(word.getId(), srl);
        }
        int additionalColumnsNo = 2 + srlMap.size();
        String[][] additionalColumns = new String[this.getWords().size()][additionalColumnsNo];
        for (int j = 0; j < this.getWords().size(); ++j) {
            for (int i = 0; i < additionalColumnsNo; ++i) {
                additionalColumns[j][i] = "_";
            }
        }
        int roleIndex = 0;
        for (Integer key : srlMap.keySet()) {
            Srl srl = (Srl)srlMap.get(key);
            additionalColumns[key.intValue() - 1][0] = "Y";
            additionalColumns[key.intValue() - 1][1] = srl.getLabel();
            for (Role role : srl.getRoles()) {
                int roleKey = role.getSpan().get(0).getId();
                additionalColumns[roleKey - 1][2 + roleIndex] = role.getLabel();
            }
            ++roleIndex;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Word word : this.getWords()) {
            builder.append(word.getId()).append("\t");
            builder.append(word.getForm()).append("\t");
            builder.append(word.getForm()).append("\t");
            builder.append(word.getLemma()).append("\t");
            builder.append(word.getPos()).append("\t");
            builder.append(word.getPos()).append("\t");
            builder.append("_").append("\t");
            builder.append("_").append("\t");
            builder.append(word.getDepParent()).append("\t");
            builder.append(word.getDepParent()).append("\t");
            builder.append(word.getDepLabel()).append("\t");
            builder.append(word.getDepLabel());
            for (String col : additionalColumns[i]) {
                builder.append("\t").append(col);
            }
            builder.append("\n");
            ++i;
        }
        builder.append("\n");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Sentence {").append("\n");
        builder.append(" Words {").append("\n");
        for (Word word : this.words) {
            builder.append("  " + word.toString()).append("\n");
        }
        builder.append(" }").append("\n");
        builder.append(" Srls {").append("\n");
        for (Srl srl : this.srls) {
            builder.append("  " + srl.toString()).append("\n");
        }
        builder.append(" }").append("\n");
        return builder.toString();
    }

    @Override
    public Iterator<Word> iterator() {
        return this.words.iterator();
    }
}

