/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.utils.annotators;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class FakePosAnnotator
implements Annotator {
    String[] pos;

    public FakePosAnnotator(String annotatorName, Properties props) {
        this.pos = props.getProperty(annotatorName + ".pos", "").split("\\s+");
    }

    public void annotate(Annotation annotation) {
        int tk = 0;
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                int sz = tokens.size();
                for (int i = 0; i < sz; ++i) {
                    CoreLabel thisToken = (CoreLabel)tokens.get(i);
                    thisToken.set(CoreAnnotations.PartOfSpeechAnnotation.class, (Object)this.pos[tk++].toUpperCase());
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.PartOfSpeechAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }
}

