/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.utils;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConllToken {
    private static final Pattern p = Pattern.compile("[0-9]+");
    String id;
    String form;
    String lemma = null;
    String upos = null;
    String xpos = null;
    SortedSetMultimap<String, String> feats = null;
    String[] originalParts;
    Integer head = null;
    String deprel = null;
    List<Pair<Integer, String>> deps = null;
    String misc = null;
    String originalString = null;

    public ConllToken(String conllLine) throws Exception {
        this(conllLine, 0);
    }

    public String[] getOriginalParts() {
        return this.originalParts;
    }

    public static SortedSetMultimap<String, String> featureStringToAnnotation(String featureString) {
        TreeMultimap featsMap = TreeMultimap.create();
        if (featureString != null) {
            String[] feats;
            for (String feat : feats = featureString.split("\\|")) {
                String[] values;
                String[] featParts = feat.split("=");
                if (featParts.length < 2) continue;
                for (String value : values = featParts[1].split(",")) {
                    value = value.trim();
                    featsMap.put((Object)featParts[0], (Object)value);
                }
            }
        }
        return featsMap;
    }

    public ConllToken(String conllLine, int offset) throws Exception {
        this.originalString = conllLine = conllLine.trim();
        String[] parts = conllLine.split("\t");
        this.originalParts = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.originalParts[i] = parts[i];
        }
        if (parts.length < 10) {
            throw new Exception("Input line in wrong format: " + conllLine);
        }
        Matcher m = p.matcher(parts[0]);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            Integer n = Integer.parseInt(m.group());
            n = n + offset;
            m.appendReplacement(sb, n.toString());
        }
        m.appendTail(sb);
        this.setId(sb.toString());
        this.setForm(parts[1]);
        if (!parts[2].equals("_")) {
            this.setLemma(parts[2]);
        }
        if (!parts[3].equals("_")) {
            this.setUpos(parts[3]);
        }
        if (!parts[4].equals("_")) {
            this.setXpos(parts[4]);
        }
        if (!parts[5].equals("_")) {
            this.setFeats(ConllToken.featureStringToAnnotation(parts[5]));
        }
        if (!parts[6].equals("_")) {
            int head = Integer.parseInt(parts[6]);
            if (head != 0) {
                head += offset;
            }
            this.setHead(head);
        }
        if (!parts[7].equals("_")) {
            this.setDeprel(parts[7]);
        }
        if (!parts[8].equals("_")) {
            String[] deps;
            ArrayList<Pair<Integer, String>> depList = new ArrayList<Pair<Integer, String>>();
            for (String dep : deps = parts[8].split("\\|")) {
                String[] depParts = dep.split(":");
                if (depParts.length < 2) continue;
                int head = Integer.parseInt(depParts[0]);
                if (head != 0) {
                    head += offset;
                }
                Pair thisDep = new Pair((Object)head, (Object)depParts[1]);
                depList.add((Pair<Integer, String>)thisDep);
            }
            this.setDeps(depList);
        }
        if (!parts[9].equals("_")) {
            this.setMisc(parts[9]);
        }
    }

    public String toString() {
        return "Token{id='" + this.id + '\'' + ", form='" + this.form + '\'' + ", lemma='" + this.lemma + '\'' + ", upos='" + this.upos + '\'' + ", xpos='" + this.xpos + '\'' + ", feats=" + this.feats + ", head=" + this.head + ", deprel='" + this.deprel + '\'' + ", deps=" + this.deps + ", misc='" + this.misc + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public String getUpos() {
        return this.upos;
    }

    public void setUpos(String upos) {
        this.upos = upos;
    }

    public String getXpos() {
        return this.xpos;
    }

    public void setXpos(String xpos) {
        this.xpos = xpos;
    }

    public Map<String, Collection<String>> getFeats() {
        return this.feats != null ? this.feats.asMap() : null;
    }

    public void setFeats(SortedSetMultimap<String, String> feats) {
        this.feats = feats;
    }

    public Integer getHead() {
        return this.head;
    }

    public void setHead(Integer head) {
        this.head = head;
    }

    public String getDeprel() {
        return this.deprel;
    }

    public void setDeprel(String deprel) {
        this.deprel = deprel;
    }

    public List<Pair<Integer, String>> getDeps() {
        return this.deps;
    }

    public void setDeps(List<Pair<Integer, String>> deps) {
        this.deps = deps;
    }

    public String getMisc() {
        return this.misc;
    }

    public void setMisc(String misc) {
        this.misc = misc;
    }
}

