/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.corenlp.outputters;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TypesafeMap;
import eu.fbk.utils.corenlp.outputters.AnnotationOutputter;
import eu.fbk.utils.gson.AnnotationExclusionStrategy;
import eu.fbk.utils.gson.JSONLabel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONOutputter
extends AnnotationOutputter {
    private final ThreadLocal<Annotation> annotationThreadLocal = new ThreadLocal();
    GsonBuilder gsonBuilder = new GsonBuilder();

    private static void add(Gson gson, JsonObject jsonObject, TypesafeMap annotation) {
        for (Class myClass : annotation.keySet()) {
            Class[] serializerClasses;
            Object o = annotation.get(myClass);
            if (o == null || !myClass.isAnnotationPresent(JSONLabel.class)) continue;
            JSONLabel JsonAnnotation = myClass.getAnnotation(JSONLabel.class);
            String name = JsonAnnotation.value();
            if (name != null && name.length() > 0) {
                try {
                    jsonObject.add(name, gson.toJsonTree(o));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Class serializerClass : serializerClasses = JsonAnnotation.serializer()) {
                if (!JsonSerializer.class.isAssignableFrom(serializerClass)) continue;
            }
        }
    }

    public JSONOutputter(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
    }

    public JSONOutputter() {
        this.gsonBuilder = new GsonBuilder();
    }

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        List quotes;
        if (options.pretty) {
            this.gsonBuilder.setPrettyPrinting();
        }
        this.gsonBuilder.registerTypeAdapter(SemanticGraph.class, (Object)new SemanticGraphSerializer());
        this.gsonBuilder.registerTypeAdapter(Span.class, (Object)new SpanSerializer());
        this.gsonBuilder.registerTypeAdapter(RelationTriple.class, (Object)new RelationTripleSerializer());
        this.gsonBuilder.registerTypeAdapter(Timex.class, (Object)new TimexSerializer());
        this.gsonBuilder.registerTypeAdapter(CorefChain.class, (Object)new CorefChainSerializer());
        this.gsonBuilder.registerTypeAdapter(CoreLabel.class, (Object)new CoreLabelSerializer());
        this.gsonBuilder.registerTypeAdapter(Double.class, (Object)new DoubleSerializer());
        this.gsonBuilder.serializeSpecialFloatingPointValues();
        this.gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()});
        Gson gson = this.gsonBuilder.create();
        String text = (String)doc.get(CoreAnnotations.TextAnnotation.class);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("docId", (String)doc.get(CoreAnnotations.DocIDAnnotation.class));
        jsonObject.addProperty("docDate", (String)doc.get(CoreAnnotations.DocDateAnnotation.class));
        jsonObject.addProperty("docSourceType", (String)doc.get(CoreAnnotations.DocSourceTypeAnnotation.class));
        jsonObject.addProperty("docType", (String)doc.get(CoreAnnotations.DocTypeAnnotation.class));
        jsonObject.addProperty("author", (String)doc.get(CoreAnnotations.AuthorAnnotation.class));
        jsonObject.addProperty("location", (String)doc.get(CoreAnnotations.LocationAnnotation.class));
        if (options.includeText) {
            jsonObject.addProperty("text", text);
        }
        if ((quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class)) != null && quotes.size() > 0) {
            JsonArray jsonQuotesArray = new JsonArray();
            for (CoreMap quote : quotes) {
                JsonObject quoteObj = new JsonObject();
                List tokens = (List)quote.get(CoreAnnotations.TokensAnnotation.class);
                int begin = ((CoreLabel)tokens.get(0)).beginPosition();
                int end = ((CoreLabel)tokens.get(tokens.size() - 1)).endPosition();
                int beginContext = Math.max(0, begin - 100);
                int endContext = Math.min(end + 100, text.length());
                quoteObj.addProperty("text", (String)quote.get(CoreAnnotations.TextAnnotation.class));
                quoteObj.addProperty("context", text.substring(beginContext, endContext));
                quoteObj.addProperty("characterOffsetBegin", (Number)begin);
                quoteObj.addProperty("characterOffsetEnd", (Number)end);
                jsonQuotesArray.add((JsonElement)quoteObj);
            }
            jsonObject.add("quotes", (JsonElement)jsonQuotesArray);
        }
        JSONOutputter.add(gson, jsonObject, (TypesafeMap)doc);
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            JSONOutputter.addSentences(gson, jsonObject, (List)doc.get(CoreAnnotations.SentencesAnnotation.class), options);
        }
        this.annotationThreadLocal.set(doc);
        jsonObject.add("corefs", gson.toJsonTree(doc.get(CorefCoreAnnotations.CorefChainAnnotation.class)));
        OutputStreamWriter w = new OutputStreamWriter(target);
        w.write(gson.toJson((JsonElement)jsonObject));
        ((Writer)w).flush();
    }

    private static void addSentences(Gson gson, JsonObject jsonObject, List<CoreMap> sentences, AnnotationOutputter.Options options) {
        JsonArray jsonSentenceArray = new JsonArray();
        for (CoreMap sentence : sentences) {
            JsonObject sentenceObj = new JsonObject();
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            sentenceObj.addProperty("id", (String)sentence.get(CoreAnnotations.SentenceIDAnnotation.class));
            sentenceObj.addProperty("index", (Number)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
            sentenceObj.addProperty("line", (Number)sentence.get(CoreAnnotations.LineNumberAnnotation.class));
            sentenceObj.addProperty("characterOffsetBegin", (Number)((CoreLabel)tokens.get(0)).beginPosition());
            sentenceObj.addProperty("characterOffsetEnd", (Number)((CoreLabel)tokens.get(tokens.size() - 1)).endPosition());
            sentenceObj.addProperty("text", (String)sentence.get(CoreAnnotations.TextAnnotation.class));
            sentenceObj.add("basic-dependencies", gson.toJsonTree(sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
            sentenceObj.add("collapsed-dependencies", gson.toJsonTree(sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)));
            sentenceObj.add("collapsed-ccprocessed-dependencies", gson.toJsonTree(sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            StringWriter treeStrWriter = new StringWriter();
            TreePrint treePrinter = options.constituentTreePrinter;
            if (treePrinter == AnnotationOutputter.DEFAULT_CONSTITUENT_TREE_PRINTER) {
                treePrinter = new TreePrint("oneline");
            }
            treePrinter.printTree(tree, new PrintWriter((Writer)treeStrWriter, true));
            sentenceObj.addProperty("parse", treeStrWriter.toString().trim());
            Tree sentimentTree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
            if (sentimentTree != null) {
                int sentiment = RNNCoreAnnotations.getPredictedClass((Tree)sentimentTree);
                String sentimentClass = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
                sentenceObj.addProperty("sentimentValue", Integer.toString(sentiment));
                sentenceObj.addProperty("sentiment", sentimentClass.replaceAll("\\s+", ""));
            }
            sentenceObj.add("openie", gson.toJsonTree(sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)));
            if (sentence.get(CoreAnnotations.TokensAnnotation.class) != null) {
                JSONOutputter.addTokens(gson, sentenceObj, (List)sentence.get(CoreAnnotations.TokensAnnotation.class));
            }
            JSONOutputter.add(gson, sentenceObj, (TypesafeMap)sentence);
            jsonSentenceArray.add((JsonElement)sentenceObj);
        }
        jsonObject.add("sentences", (JsonElement)jsonSentenceArray);
    }

    private static void addTokens(Gson gson, JsonObject sentenceObj, List<CoreLabel> tokens) {
        JsonArray jsonTokenArray = new JsonArray();
        for (CoreLabel token : tokens) {
            JsonObject tokenObj = new JsonObject();
            tokenObj.addProperty("index", (Number)token.index());
            tokenObj.addProperty("word", token.word());
            tokenObj.addProperty("originalText", token.originalText());
            tokenObj.addProperty("lemma", token.lemma());
            tokenObj.addProperty("characterOffsetBegin", (Number)token.beginPosition());
            tokenObj.addProperty("characterOffsetEnd", (Number)token.endPosition());
            tokenObj.addProperty("pos", token.tag());
            tokenObj.addProperty("featuresText", (String)token.get(CoreAnnotations.FeaturesAnnotation.class));
            tokenObj.addProperty("ner", token.ner());
            tokenObj.addProperty("normalizedNER", (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
            tokenObj.addProperty("speaker", (String)token.get(CoreAnnotations.SpeakerAnnotation.class));
            tokenObj.addProperty("truecase", (String)token.get(CoreAnnotations.TrueCaseAnnotation.class));
            tokenObj.addProperty("truecaseText", (String)token.get(CoreAnnotations.TrueCaseTextAnnotation.class));
            tokenObj.addProperty("before", (String)token.get(CoreAnnotations.BeforeAnnotation.class));
            tokenObj.addProperty("after", (String)token.get(CoreAnnotations.AfterAnnotation.class));
            tokenObj.add("timex", gson.toJsonTree(token.get(TimeAnnotations.TimexAnnotation.class)));
            JSONOutputter.add(gson, tokenObj, (TypesafeMap)token);
            jsonTokenArray.add((JsonElement)tokenObj);
        }
        sentenceObj.add("tokens", (JsonElement)jsonTokenArray);
    }

    public static String jsonPrint(GsonBuilder gsonBuilder, Annotation annotation) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new JSONOutputter(gsonBuilder).print(annotation, outputStream);
        return new String(outputStream.toByteArray(), "UTF-8");
    }

    public static void jsonPrint(GsonBuilder gsonBuilder, Annotation annotation, OutputStream os) throws IOException {
        new JSONOutputter(gsonBuilder).print(annotation, os);
    }

    public static void jsonPrint(GsonBuilder gsonBuilder, Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new JSONOutputter(gsonBuilder).print(annotation, os, pipeline);
    }

    public static void jsonPrint(GsonBuilder gsonBuilder, Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new JSONOutputter(gsonBuilder).print(annotation, os, options);
    }

    public static String jsonPrint(Annotation annotation) throws IOException {
        return JSONOutputter.jsonPrint(annotation, new AnnotationOutputter.Options());
    }

    public static String jsonPrint(Annotation annotation, AnnotationOutputter.Options options) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new JSONOutputter().print(annotation, (OutputStream)outputStream, options);
        return new String(outputStream.toByteArray(), "UTF-8");
    }

    public static void jsonPrint(Annotation annotation, OutputStream os) throws IOException {
        new JSONOutputter().print(annotation, os);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new JSONOutputter().print(annotation, os, pipeline);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new JSONOutputter().print(annotation, os, options);
    }

    class CorefChainSerializer
    implements JsonSerializer<CorefChain> {
        CorefChainSerializer() {
        }

        public JsonElement serialize(CorefChain chain, Type type, JsonSerializationContext jsonSerializationContext) {
            CorefChain.CorefMention representative = chain.getRepresentativeMention();
            JsonArray chainArray = new JsonArray();
            for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                JsonObject mentionObj = new JsonObject();
                mentionObj.addProperty("id", (Number)mention.mentionID);
                mentionObj.add("text", jsonSerializationContext.serialize((Object)mention.mentionSpan));
                mentionObj.add("type", jsonSerializationContext.serialize((Object)mention.mentionType));
                mentionObj.add("number", jsonSerializationContext.serialize((Object)mention.number));
                mentionObj.add("gender", jsonSerializationContext.serialize((Object)mention.gender));
                mentionObj.add("animacy", jsonSerializationContext.serialize((Object)mention.animacy));
                mentionObj.addProperty("startIndex", (Number)mention.startIndex);
                mentionObj.addProperty("endIndex", (Number)mention.endIndex);
                mentionObj.addProperty("sentNum", (Number)mention.sentNum);
                mentionObj.add("position", jsonSerializationContext.serialize((Object)mention.position.elems()));
                mentionObj.addProperty("isRepresentativeMention", Boolean.valueOf(mention == representative));
                chainArray.add((JsonElement)mentionObj);
            }
            return chainArray;
        }
    }

    class DoubleSerializer
    implements JsonSerializer<Double> {
        DoubleSerializer() {
        }

        public JsonElement serialize(Double aDouble, Type type, JsonSerializationContext jsonSerializationContext) {
            if (aDouble != null && aDouble.isNaN()) {
                aDouble = null;
            }
            if (aDouble != null && aDouble.isInfinite()) {
                aDouble = null;
            }
            return new JsonPrimitive((Number)aDouble);
        }
    }

    class TimexSerializer
    implements JsonSerializer<Timex> {
        TimexSerializer() {
        }

        public JsonElement serialize(Timex time, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject timexObj = new JsonObject();
            timexObj.addProperty("tid", time.tid());
            timexObj.addProperty("type", time.timexType());
            timexObj.addProperty("value", time.value());
            timexObj.addProperty("altValue", time.altVal());
            return timexObj;
        }
    }

    class RelationTripleSerializer
    implements JsonSerializer<RelationTriple> {
        RelationTripleSerializer() {
        }

        public JsonElement serialize(RelationTriple triple, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject ieObject = new JsonObject();
            ieObject.addProperty("subject", triple.subjectGloss());
            ieObject.add("subjectSpan", jsonSerializationContext.serialize((Object)Span.fromPair((Pair)triple.subjectTokenSpan())));
            ieObject.addProperty("relation", triple.relationGloss());
            ieObject.add("relationSpan", jsonSerializationContext.serialize((Object)Span.fromPair((Pair)triple.relationTokenSpan())));
            ieObject.addProperty("object", triple.objectGloss());
            ieObject.add("objectSpan", jsonSerializationContext.serialize((Object)Span.fromPair((Pair)triple.objectTokenSpan())));
            return ieObject;
        }
    }

    class SemanticGraphSerializer
    implements JsonSerializer<SemanticGraph> {
        SemanticGraphSerializer() {
        }

        public JsonElement serialize(SemanticGraph semanticGraph, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject object;
            JsonArray jsonArray = new JsonArray();
            for (IndexedWord root : semanticGraph.getRoots()) {
                object = new JsonObject();
                object.addProperty("dep", "ROOT");
                object.addProperty("governor", (Number)0);
                object.addProperty("governorGloss", "ROOT");
                object.addProperty("dependent", (Number)root.index());
                object.addProperty("dependentGloss", root.word());
                jsonArray.add((JsonElement)object);
            }
            for (SemanticGraphEdge edge : semanticGraph.edgeListSorted()) {
                object = new JsonObject();
                object.addProperty("dep", edge.getRelation().toString());
                object.addProperty("governor", (Number)edge.getGovernor().index());
                object.addProperty("governorGloss", edge.getGovernor().word());
                object.addProperty("dependent", (Number)edge.getDependent().index());
                object.addProperty("dependentGloss", edge.getDependent().word());
                jsonArray.add((JsonElement)object);
            }
            return jsonArray;
        }
    }

    class SpanSerializer
    implements JsonSerializer<Span> {
        SpanSerializer() {
        }

        public JsonElement serialize(Span span, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((Number)span.start());
            jsonArray.add((Number)span.end());
            return jsonArray;
        }
    }

    class CoreLabelSerializer
    implements JsonSerializer<CoreLabel> {
        CoreLabelSerializer() {
        }

        public JsonElement serialize(CoreLabel coreLabel, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)coreLabel.index());
        }
    }
}

