/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Import_impl
extends MetaDataObject_impl
implements Import {
    private static final long serialVersionUID = 6876757002913848998L;
    private String mName;
    private String mLocation;
    private String byNameSuffix = ".xml";

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getLocation() {
        return this.mLocation;
    }

    @Override
    public void setLocation(String aUri) {
        this.mLocation = aUri;
    }

    public void setSuffix(String suffix) {
        this.byNameSuffix = suffix;
    }

    @Override
    public URL findAbsoluteUrl(ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getLocation() != null) {
            try {
                return new URL(this.getRelativePathBase(), this.getLocation());
            }
            catch (MalformedURLException e) {
                throw new InvalidXMLException("malformed_import_url", new Object[]{this.getLocation(), this.getSourceUrlString()}, e);
            }
        }
        if (this.getName() != null) {
            URL url;
            String filename = this.getName().replace('.', '/') + this.byNameSuffix;
            try {
                url = aResourceManager.resolveRelativePath(filename);
            }
            catch (MalformedURLException e) {
                throw new InvalidXMLException("import_by_name_target_not_found", new Object[]{filename, this.getSourceUrlString()}, e);
            }
            if (url == null) {
                throw new InvalidXMLException("import_by_name_target_not_found", new Object[]{filename, this.getSourceUrlString()});
            }
            return url;
        }
        throw new InvalidXMLException("import_must_have_name_xor_location", new Object[]{this.getSourceUrlString()});
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String name = aElement.getAttribute("name");
        this.setName(name.length() == 0 ? null : name);
        String location = aElement.getAttribute("location");
        this.setLocation(location.length() == 0 ? null : location);
        if (!(this.getName() == null ^ this.getLocation() == null)) {
            throw new InvalidXMLException("import_must_have_name_xor_location", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        if (null == serialContext.get()) {
            Import_impl.getSerialContext(aContentHandler);
            try {
                this.toXMLinner(aWriteDefaultNamespaceAttribute);
            }
            finally {
                serialContext.remove();
            }
        } else {
            this.toXMLinner(aWriteDefaultNamespaceAttribute);
        }
    }

    private void toXMLinner(boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        MetaDataObject_impl.SerialContext sc = (MetaDataObject_impl.SerialContext)serialContext.get();
        MetaDataObject_impl.Serializer serializer = sc.serializer;
        String namespace = this.getXmlizationInfo().namespace;
        AttributesImpl attrs = new AttributesImpl();
        if (this.getName() != null) {
            attrs.addAttribute("", "name", "name", null, this.getName());
        }
        if (this.getLocation() != null) {
            attrs.addAttribute("", "location", "location", null, this.getLocation());
        }
        Node node = serializer.findMatchingSubElement("import");
        serializer.outputStartElement(node, namespace, "import", "import", attrs);
        serializer.outputEndElement(node, namespace, "import", "import");
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }
}

