/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.udpipe.api;

import com.google.gson.Gson;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.fcw.udpipe.api.CoNLLUDocumentReader;
import eu.fbk.fcw.udpipe.api.UDPipe;
import eu.fbk.fcw.udpipe.api.UDPipeAnnotations;
import eu.fbk.fcw.utils.ConllToken;
import eu.fbk.fcw.utils.Network;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.corenlp.CustomAnnotations;
import eu.fbk.utils.corenlp.Utils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPipeAnnotator
implements Annotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDPipeAnnotator.class);
    private static String DEFAULT_SERVER = "localhost";
    private static String DEFAULT_PORT = "12345";
    private static String DEFAULT_ADDRESS = "/process";
    private static String DEFAULT_PROTOCOL = "http";
    private URL url;
    private boolean alreadyTokenized;
    private boolean keepOriginal;
    CoreLabelTokenFactory factory = new CoreLabelTokenFactory();
    Pattern tokenRangePattern = Pattern.compile("TokenRange=([0-9]+):([0-9]+)");

    public UDPipeAnnotator(String annotatorName, Properties properties) throws MalformedURLException {
        Properties theseProperties = PropertiesUtils.dotConvertedProperties((Properties)properties, (String)annotatorName);
        String server = theseProperties.getProperty("server", DEFAULT_SERVER);
        String port = theseProperties.getProperty("port", DEFAULT_PORT);
        String protocol = theseProperties.getProperty("protocol", DEFAULT_PROTOCOL);
        String address = theseProperties.getProperty("address", DEFAULT_ADDRESS);
        this.alreadyTokenized = PropertiesUtils.getBoolean((String)theseProperties.getProperty("alreadyTokenized"), (boolean)true);
        this.keepOriginal = PropertiesUtils.getBoolean((String)theseProperties.getProperty("keepOriginal"), (boolean)false);
        this.url = new URL(protocol, server, Integer.parseInt(port), address);
    }

    public void annotate(Annotation annotation) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tagger", "1");
        data.put("parser", "1");
        String dataStr = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        if (this.alreadyTokenized) {
            data.put("input", "horizontal");
            StringBuffer buffer = new StringBuffer();
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                StringBuffer line = new StringBuffer();
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    line.append(token.originalText().replaceAll("\\s+", "_")).append(" ");
                }
                buffer.append(line.toString().trim()).append("\n");
            }
            dataStr = buffer.toString().trim();
        } else {
            data.put("tokenizer", "ranges");
        }
        data.put("data", dataStr);
        try {
            String line;
            String response = Network.request((String)this.url.toString(), data);
            Gson gson = new Gson();
            UDPipe udPipe = (UDPipe)gson.fromJson(response, UDPipe.class);
            String result = udPipe.getResult();
            if (this.keepOriginal) {
                annotation.set(UDPipeAnnotations.UDPipeOriginalAnnotation.class, (Object)result);
            }
            ArrayList text = new ArrayList();
            ArrayList<ConllToken> thisSentence = new ArrayList<ConllToken>();
            BufferedReader reader = new BufferedReader(new StringReader(result));
            int sentenceOffset = 0;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (thisSentence.size() <= 0) continue;
                    text.add(thisSentence);
                    sentenceOffset += thisSentence.size();
                    thisSentence = new ArrayList();
                    continue;
                }
                try {
                    ConllToken token = new ConllToken(line, sentenceOffset);
                    thisSentence.add(token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (thisSentence.size() > 0) {
                text.add(thisSentence);
            }
            reader.close();
            StringBuffer res = new StringBuffer();
            res.append(result);
            res = new StringBuffer();
            ArrayList sTokens = new ArrayList();
            for (List list : text) {
                ArrayList<CoreLabel> clSentence = new ArrayList<CoreLabel>();
                for (ConllToken token : list) {
                    if (!this.alreadyTokenized) {
                        String misc = token.getMisc();
                        Matcher m = this.tokenRangePattern.matcher(misc);
                        Integer start = null;
                        Integer end = null;
                        if (m.find()) {
                            start = Integer.parseInt(m.group(1));
                            end = Integer.parseInt(m.group(2));
                        }
                        if (start == null) {
                            throw new Exception("Unable to find TokenRange");
                        }
                        CoreLabel clToken = this.factory.makeToken(token.getForm(), token.getForm(), start.intValue(), end - start);
                        clSentence.add(clToken);
                    }
                    res.append(token.getId()).append("\t");
                    res.append(token.getOriginalParts()[1]).append("\t");
                    res.append(token.getOriginalParts()[2]).append("\t");
                    res.append(token.getOriginalParts()[3]).append("\t");
                    res.append(token.getOriginalParts()[4]).append("\t");
                    res.append(token.getOriginalParts()[5]).append("\t");
                    res.append(this.nn(token.getHead().toString())).append("\t");
                    res.append(token.getOriginalParts()[7]).append("\t");
                    res.append("_").append("\t");
                    res.append(token.getOriginalParts()[9]).append("\n");
                }
                sTokens.add(clSentence);
                res.append("\n");
            }
            if (!this.alreadyTokenized) {
                Utils.addBasicAnnotations((Annotation)annotation, sTokens);
            }
            ArrayList graphs = new ArrayList();
            reader = new BufferedReader(new StringReader(res.toString()));
            CoNLLUDocumentReader coNLLUDocumentReader = new CoNLLUDocumentReader();
            Iterator<SemanticGraph> it = coNLLUDocumentReader.getIterator(reader);
            it.forEachRemaining(graphs::add);
            reader.close();
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (int i = 0; i < sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)sentences.get(i);
                try {
                    SemanticGraph semanticGraph = (SemanticGraph)graphs.get(i);
                    sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, (Object)semanticGraph);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
                List get1 = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (int j = 0; j < get1.size(); ++j) {
                    CoreLabel token = (CoreLabel)get1.get(j);
                    ConllToken conllToken = (ConllToken)((List)text.get(i)).get(j);
                    token.set(CoreAnnotations.PartOfSpeechAnnotation.class, (Object)conllToken.getXpos());
                    token.set(CoreAnnotations.LemmaAnnotation.class, (Object)conllToken.getLemma());
                    token.set(CustomAnnotations.UPosAnnotation.class, (Object)conllToken.getUpos());
                    token.set(CustomAnnotations.FeaturesAnnotation.class, (Object)conllToken.getFeats());
                    token.set(CustomAnnotations.DepsAnnotation.class, (Object)conllToken.getDeps());
                    token.set(UDPipeAnnotations.LemmaAnnotation.class, (Object)conllToken.getLemma());
                    token.set(CustomAnnotations.MiscAnnotation.class, (Object)conllToken.getMisc());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String nn(String value) {
        return value == null ? "_" : value;
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.PositionAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CustomAnnotations.UPosAnnotation.class, CustomAnnotations.FeaturesAnnotation.class, CustomAnnotations.DepsAnnotation.class, UDPipeAnnotations.LemmaAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CustomAnnotations.MiscAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.alreadyTokenized) {
            return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
        }
        return Collections.emptySet();
    }
}

