/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.udpipe.api;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.IntPair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoNLLUDocumentReader
implements IteratorFromReaderFactory<SemanticGraph> {
    private static final String COMMENT_POS = "<COMMENT>";
    private static final Pattern numPattern = Pattern.compile("^([0-9]+)");
    private IteratorFromReaderFactory<SemanticGraph> ifrf = DelimitRegExIterator.getFactory((String)"\n(\\s*\n)+", (Function)new SentenceProcessor());
    private static final Comparator<IndexedWord> byIndex = (i1, i2) -> i1.compareTo(i2);
    private static final Comparator<IndexedWord> byType = (i1, i2) -> i1.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) ? -1 : (i2.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) ? 1 : 0);

    public Iterator<SemanticGraph> getIterator(Reader r) {
        return this.ifrf.getIterator(r);
    }

    private static class WordProcessor
    implements Function<String, IndexedWord> {
        private WordProcessor() {
        }

        @Override
        public IndexedWord apply(String line) {
            IndexedWord word = new IndexedWord();
            if (line.startsWith("#")) {
                word.setWord(line);
                word.setTag(CoNLLUDocumentReader.COMMENT_POS);
                return word;
            }
            String[] bits = line.split("\\s+");
            word.set(CoreAnnotations.TextAnnotation.class, (Object)bits[1]);
            if (bits[0].contains("-")) {
                String[] span = bits[0].split("-");
                Integer start = Integer.parseInt(span[0]);
                Integer end = Integer.parseInt(span[1]);
                word.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, (Object)new IntPair(start.intValue(), end.intValue()));
                word.set(CoreAnnotations.IndexAnnotation.class, (Object)start);
            } else {
                word.set(CoreAnnotations.IndexAnnotation.class, (Object)Integer.parseInt(bits[0]));
                word.set(CoreAnnotations.LemmaAnnotation.class, (Object)bits[2]);
                word.set(CoreAnnotations.CoarseTagAnnotation.class, (Object)bits[3]);
                word.set(CoreAnnotations.PartOfSpeechAnnotation.class, (Object)bits[4]);
                word.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, (Object)Integer.parseInt(bits[6]));
                word.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, (Object)bits[7]);
                word.set(CoreAnnotations.CoNLLUMisc.class, (Object)bits[9]);
                word.setIndex(Integer.parseInt(bits[0]));
                word.setValue(bits[1]);
                HashMap features = CoNLLUUtils.parseFeatures((String)bits[5]);
                word.set(CoreAnnotations.CoNLLUFeats.class, (Object)features);
                HashMap extraDeps = CoNLLUUtils.parseExtraDeps((String)bits[8]);
                word.set(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class, (Object)extraDeps);
            }
            return word;
        }
    }

    private static class SentenceProcessor
    implements Function<String, SemanticGraph> {
        private int lineNumberCounter = 0;

        private SentenceProcessor() {
        }

        @Override
        public SemanticGraph apply(String line) {
            if (line == null) {
                return null;
            }
            int offset = 0;
            String tmpLine = line.trim();
            Matcher matcher = numPattern.matcher(tmpLine);
            if (matcher.find()) {
                offset = Integer.parseInt(matcher.group()) - 1;
            }
            WordProcessor func = new WordProcessor();
            ObjectBank words = ObjectBank.getLineIterator((Reader)new StringReader(line), (Function)func);
            ArrayList wordList = new ArrayList(words);
            ArrayList sorted = new ArrayList(wordList.size());
            LinkedList comments = new LinkedList();
            wordList.stream().filter(w -> w.tag() != null && w.tag().equals(CoNLLUDocumentReader.COMMENT_POS)).forEach(w -> {
                ++this.lineNumberCounter;
                comments.add(w.word());
            });
            wordList.stream().filter(w -> w.tag() == null || !w.tag().equals(CoNLLUDocumentReader.COMMENT_POS)).sorted(byIndex.thenComparing(byType)).forEach(w -> sorted.add(w));
            ArrayList sortedTokens = new ArrayList(wordList.size());
            sorted.stream().filter(w -> !w.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)).forEach(w -> sortedTokens.add(w));
            ArrayList<TypedDependency> deps = new ArrayList<TypedDependency>(sorted.size());
            IntPair tokenSpan = null;
            String originalToken = null;
            for (IndexedWord word : sorted) {
                IndexedWord gov;
                ++this.lineNumberCounter;
                if (word.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)) {
                    tokenSpan = (IntPair)word.get(CoreAnnotations.CoNLLUTokenSpanAnnotation.class);
                    originalToken = word.word();
                    continue;
                }
                if (tokenSpan != null && tokenSpan.getTarget() >= word.index()) {
                    word.setOriginalText(originalToken);
                    word.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, (Object)tokenSpan);
                } else {
                    tokenSpan = null;
                    originalToken = null;
                }
                GrammaticalRelation reln = GrammaticalRelation.valueOf((Language)Language.UniversalEnglish, (String)((String)word.get(CoreAnnotations.CoNLLDepTypeAnnotation.class)));
                int govIdx = (Integer)word.get(CoreAnnotations.CoNLLDepParentIndexAnnotation.class);
                if (govIdx == 0) {
                    gov = new IndexedWord(word.docID(), word.sentIndex(), 0);
                    gov.setValue("ROOT");
                    if (((String)word.get(CoreAnnotations.CoNLLDepTypeAnnotation.class)).equals("root")) {
                        reln = GrammaticalRelation.ROOT;
                    }
                } else {
                    gov = (IndexedWord)sortedTokens.get(govIdx - 1 - offset);
                }
                TypedDependency dep = new TypedDependency(reln, gov, word);
                word.set(CoreAnnotations.LineNumberAnnotation.class, (Object)this.lineNumberCounter);
                deps.add(dep);
                HashMap extraDeps = (HashMap)word.get(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class);
                for (Integer extraGovIdx : extraDeps.keySet()) {
                    GrammaticalRelation extraReln = GrammaticalRelation.valueOf((Language)Language.UniversalEnglish, (String)((String)extraDeps.get(extraGovIdx)));
                    IndexedWord extraGov = (IndexedWord)sortedTokens.get(extraGovIdx - 1);
                    TypedDependency extraDep = new TypedDependency(extraReln, extraGov, word);
                    extraDep.setExtra();
                    deps.add(extraDep);
                }
            }
            ++this.lineNumberCounter;
            SemanticGraph sg = new SemanticGraph(deps);
            comments.forEach(c -> sg.addComment(c));
            return sg;
        }
    }
}

