/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.runner;

import eu.fbk.dh.tint.runner.TintPipeline;
import eu.fbk.dh.tint.runner.TintRunner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TintHandler
extends HttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TintHandler.class);
    private TintPipeline pipeline;
    public static Map<TintRunner.OutputFormat, String> contentTypes = new HashMap<TintRunner.OutputFormat, String>();

    public TintHandler(TintPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void writeOutput(Response response, String contentType, String output) throws IOException {
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.getWriter().write(output);
    }

    public void service(Request request, Response response) throws Exception {
        request.setCharacterEncoding("UTF-8");
        Buffer postBody = request.getPostBody(1024);
        String text = postBody.toStringContent();
        if (request.getParameter("text") != null) {
            text = request.getParameter("text");
        }
        String outputFormat = request.getParameter("format");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TintRunner.OutputFormat format = TintRunner.getOutputFormat(outputFormat, TintRunner.OutputFormat.JSON);
        this.pipeline.run(inputStream, (OutputStream)outputStream, format);
        LOGGER.debug("Text: {}", (Object)text);
        String output = ((Object)outputStream).toString();
        this.writeOutput(response, contentTypes.get((Object)format), output);
    }

    static {
        contentTypes.put(TintRunner.OutputFormat.CONLL, "text/plain");
        contentTypes.put(TintRunner.OutputFormat.XML, "text/xml");
        contentTypes.put(TintRunner.OutputFormat.NAF, "text/xml");
        contentTypes.put(TintRunner.OutputFormat.JSON, "text/json");
        contentTypes.put(TintRunner.OutputFormat.TEXTPRO, "text/plain");
        contentTypes.put(TintRunner.OutputFormat.READABLE, "text/plain");
    }
}

