/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.tokenizer.annotators;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import eu.fbk.dh.tint.tokenizer.ItalianTokenizer;
import eu.fbk.dh.tint.tokenizer.models.ItalianTokenizerModel;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.corenlp.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ItalianTokenizerAnnotator
implements Annotator {
    boolean newlineIsSentenceBreak;
    boolean tokenizeOnlyOnSpace;
    boolean ssplitOnlyOnNewLine;
    ItalianTokenizer tokenizer;

    public ItalianTokenizerAnnotator(String annotatorName, Properties props) {
        String modelFile = props.getProperty(annotatorName + ".model", null);
        this.newlineIsSentenceBreak = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".newlineIsSentenceBreak"), (boolean)true);
        this.tokenizeOnlyOnSpace = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".tokenizeOnlyOnSpace"), (boolean)false);
        this.ssplitOnlyOnNewLine = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".ssplitOnlyOnNewLine"), (boolean)false);
        if (this.ssplitOnlyOnNewLine) {
            this.newlineIsSentenceBreak = true;
        }
        File model = null;
        if (modelFile != null) {
            model = new File(modelFile);
        }
        this.tokenizer = ItalianTokenizerModel.getInstance(model).getTokenizer();
    }

    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        List<List<CoreLabel>> sTokens = this.tokenizer.parse(text, this.newlineIsSentenceBreak, this.tokenizeOnlyOnSpace, this.ssplitOnlyOnNewLine);
        Utils.addBasicAnnotations((Annotation)annotation, sTokens, (String)text);
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.PositionAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class));
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }
}

