/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphAnnotations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DigiCompMorphAnnotator
implements Annotator {
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel c : tokens) {
                    String[] morph_fatures = ((String)c.get(DigiMorphAnnotations.MorphoAnnotation.class)).split(" ");
                    String lemma = (String)c.get(CoreAnnotations.LemmaAnnotation.class);
                    if (morph_fatures.length > 1) {
                        ArrayList<String> comps = new ArrayList<String>();
                        for (String m : morph_fatures) {
                            if (!m.startsWith(lemma + "+") && !m.startsWith(lemma + "~")) continue;
                            comps.add(m);
                        }
                        c.set(DigiMorphAnnotations.MorphoCompAnnotation.class, comps);
                        continue;
                    }
                    if (!morph_fatures[0].startsWith(lemma + "+") && !morph_fatures[0].startsWith(lemma + "~")) continue;
                    c.set(DigiMorphAnnotations.MorphoCompAnnotation.class, new ArrayList<String>(Arrays.asList(morph_fatures[0])));
                }
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(DigiMorphAnnotations.MorphoCompAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.LemmaAnnotation.class, DigiMorphAnnotations.MorphoAnnotation.class)));
    }
}

