/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.HyphenationConfig;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.FontKerning;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import com.itextpdf.layout.splitting.ISplitCharacters;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TextRenderer
extends AbstractRenderer {
    protected static final float TEXT_SPACE_COEFF = 1000.0f;
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final float BOLD_SIMULATION_STROKE_COEFF = 0.033333335f;
    private static final float TYPO_ASCENDER_SCALE_COEFF = 1.2f;
    protected float yLineOffset;
    protected GlyphLine text;
    protected GlyphLine line;
    protected String strToBeConverted;
    protected boolean otfFeaturesApplied = false;
    protected float tabAnchorCharacterPosition = -1.0f;

    public TextRenderer(Text textElement) {
        this(textElement, textElement.getText());
    }

    public TextRenderer(Text textElement, String text) {
        super(textElement);
        this.strToBeConverted = text;
    }

    protected TextRenderer(TextRenderer other) {
        super(other);
        this.text = other.text;
        this.line = other.line;
        this.strToBeConverted = other.strToBeConverted;
        this.otfFeaturesApplied = other.otfFeaturesApplied;
        this.tabAnchorCharacterPosition = other.tabAnchorCharacterPosition;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        float descender;
        float ascender;
        this.convertWaitingStringToGlyphLine();
        LayoutArea area = layoutContext.getArea();
        float[] margins = this.getMargins();
        Rectangle layoutBox = this.applyMargins(area.getBBox().clone(), margins, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(layoutBox, borders, false);
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        boolean anythingPlaced = false;
        int currentTextPos = this.text.start;
        float fontSize = this.getPropertyAsFloat(24).floatValue();
        float textRise = this.getPropertyAsFloat(72).floatValue();
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        PdfFont font = this.getPropertyAsFont(20);
        Float hScale = this.getProperty(29, Float.valueOf(1.0f));
        ISplitCharacters splitCharacters = (ISplitCharacters)this.getProperty(62);
        float italicSkewAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(31)) ? 0.21256f * fontSize : 0.0f;
        float boldSimulationAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(8)) ? 0.033333335f * fontSize : 0.0f;
        this.line = new GlyphLine(this.text);
        this.line.end = -1;
        this.line.start = -1;
        FontMetrics fontMetrics = font.getFontProgram().getFontMetrics();
        if (fontMetrics.getWinAscender() == 0 || fontMetrics.getWinDescender() == 0 || fontMetrics.getTypoAscender() == fontMetrics.getWinAscender() && fontMetrics.getTypoDescender() == fontMetrics.getWinDescender()) {
            ascender = (float)fontMetrics.getTypoAscender() * 1.2f;
            descender = (float)fontMetrics.getTypoDescender() * 1.2f;
        } else {
            ascender = fontMetrics.getWinAscender();
            descender = fontMetrics.getWinDescender();
        }
        float currentLineAscender = 0.0f;
        float currentLineDescender = 0.0f;
        float currentLineHeight = 0.0f;
        int initialLineTextPos = currentTextPos;
        float currentLineWidth = 0.0f;
        int previousCharPos = -1;
        Character tabAnchorCharacter = (Character)this.getProperty(66);
        TextLayoutResult result = null;
        boolean isSplitForcedByImmediateNewLine = false;
        boolean isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = false;
        while (currentTextPos < this.text.end) {
            String word;
            Hyphenation hyph;
            int[] wordBounds;
            if (TextRenderer.noPrint(this.text.get(currentTextPos))) {
                ++currentTextPos;
                continue;
            }
            int nonBreakablePartEnd = this.text.end - 1;
            float nonBreakablePartFullWidth = 0.0f;
            float nonBreakablePartWidthWhichDoesNotExceedAllowedWidth = 0.0f;
            float nonBreakablePartMaxAscender = 0.0f;
            float nonBreakablePartMaxDescender = 0.0f;
            float nonBreakablePartMaxHeight = 0.0f;
            int firstCharacterWhichExceedsAllowedWidth = -1;
            for (int ind = currentTextPos; ind < this.text.end; ++ind) {
                float xAdvance;
                if (TextRenderer.isNewLine(this.text, ind)) {
                    isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = true;
                    firstCharacterWhichExceedsAllowedWidth = ind + 1;
                    if (this.text.start != currentTextPos) break;
                    isSplitForcedByImmediateNewLine = true;
                    isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = false;
                    break;
                }
                Glyph currentGlyph = this.text.get(ind);
                if (TextRenderer.noPrint(currentGlyph)) continue;
                if (tabAnchorCharacter != null && tabAnchorCharacter.charValue() == this.text.get(ind).getUnicode()) {
                    this.tabAnchorCharacterPosition = currentLineWidth + nonBreakablePartFullWidth;
                    tabAnchorCharacter = null;
                }
                float glyphWidth = this.getCharWidth(currentGlyph, fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
                float f = xAdvance = previousCharPos != -1 ? (float)this.text.get(previousCharPos).getXAdvance() : 0.0f;
                if (xAdvance != 0.0f) {
                    xAdvance = this.scaleXAdvance(xAdvance, fontSize, hScale) / 1000.0f;
                }
                if (nonBreakablePartFullWidth + glyphWidth + xAdvance + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() - currentLineWidth && firstCharacterWhichExceedsAllowedWidth == -1) {
                    firstCharacterWhichExceedsAllowedWidth = ind;
                }
                if (firstCharacterWhichExceedsAllowedWidth == -1) {
                    nonBreakablePartWidthWhichDoesNotExceedAllowedWidth += glyphWidth + xAdvance;
                }
                nonBreakablePartMaxAscender = Math.max(nonBreakablePartMaxAscender, ascender);
                nonBreakablePartMaxDescender = Math.min(nonBreakablePartMaxDescender, descender);
                nonBreakablePartMaxHeight = (nonBreakablePartMaxAscender - nonBreakablePartMaxDescender) * fontSize / 1000.0f + textRise;
                previousCharPos = ind;
                if ((nonBreakablePartFullWidth += glyphWidth + xAdvance) + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth()) break;
                if (!splitCharacters.isSplitCharacter(this.text, ind) && ind + 1 != this.text.end && (!splitCharacters.isSplitCharacter(this.text, ind + 1) || !Character.isWhitespace((char)this.text.get(ind + 1).getUnicode()) && !Character.isSpaceChar((char)this.text.get(ind + 1).getUnicode()))) continue;
                nonBreakablePartEnd = ind;
                break;
            }
            if (firstCharacterWhichExceedsAllowedWidth == -1) {
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, nonBreakablePartEnd + 1);
                currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                currentTextPos = nonBreakablePartEnd + 1;
                currentLineWidth += nonBreakablePartFullWidth;
                anythingPlaced = true;
                continue;
            }
            if (Math.max(currentLineHeight, nonBreakablePartMaxHeight) > layoutBox.getHeight()) {
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, firstCharacterWhichExceedsAllowedWidth - 1);
                TextRenderer[] splitResult = this.split(initialLineTextPos);
                return new TextLayoutResult(3, this.occupiedArea, splitResult[0], splitResult[1], this);
            }
            boolean wordSplit = false;
            boolean hyphenationApplied = false;
            HyphenationConfig hyphenationConfig = (HyphenationConfig)this.getProperty(30);
            if (hyphenationConfig != null && (wordBounds = this.getWordBoundsForHyphenation(this.text, currentTextPos, this.text.end, Math.max(currentTextPos, firstCharacterWhichExceedsAllowedWidth - 1))) != null && (hyph = hyphenationConfig.hyphenate(word = this.text.toUnicodeString(wordBounds[0], wordBounds[1]))) != null) {
                for (int i = hyph.length() - 1; i >= 0; --i) {
                    String pre = hyph.getPreHyphenText(i);
                    String pos = hyph.getPostHyphenText(i);
                    float currentHyphenationChoicePreTextWidth = this.getGlyphLineWidth(this.convertToGlyphLine(pre + hyphenationConfig.getHyphenSymbol()), fontSize, hScale, characterSpacing, wordSpacing);
                    if (!(currentLineWidth + currentHyphenationChoicePreTextWidth + italicSkewAddition + boldSimulationAddition <= layoutBox.getWidth())) continue;
                    hyphenationApplied = true;
                    if (this.line.start == -1) {
                        this.line.start = currentTextPos;
                    }
                    this.line.end = Math.max(this.line.end, currentTextPos + pre.length());
                    GlyphLine lineCopy = this.line.copy(this.line.start, this.line.end);
                    lineCopy.add(font.getGlyph((int)hyphenationConfig.getHyphenSymbol()));
                    ++lineCopy.end;
                    this.line = lineCopy;
                    currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                    currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                    currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                    currentLineWidth += currentHyphenationChoicePreTextWidth;
                    currentTextPos += pre.length();
                    break;
                }
            }
            if (nonBreakablePartFullWidth > layoutBox.getWidth() && !anythingPlaced && !hyphenationApplied || isSplitForcedByImmediateNewLine) {
                wordSplit = true;
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                currentTextPos = firstCharacterWhichExceedsAllowedWidth;
                this.line.end = Math.max(this.line.end, firstCharacterWhichExceedsAllowedWidth);
                if (nonBreakablePartFullWidth > layoutBox.getWidth() && !anythingPlaced && !hyphenationApplied) {
                    currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                    currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                    currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                    currentLineWidth += nonBreakablePartWidthWhichDoesNotExceedAllowedWidth;
                } else {
                    currentLineAscender = ascender;
                    currentLineDescender = descender;
                    currentLineHeight = (currentLineAscender - currentLineDescender) * fontSize / 1000.0f + textRise;
                    currentLineWidth += this.getCharWidth(this.line.get(0), fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
                }
            }
            if (this.line.end <= this.line.start) {
                return new TextLayoutResult(3, this.occupiedArea, null, this, this);
            }
            result = new TextLayoutResult(2, this.occupiedArea, null, null).setWordHasBeenSplit(wordSplit);
            break;
        }
        boolean isPlacingForcedWhileNothing = false;
        if (currentLineHeight > layoutBox.getHeight()) {
            if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                return new TextLayoutResult(3, this.occupiedArea, null, this, this);
            }
            isPlacingForcedWhileNothing = true;
        }
        this.yLineOffset = currentLineAscender * fontSize / 1000.0f;
        this.occupiedArea.getBBox().moveDown(currentLineHeight);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + currentLineHeight);
        this.occupiedArea.getBBox().setWidth(Math.max(this.occupiedArea.getBBox().getWidth(), currentLineWidth));
        layoutBox.setHeight(area.getBBox().getHeight() - currentLineHeight);
        this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() + italicSkewAddition + boldSimulationAddition);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
        if (result != null) {
            TextRenderer[] split = isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol ? this.splitIgnoreFirstNewLine(currentTextPos) : this.split(currentTextPos);
            if (isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol) {
                result.setSplitForcedByNewline(true);
            }
            result.setSplitRenderer(split[0]);
            if (split[1].text.start != split[1].text.end) {
                result.setOverflowRenderer(split[1]);
            }
        } else {
            result = new TextLayoutResult(1, this.occupiedArea, null, null, isPlacingForcedWhileNothing ? this : null);
        }
        return result;
    }

    public void applyOtf() {
        this.convertWaitingStringToGlyphLine();
        Character.UnicodeScript script = (Character.UnicodeScript)((Object)this.getProperty(23));
        if (!this.otfFeaturesApplied) {
            FontKerning fontKerning;
            PdfFont font;
            if (script == null && TypographyUtils.isTypographyModuleInitialized()) {
                Collection<Character.UnicodeScript> supportedScripts = TypographyUtils.getSupportedScripts();
                EnumMap<Character.UnicodeScript, Integer> scriptFrequency = new EnumMap<Character.UnicodeScript, Integer>(Character.UnicodeScript.class);
                for (int i = this.text.start; i < this.text.end; ++i) {
                    Character.UnicodeScript glyphScript;
                    int unicode = this.text.get(i).getUnicode();
                    Character.UnicodeScript unicodeScript = glyphScript = unicode > -1 ? Character.UnicodeScript.of(unicode) : null;
                    if (glyphScript == null) continue;
                    if (scriptFrequency.containsKey((Object)glyphScript)) {
                        scriptFrequency.put(glyphScript, (Integer)scriptFrequency.get((Object)glyphScript) + 1);
                        continue;
                    }
                    scriptFrequency.put(glyphScript, 1);
                }
                int max = 0;
                Character.UnicodeScript selectScript = null;
                for (Map.Entry entry : scriptFrequency.entrySet()) {
                    Character.UnicodeScript entryScript = (Character.UnicodeScript)((Object)entry.getKey());
                    if ((Integer)entry.getValue() <= max || Character.UnicodeScript.COMMON.equals((Object)entryScript) || Character.UnicodeScript.UNKNOWN.equals((Object)entryScript) || Character.UnicodeScript.INHERITED.equals((Object)entryScript)) continue;
                    max = (Integer)entry.getValue();
                    selectScript = entryScript;
                }
                if (selectScript == Character.UnicodeScript.ARABIC || selectScript == Character.UnicodeScript.HEBREW && this.parent instanceof LineRenderer) {
                    this.setProperty(7, (Object)BaseDirection.DEFAULT_BIDI);
                }
                if (selectScript != null && supportedScripts != null && supportedScripts.contains((Object)selectScript)) {
                    script = selectScript;
                }
            }
            if (this.isOtfFont(font = this.getPropertyAsFont(20)) && script != null) {
                TypographyUtils.applyOtfScript(font.getFontProgram(), this.text, script);
            }
            if ((fontKerning = this.getProperty(22, FontKerning.NO)) == FontKerning.YES) {
                TypographyUtils.applyKerning(font.getFontProgram(), this.text);
            }
            this.otfFeaturesApplied = true;
        }
    }

    @Override
    public void draw(DrawContext drawContext) {
        super.draw(drawContext);
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean isArtifact = false;
        TagTreePointer tagPointer = null;
        IAccessibleElement accessibleElement = null;
        if (isTagged) {
            accessibleElement = (IAccessibleElement)this.getModelElement();
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
                if (!tagPointer.isElementConnectedToTag(accessibleElement)) {
                    AccessibleAttributesApplier.applyLayoutAttributes(accessibleElement.getRole(), this, document);
                }
                tagPointer.addTag(accessibleElement, true);
            } else {
                isTagged = false;
                if (PdfName.Artifact.equals((Object)role)) {
                    isArtifact = true;
                }
            }
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), false);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyAbsolutePositioningTranslation(false);
        }
        float leftBBoxX = this.occupiedArea.getBBox().getX();
        if (this.line.end > this.line.start) {
            Object underlines;
            PdfFont font = this.getPropertyAsFont(20);
            float fontSize = this.getPropertyAsFloat(24).floatValue();
            Color fontColor = this.getPropertyAsColor(21);
            Integer textRenderingMode = (Integer)this.getProperty(71);
            Float textRise = this.getPropertyAsFloat(72);
            Float characterSpacing = this.getPropertyAsFloat(15);
            Float wordSpacing = this.getPropertyAsFloat(78);
            Float horizontalScaling = (Float)this.getProperty(29);
            float[] skew = (float[])this.getProperty(65);
            boolean italicSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(31));
            boolean boldSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(8));
            Float strokeWidth = null;
            if (boldSimulation) {
                textRenderingMode = 2;
                strokeWidth = Float.valueOf(fontSize / 30.0f);
            }
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag(tagPointer.getTagReference());
            } else if (isArtifact) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            }
            canvas.saveState().beginText().setFontAndSize(font, fontSize);
            if (skew != null && skew.length == 2) {
                canvas.setTextMatrix(1.0f, skew[0], skew[1], 1.0f, leftBBoxX, this.getYLine());
            } else if (italicSimulation) {
                canvas.setTextMatrix(1.0f, 0.0f, 0.21256f, 1.0f, leftBBoxX, this.getYLine());
            } else {
                canvas.moveText((double)leftBBoxX, (double)this.getYLine());
            }
            if (textRenderingMode != 0) {
                canvas.setTextRenderingMode(textRenderingMode.intValue());
            }
            if (textRenderingMode == 1 || textRenderingMode == 2) {
                Color strokeColor;
                if (strokeWidth == null) {
                    strokeWidth = this.getPropertyAsFloat(64);
                }
                if (strokeWidth != null && strokeWidth.floatValue() != 1.0f) {
                    canvas.setLineWidth(strokeWidth.floatValue());
                }
                if ((strokeColor = this.getPropertyAsColor(63)) == null) {
                    strokeColor = fontColor;
                }
                if (strokeColor != null) {
                    canvas.setStrokeColor(strokeColor);
                }
            }
            if (fontColor != null) {
                canvas.setFillColor(fontColor);
            }
            if (textRise != null && textRise.floatValue() != 0.0f) {
                canvas.setTextRise(textRise.floatValue());
            }
            if (characterSpacing != null && characterSpacing.floatValue() != 0.0f) {
                canvas.setCharacterSpacing(characterSpacing.floatValue());
            }
            if (wordSpacing != null && wordSpacing.floatValue() != 0.0f) {
                canvas.setWordSpacing(wordSpacing.floatValue());
            }
            if (horizontalScaling != null && horizontalScaling.floatValue() != 1.0f) {
                canvas.setHorizontalScaling(horizontalScaling.floatValue() * 100.0f);
            }
            GlyphLine.IGlyphLineFilter filter = new GlyphLine.IGlyphLineFilter(){

                public boolean accept(Glyph glyph) {
                    return !TextRenderer.noPrint(glyph);
                }
            };
            boolean appearanceStreamLayout = Boolean.TRUE.equals(this.getPropertyAsBoolean(82));
            if (this.hasOwnProperty(53)) {
                Map<GlyphLine, Boolean> outputs = this.getOutputChunks();
                for (Map.Entry<GlyphLine, Boolean> output : outputs.entrySet()) {
                    boolean writeReversedChars;
                    GlyphLine o = output.getKey().filter(filter);
                    boolean bl = writeReversedChars = !appearanceStreamLayout && output.getValue() != false;
                    if (writeReversedChars) {
                        canvas.openTag(new CanvasTag(PdfName.ReversedChars));
                    }
                    if (appearanceStreamLayout) {
                        o.setActualText(o.start, o.end, null);
                    }
                    canvas.showText(o);
                    if (!writeReversedChars) continue;
                    canvas.closeTag();
                }
            } else {
                if (appearanceStreamLayout) {
                    this.line.setActualText(this.line.start, this.line.end, null);
                }
                canvas.showText(this.line.filter(filter));
            }
            canvas.endText().restoreState();
            if (isTagged || isArtifact) {
                canvas.closeTag();
            }
            if ((underlines = this.getProperty(74)) instanceof List) {
                for (Map.Entry<Object, Boolean> underline : (List)underlines) {
                    if (!(underline instanceof Underline)) continue;
                    this.drawSingleUnderline((Underline)((Object)underline), fontColor, canvas, fontSize, italicSimulation ? 0.21256f : 0.0f);
                }
            } else if (underlines instanceof Underline) {
                this.drawSingleUnderline((Underline)underlines, fontColor, canvas, fontSize, italicSimulation ? 0.21256f : 0.0f);
            }
        }
        if (isRelativePosition) {
            this.applyAbsolutePositioningTranslation(false);
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), true);
        if (isTagged) {
            tagPointer.moveToParent();
            if (this.isLastRendererForModelElement) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        }
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        Float textRise = this.getPropertyAsFloat(72);
        float bottomBBoxY = this.occupiedArea.getBBox().getY();
        float leftBBoxX = this.occupiedArea.getBBox().getX();
        if (background != null) {
            boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            }
            canvas.saveState().setFillColor(background.getColor());
            canvas.rectangle((double)(leftBBoxX - background.getExtraLeft()), (double)(bottomBBoxY + textRise.floatValue() - background.getExtraBottom()), (double)(this.occupiedArea.getBBox().getWidth() + background.getExtraLeft() + background.getExtraRight()), (double)(this.occupiedArea.getBBox().getHeight() - textRise.floatValue() + background.getExtraTop() + background.getExtraBottom()));
            canvas.fill().restoreState();
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    public void trimFirst() {
        this.convertWaitingStringToGlyphLine();
        if (this.text != null) {
            Glyph glyph;
            while (this.text.start < this.text.end && (glyph = this.text.get(this.text.start)).hasValidUnicode() && Character.isWhitespace((char)glyph.getUnicode()) && !TextRenderer.isNewLine(this.text, this.text.start)) {
                ++this.text.start;
            }
        }
    }

    public float trimLast() {
        Glyph currentGlyph;
        int firstNonSpaceCharIndex;
        float trimmedSpace = 0.0f;
        if (this.line.end <= 0) {
            return trimmedSpace;
        }
        float fontSize = this.getPropertyAsFloat(24).floatValue();
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        Float hScale = this.getPropertyAsFloat(29, Float.valueOf(1.0f));
        for (firstNonSpaceCharIndex = this.line.end - 1; firstNonSpaceCharIndex >= this.line.start && (currentGlyph = this.line.get(firstNonSpaceCharIndex)).hasValidUnicode() && Character.isWhitespace((char)currentGlyph.getUnicode()); --firstNonSpaceCharIndex) {
            float currentCharWidth = this.getCharWidth(currentGlyph, fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
            float xAdvance = firstNonSpaceCharIndex > this.line.start ? this.scaleXAdvance(this.line.get(firstNonSpaceCharIndex - 1).getXAdvance(), fontSize, hScale) / 1000.0f : 0.0f;
            trimmedSpace += currentCharWidth - xAdvance;
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - currentCharWidth);
        }
        this.line.end = firstNonSpaceCharIndex + 1;
        return trimmedSpace;
    }

    public float getAscent() {
        return this.yLineOffset;
    }

    public float getDescent() {
        return -(this.occupiedArea.getBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue());
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue();
    }

    public void moveYLineTo(float y) {
        float curYLine = this.getYLine();
        float delta = y - curYLine;
        this.occupiedArea.getBBox().setY(this.occupiedArea.getBBox().getY() + delta);
    }

    public void setText(String text) {
        GlyphLine glyphLine = this.convertToGlyphLine(text);
        this.setText(glyphLine, glyphLine.start, glyphLine.end);
    }

    public void setText(GlyphLine text, int leftPos, int rightPos) {
        this.text = new GlyphLine(text);
        this.text.start = leftPos;
        this.text.end = rightPos;
        this.otfFeaturesApplied = false;
    }

    public GlyphLine getText() {
        this.convertWaitingStringToGlyphLine();
        return this.text;
    }

    public int length() {
        return this.text == null ? 0 : this.text.end - this.text.start;
    }

    @Override
    public String toString() {
        return this.line != null ? this.line.toUnicodeString(this.line.start, this.line.end) : this.strToBeConverted;
    }

    public int charAt(int pos) {
        return this.text.get(pos + this.text.start).getUnicode();
    }

    public float getTabAnchorCharacterPosition() {
        return this.tabAnchorCharacterPosition;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new TextRenderer((Text)this.modelElement, null);
    }

    protected static boolean isNewLine(GlyphLine text, int ind) {
        int unicode = text.get(ind).getUnicode();
        return unicode == 10 || unicode == 13;
    }

    private TextRenderer[] splitIgnoreFirstNewLine(int currentTextPos) {
        if (this.text.get(currentTextPos).hasValidUnicode() && this.text.get(currentTextPos).getUnicode() == 13) {
            int next;
            int n = next = currentTextPos + 1 < this.text.end ? this.text.get(currentTextPos + 1).getUnicode() : -1;
            if (next == 10) {
                return this.split(currentTextPos + 2);
            }
            return this.split(currentTextPos + 1);
        }
        return this.split(currentTextPos + 1);
    }

    private GlyphLine convertToGlyphLine(String text) {
        PdfFont font = this.getPropertyAsFont(20);
        return font.createGlyphLine(text);
    }

    private boolean isOtfFont(PdfFont font) {
        return font instanceof PdfType0Font && font.getFontProgram() instanceof TrueTypeFont;
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    protected int lineLength() {
        return this.line.end > 0 ? this.line.end - this.line.start : 0;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph glyph = this.line.get(i);
            if (glyph.hasPlacement()) continue;
            ++count;
        }
        return count;
    }

    protected int getNumberOfSpaces() {
        if (this.line.end <= 0) {
            return 0;
        }
        int spaces = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph currentGlyph = this.line.get(i);
            if (!currentGlyph.hasValidUnicode() || currentGlyph.getUnicode() != 32) continue;
            ++spaces;
        }
        return spaces;
    }

    protected TextRenderer createSplitRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer createOverflowRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer[] split(int initialOverflowTextPos) {
        TextRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.setText(this.text, this.text.start, initialOverflowTextPos);
        splitRenderer.line = this.line;
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.yLineOffset = this.yLineOffset;
        splitRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        TextRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.setText(this.text, initialOverflowTextPos, this.text.end);
        overflowRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new TextRenderer[]{splitRenderer, overflowRenderer};
    }

    protected void drawSingleUnderline(Underline underline, Color fontStrokeColor, PdfCanvas canvas, float fontSize, float italicAngleTan) {
        Color underlineColor = underline.getColor() != null ? underline.getColor() : fontStrokeColor;
        canvas.saveState();
        if (underlineColor != null) {
            canvas.setStrokeColor(underlineColor);
        }
        canvas.setLineCapStyle(underline.getLineCapStyle());
        float underlineThickness = underline.getThickness(fontSize);
        if (underlineThickness != 0.0f) {
            canvas.setLineWidth(underlineThickness);
            float yLine = this.getYLine();
            float underlineYPosition = underline.getYPosition(fontSize) + yLine;
            float italicWidthSubstraction = 0.5f * fontSize * italicAngleTan;
            canvas.moveTo((double)this.occupiedArea.getBBox().getX(), (double)underlineYPosition).lineTo((double)(this.occupiedArea.getBBox().getX() + this.occupiedArea.getBBox().getWidth() - italicWidthSubstraction), (double)underlineYPosition).stroke();
        }
        canvas.restoreState();
    }

    protected float calculateLineWidth() {
        return this.getGlyphLineWidth(this.line, this.getPropertyAsFloat(24).floatValue(), this.getPropertyAsFloat(29, Float.valueOf(1.0f)), this.getPropertyAsFloat(15), this.getPropertyAsFloat(78));
    }

    private Map<GlyphLine, Boolean> getOutputChunks() {
        List reversedRange = (List)this.getProperty(53);
        LinkedHashMap<GlyphLine, Boolean> outputs = new LinkedHashMap<GlyphLine, Boolean>();
        if (reversedRange != null) {
            if (((int[])reversedRange.get(0))[0] > 0) {
                outputs.put(this.line.copy(0, ((int[])reversedRange.get(0))[0]), false);
            }
            for (int i = 0; i < reversedRange.size(); ++i) {
                int[] range = (int[])reversedRange.get(i);
                outputs.put(this.line.copy(range[0], range[1] + 1), true);
                if (i == reversedRange.size() - 1) continue;
                outputs.put(this.line.copy(range[1] + 1, ((int[])reversedRange.get(i + 1))[0]), false);
            }
            int lastIndex = ((int[])reversedRange.get(reversedRange.size() - 1))[1];
            if (lastIndex < this.line.size()) {
                outputs.put(this.line.copy(lastIndex + 1, this.line.size()), false);
            }
        } else {
            outputs.put(this.line, false);
        }
        return outputs;
    }

    private static boolean noPrint(Glyph g) {
        if (!g.hasValidUnicode()) {
            return false;
        }
        int c = g.getUnicode();
        return c >= 8203 && c <= 8207 || c >= 8234 && c <= 8238 || c == 173;
    }

    private float getCharWidth(Glyph g, float fontSize, Float hScale, Float characterSpacing, Float wordSpacing) {
        if (hScale == null) {
            hScale = Float.valueOf(1.0f);
        }
        float resultWidth = (float)g.getWidth() * fontSize * hScale.floatValue();
        if (characterSpacing != null) {
            resultWidth += characterSpacing.floatValue() * hScale.floatValue() * 1000.0f;
        }
        if (wordSpacing != null && g.hasValidUnicode() && g.getUnicode() == 32) {
            resultWidth += wordSpacing.floatValue() * hScale.floatValue() * 1000.0f;
        }
        return resultWidth;
    }

    private float scaleXAdvance(float xAdvance, float fontSize, Float hScale) {
        return xAdvance * fontSize * hScale.floatValue();
    }

    private float getGlyphLineWidth(GlyphLine glyphLine, float fontSize, Float hScale, Float characterSpacing, Float wordSpacing) {
        float width = 0.0f;
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            float charWidth = this.getCharWidth(glyphLine.get(i), fontSize, hScale, characterSpacing, wordSpacing);
            width += charWidth;
            float xAdvance = i != glyphLine.start ? this.scaleXAdvance(glyphLine.get(i - 1).getXAdvance(), fontSize, hScale) : 0.0f;
            width += xAdvance;
        }
        return width / 1000.0f;
    }

    private int[] getWordBoundsForHyphenation(GlyphLine text, int leftTextPos, int rightTextPos, int wordMiddleCharPos) {
        while (wordMiddleCharPos >= leftTextPos && !this.isGlyphPartOfWordForHyphenation(text.get(wordMiddleCharPos)) && !this.isWhitespaceGlyph(text.get(wordMiddleCharPos))) {
            --wordMiddleCharPos;
        }
        if (wordMiddleCharPos >= leftTextPos) {
            int right;
            int left;
            for (left = wordMiddleCharPos; left >= leftTextPos && this.isGlyphPartOfWordForHyphenation(text.get(left)); --left) {
            }
            for (right = wordMiddleCharPos; right < rightTextPos && this.isGlyphPartOfWordForHyphenation(text.get(right)); ++right) {
            }
            return new int[]{left + 1, right};
        }
        return null;
    }

    private boolean isGlyphPartOfWordForHyphenation(Glyph g) {
        return g.hasValidUnicode() && (Character.isLetter((char)g.getUnicode()) || Character.isDigit((char)g.getUnicode()) || 173 == g.getUnicode());
    }

    private boolean isWhitespaceGlyph(Glyph g) {
        return g.hasValidUnicode() && g.getUnicode() == 32;
    }

    private void convertWaitingStringToGlyphLine() {
        if (this.strToBeConverted != null) {
            GlyphLine glyphLine = this.convertToGlyphLine(this.strToBeConverted);
            this.setText(glyphLine, glyphLine.start, glyphLine.end);
            this.strToBeConverted = null;
        }
    }
}

