/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;
import com.itextpdf.layout.element.Tab;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;

public class TabRenderer
extends AbstractRenderer {
    public TabRenderer(Tab tab) {
        super(tab);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutArea area = layoutContext.getArea();
        Float width = this.retrieveWidth(area.getBBox().getWidth());
        Float height = this.getPropertyAsFloat(27);
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(area.getBBox().getX(), area.getBBox().getY() + area.getBBox().getHeight(), width.floatValue(), height.floatValue()));
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        ILineDrawer leader = (ILineDrawer)this.getProperty(68);
        if (leader == null) {
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled();
        if (isTagged) {
            drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
        }
        leader.draw(drawContext.getCanvas(), this.occupiedArea.getBBox());
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new TabRenderer((Tab)this.modelElement);
    }
}

