/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.Property;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
implements IRenderer {
    public static final float EPS = 1.0E-4f;
    public static final float INF = 1000000.0f;
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected boolean isLastRendererForModelElement = true;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea.clone();
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        Integer positioning = (Integer)renderer.getProperty(52);
        if (positioning == null || positioning == 2 || positioning == 1) {
            this.childRenderers.add(renderer);
        } else if (positioning == 4) {
            AbstractRenderer root = this;
            while (root.parent instanceof AbstractRenderer) {
                root = (AbstractRenderer)root.parent;
            }
            if (root == this) {
                this.positionedRenderers.add(renderer);
            } else {
                root.addChild(renderer);
            }
        }
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    public boolean hasOwnOrModelProperty(int property) {
        return this.properties.containsKey(property) || null != this.getModelElement() && this.getModelElement().hasProperty(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        return null;
    }

    public PdfFont getPropertyAsFont(int property) {
        return (PdfFont)this.getProperty(property);
    }

    public Color getPropertyAsColor(int property) {
        return (Color)this.getProperty(property);
    }

    public Float getPropertyAsFloat(int property) {
        Number value = (Number)this.getProperty(property);
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    public Float getPropertyAsFloat(int property, Float defaultValue) {
        Number value = this.getProperty(property, defaultValue);
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    public Integer getPropertyAsInteger(int property) {
        Number value = (Number)this.getProperty(property);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyAbsolutePositioningTranslation(false);
        }
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        if (relativePosition) {
            this.applyAbsolutePositioningTranslation(true);
        }
        this.flushed = true;
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        if (background != null) {
            Rectangle backgroundArea;
            boolean isTagged;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            if (isTagged) {
                drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
            }
            if ((backgroundArea = this.applyMargins(bBox, false)).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background"));
                return;
            }
            drawContext.getCanvas().saveState().setFillColor(background.getColor()).rectangle((double)(backgroundArea.getX() - background.getExtraLeft()), (double)(backgroundArea.getY() - background.getExtraBottom()), (double)(backgroundArea.getWidth() + background.getExtraLeft() + background.getExtraRight()), (double)(backgroundArea.getHeight() + background.getExtraTop() + background.getExtraBottom())).fill().restoreState();
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    public void drawChildren(DrawContext drawContext) {
        for (IRenderer child : this.childRenderers) {
            child.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() <= 0.0f || bBox.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "border"));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            }
            if (borders[0] != null) {
                canvas.saveState();
                borders[0].draw(canvas, x1, y2, x2, y2, leftWidth, rightWidth);
                canvas.restoreState();
            }
            if (borders[1] != null) {
                canvas.saveState();
                borders[1].draw(canvas, x2, y2, x2, y1, topWidth, bottomWidth);
                canvas.restoreState();
            }
            if (borders[2] != null) {
                canvas.saveState();
                borders[2].draw(canvas, x2, y1, x1, y1, rightWidth, leftWidth);
                canvas.restoreState();
            }
            if (borders[3] != null) {
                canvas.saveState();
                borders[3].draw(canvas, x1, y1, x1, y2, bottomWidth, topWidth);
                canvas.restoreState();
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        return this.retrieveUnitValue(parentBoxWidth, 77);
    }

    protected Float retrieveHeight() {
        return (Float)this.getProperty(27);
    }

    protected Float retrieveUnitValue(float basePercentValue, int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        if (value != null) {
            if (value.getUnitType() == 1) {
                return Float.valueOf(value.getValue());
            }
            if (value.getUnitType() == 2) {
                return Float.valueOf(value.getValue() * basePercentValue / 100.0f);
            }
            throw new IllegalStateException("invalid unit type");
        }
        return null;
    }

    protected Map<Integer, Object> getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(Map<Integer, Object> properties) {
        this.properties.putAll(properties);
    }

    protected Float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return null;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return this.applyMargins(rect, this.getMargins(), reverse);
    }

    protected Rectangle applyMargins(Rectangle rect, float[] margins, boolean reverse) {
        if (this.isPositioned()) {
            return rect;
        }
        return rect.applyMargins(margins[0], margins[1], margins[2], margins[3], reverse);
    }

    protected float[] getMargins() {
        return new float[]{this.getPropertyAsFloat(46).floatValue(), this.getPropertyAsFloat(45).floatValue(), this.getPropertyAsFloat(43).floatValue(), this.getPropertyAsFloat(44).floatValue()};
    }

    protected float[] getPaddings() {
        return new float[]{this.getPropertyAsFloat(50).floatValue(), this.getPropertyAsFloat(49).floatValue(), this.getPropertyAsFloat(47).floatValue(), this.getPropertyAsFloat(48).floatValue()};
    }

    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return this.applyPaddings(rect, this.getPaddings(), reverse);
    }

    protected Rectangle applyPaddings(Rectangle rect, float[] paddings, boolean reverse) {
        return rect.applyMargins(paddings[0], paddings[1], paddings[2], paddings[3], reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        Border[] borders = this.getBorders();
        return this.applyBorderBox(rect, borders, reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
        float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
        float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
        float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
        return rect.applyMargins(topWidth, rightWidth, bottomWidth, leftWidth, reverse);
    }

    protected void applyAbsolutePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73).floatValue();
        float bottom = this.getPropertyAsFloat(14).floatValue();
        float left = this.getPropertyAsFloat(34).floatValue();
        float right = this.getPropertyAsFloat(54).floatValue();
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
        String destination = (String)this.getProperty(17);
        if (destination != null) {
            PdfArray array = new PdfArray();
            array.add(document.getPage(this.occupiedArea.getPageNumber()).getPdfObject());
            array.add((PdfObject)PdfName.XYZ);
            array.add((PdfObject)new PdfNumber((double)this.occupiedArea.getBBox().getX()));
            array.add((PdfObject)new PdfNumber((double)(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight())));
            array.add((PdfObject)new PdfNumber(1));
            document.addNamedDestination(destination, (PdfObject)array.makeIndirect(document));
            this.deleteProperty(17);
        }
    }

    protected void applyAction(PdfDocument document) {
        PdfAction action = (PdfAction)this.getProperty(1);
        if (action != null) {
            PdfLinkAnnotation link = new PdfLinkAnnotation(this.getOccupiedArea().getBBox());
            link.setAction(action);
            Border border = (Border)this.getProperty(9);
            if (border != null) {
                link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, border.getWidth()}));
            } else {
                link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
            }
            document.getPage(this.getOccupiedArea().getPageNumber()).addAnnotation((PdfAnnotation)link);
        }
    }

    @Deprecated
    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        return this.isNotFittingLayoutArea(layoutArea);
    }

    protected boolean isNotFittingLayoutArea(LayoutArea layoutArea) {
        Rectangle area = this.applyMargins(layoutArea.getBBox().clone(), false);
        area = this.applyPaddings(area, false);
        return !this.isPositioned() && (this.occupiedArea.getBBox().getHeight() > area.getHeight() || this.occupiedArea.getBBox().getWidth() > area.getWidth());
    }

    protected boolean isPositioned() {
        return this.isFixedLayout();
    }

    protected boolean isFixedLayout() {
        Object positioning = this.getProperty(52);
        return Integer.valueOf(4).equals(positioning);
    }

    protected boolean isRelativePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(2).equals(positioning);
    }

    protected boolean isKeepTogether() {
        return Boolean.TRUE.equals(this.getPropertyAsBoolean(32));
    }

    protected void alignChildHorizontally(IRenderer childRenderer, float availableWidth) {
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT) {
            float freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth();
            switch (horizontalAlignment) {
                case RIGHT: {
                    childRenderer.move(freeSpace, 0.0f);
                    break;
                }
                case CENTER: {
                    childRenderer.move(freeSpace / 2.0f, 0.0f);
                }
            }
        }
    }

    protected Border[] getBorders() {
        Border border = (Border)this.getProperty(9);
        Border topBorder = (Border)this.getProperty(13);
        Border rightBorder = (Border)this.getProperty(12);
        Border bottomBorder = (Border)this.getProperty(10);
        Border leftBorder = (Border)this.getProperty(11);
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        if (!this.hasOwnOrModelProperty(13)) {
            borders[0] = border;
        }
        if (!this.hasOwnOrModelProperty(12)) {
            borders[1] = border;
        }
        if (!this.hasOwnOrModelProperty(10)) {
            borders[2] = border;
        }
        if (!this.hasOwnOrModelProperty(11)) {
            borders[3] = border;
        }
        return borders;
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setProperty(13, border);
                break;
            }
            case 1: {
                this.setProperty(12, border);
                break;
            }
            case 2: {
                this.setProperty(10, border);
                break;
            }
            case 3: {
                this.setProperty(11, border);
            }
        }
        return this;
    }

    protected Rectangle calculateAbsolutePdfBBox() {
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> contentBoxPoints = this.rectangleToPointsList(contentBox);
        AbstractRenderer renderer = this;
        while (renderer.parent != null) {
            Float angle;
            if (renderer instanceof BlockRenderer && (angle = (Float)renderer.getProperty(55)) != null) {
                BlockRenderer blockRenderer = (BlockRenderer)renderer;
                AffineTransform rotationTransform = blockRenderer.createRotationTransformInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            renderer = (AbstractRenderer)renderer.parent;
        }
        return this.calculateBBox(contentBoxPoints);
    }

    protected Rectangle calculateBBox(List<Point> points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point p : points) {
            minX = Math.min(p.getX(), minX);
            minY = Math.min(p.getY(), minY);
            maxX = Math.max(p.getX(), maxX);
            maxY = Math.max(p.getY(), maxY);
        }
        return new Rectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
    }

    protected List<Point> rectangleToPointsList(Rectangle rect) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(Arrays.asList(new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop()), new Point((double)rect.getLeft(), (double)rect.getTop())));
        return points;
    }

    protected List<Point> transformPoints(List<Point> points, AffineTransform transform) {
        for (Point point : points) {
            transform.transform(point, point);
        }
        return points;
    }
}

