/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.core;

import eu.fbk.utils.core.core.IndexSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeIndexSet<E>
extends IndexSet<E>
implements Serializable,
Cloneable,
Iterable<E>,
Collection<E>,
Set<E> {
    static Logger logger = LoggerFactory.getLogger(TreeIndexSet.class);
    private static final long serialVersionUID = 41L;

    public TreeIndexSet(boolean threadSafe) {
        this(threadSafe, 0);
    }

    public TreeIndexSet() {
        this(0);
    }

    public TreeIndexSet(boolean threadSafe, int from) {
        super(from);
        this.map = threadSafe ? Collections.synchronizedMap(new TreeMap()) : new TreeMap();
    }

    public TreeIndexSet(int from) {
        super(from);
        this.map = new TreeMap();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            logger.info("java eu.fbk.utils.core.core.TreeIndexSet element+");
            System.exit(-1);
        }
        TreeIndexSet<String> set = new TreeIndexSet<String>();
        logger.info("element\tadded\tindex");
        for (int i = 0; i < args.length; ++i) {
            boolean b = set.add(args[i]);
            logger.info(args[i] + "\t" + b + "\t" + set.getIndex(args[i]));
        }
    }
}

