/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.collect.Lists;
import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EasySpan
implements Comparable<EasySpan> {
    public int begin;
    public int end;
    private static final Logger LOGGER = LoggerFactory.getLogger(EasySpan.class);

    public EasySpan(String span) {
        String trimmedSpan = span.trim();
        int delimiter = trimmedSpan.indexOf(44);
        this.begin = Integer.parseInt(trimmedSpan.substring(0, delimiter));
        this.end = Integer.parseInt(trimmedSpan.substring(delimiter + 1));
    }

    public EasySpan(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public String apply(String text) {
        return this.apply(text, true);
    }

    public String apply(String text, boolean escapeHTML) {
        if (escapeHTML) {
            return HtmlEscapers.htmlEscaper().escape(text.substring(this.begin, this.end));
        }
        return text.substring(this.begin, this.end);
    }

    public boolean contains(EasySpan span) {
        return this.begin <= span.begin && this.end >= span.end;
    }

    public boolean overlaps(EasySpan span) {
        return this.end > span.begin && this.begin < span.end;
    }

    public List<EasySpan> split(Iterable<EasySpan> spans) {
        ArrayList sortedSpans = Lists.newArrayList(spans);
        boolean overlaps = true;
        block0: while (overlaps) {
            overlaps = false;
            Collections.sort(sortedSpans);
            for (int i = 0; i < sortedSpans.size() - 1; ++i) {
                EasySpan span1 = (EasySpan)sortedSpans.get(i);
                EasySpan span2 = (EasySpan)sortedSpans.get(i + 1);
                if (span1.end <= span2.begin) continue;
                sortedSpans.remove(i);
                if (span1.begin < span2.begin) {
                    sortedSpans.add(new EasySpan(span1.begin, span2.begin));
                }
                if (span1.end < span2.end) {
                    sortedSpans.remove(i);
                    sortedSpans.add(new EasySpan(span2.begin, span1.end));
                    sortedSpans.add(new EasySpan(span1.end, span2.end));
                } else if (span1.end > span2.end) {
                    sortedSpans.add(new EasySpan(span2.end, span1.end));
                }
                overlaps = true;
                continue block0;
            }
        }
        ArrayList result = Lists.newArrayList();
        int index = this.begin;
        for (EasySpan span : sortedSpans) {
            if (span.begin < index) {
                throw new Error("Span overlap: " + spans);
            }
            if (span.begin > index) {
                result.add(new EasySpan(index, span.begin));
            }
            result.add(span);
            index = span.end;
        }
        if (index < this.end) {
            result.add(new EasySpan(index, this.end));
        }
        return result;
    }

    @Override
    public int compareTo(EasySpan span) {
        int result = this.begin - span.begin;
        if (result == 0) {
            result = span.end - this.end;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EasySpan)) {
            return false;
        }
        EasySpan other = (EasySpan)object;
        return this.begin == other.begin && this.end == other.end;
    }

    public int hashCode() {
        return this.begin * 37 + this.end;
    }

    public String toString() {
        return this.begin + "," + this.end;
    }
}

