/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import eu.fbk.utils.core.Conversion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;

public final class CommandLine {
    private final List<String> args;
    private final List<String> options;
    private final Map<String, List<String>> optionValues;

    private CommandLine(List<String> args, Map<String, List<String>> optionValues) {
        ArrayList options = Lists.newArrayList();
        for (String letterOrName : optionValues.keySet()) {
            if (letterOrName.length() <= 1) continue;
            options.add(letterOrName);
        }
        this.args = args;
        this.options = Ordering.natural().immutableSortedCopy((Iterable)options);
        this.optionValues = optionValues;
    }

    public <T> List<T> getArgs(Class<T> type) {
        return CommandLine.convert(this.args, type);
    }

    public <T> T getArg(int index, Class<T> type) {
        return CommandLine.convert(this.args.get(index), type);
    }

    public <T> T getArg(int index, Class<T> type, T defaultValue) {
        try {
            return CommandLine.convert(this.args.get(index), type);
        }
        catch (Throwable ex) {
            return defaultValue;
        }
    }

    public int getArgCount() {
        return this.args.size();
    }

    public List<String> getOptions() {
        return this.options;
    }

    public boolean hasOption(String letterOrName) {
        return this.optionValues.containsKey(letterOrName);
    }

    public <T> List<T> getOptionValues(String letterOrName, Class<T> type) {
        List strings = (List)MoreObjects.firstNonNull(this.optionValues.get(letterOrName), (Object)ImmutableList.of());
        return CommandLine.convert(strings, type);
    }

    @Nullable
    public <T> T getOptionValue(String letterOrName, Class<T> type) {
        List<String> strings = this.optionValues.get(letterOrName);
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        if (strings.size() > 1) {
            throw new Exception("Multiple values for option '" + letterOrName + "': " + Joiner.on((String)", ").join(strings), null);
        }
        try {
            return CommandLine.convert(strings.get(0), type);
        }
        catch (Throwable ex) {
            throw new Exception("'" + strings.get(0) + "' is not a valid " + type.getSimpleName(), ex);
        }
    }

    @Nullable
    public <T> T getOptionValue(String letterOrName, Class<T> type, @Nullable T defaultValue) {
        List<String> strings = this.optionValues.get(letterOrName);
        if (strings == null || strings.isEmpty() || strings.size() > 1) {
            return defaultValue;
        }
        try {
            return CommandLine.convert(strings.get(0), type);
        }
        catch (Throwable ex) {
            return defaultValue;
        }
    }

    public int getOptionCount() {
        return this.options.size();
    }

    private static <T> T convert(String string, Class<T> type) {
        try {
            if (Path.class.isAssignableFrom(type)) {
                return (T)Paths.get(string, new String[0]);
            }
            return Conversion.convert(string, type);
        }
        catch (Throwable ex) {
            throw new Exception("'" + string + "' is not a valid " + type.getSimpleName(), ex);
        }
    }

    private static <T> List<T> convert(List<String> strings, Class<T> type) {
        if (type == String.class) {
            return strings;
        }
        ArrayList list = Lists.newArrayList();
        for (String string : strings) {
            list.add(CommandLine.convert(string, type));
        }
        return ImmutableList.copyOf((Collection)list);
    }

    private static Object call(Object object, String methodName, Object ... args) {
        boolean isStatic = object instanceof Class;
        Class<?> clazz = isStatic ? (Class<?>)object : object.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || isStatic != Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != args.length) continue;
            try {
                return method.invoke(isStatic ? null : object, args);
            }
            catch (InvocationTargetException ex) {
                Throwables.throwIfUnchecked((Throwable)ex.getCause());
                throw new RuntimeException(ex.getCause());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot invoke " + method, ex);
            }
        }
        throw new IllegalArgumentException("Cannot invoke " + methodName);
    }

    public static void fail(Throwable throwable) {
        if (throwable instanceof Exception) {
            if (throwable.getMessage() == null) {
                System.exit(0);
            } else {
                System.err.println("SYNTAX ERROR: " + throwable.getMessage());
            }
            System.exit(-2);
        } else {
            System.err.println("EXECUTION FAILED: " + throwable.getMessage());
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    public static Parser parser() {
        return new Parser();
    }

    public static enum Type {
        STRING,
        INTEGER,
        POSITIVE_INTEGER,
        NON_NEGATIVE_INTEGER,
        FLOAT,
        POSITIVE_FLOAT,
        NON_NEGATIVE_FLOAT,
        FILE,
        FILE_EXISTING,
        DIRECTORY,
        DIRECTORY_EXISTING;

        public static HashMap<Type, Class<?>> toClass;

        public boolean validate(String string) {
            return Type.validate(string, this);
        }

        public Class<?> toClass() {
            return toClass.get((Object)this);
        }

        private static boolean validate(String string, Type type) {
            block14: {
                if (type == INTEGER || type == POSITIVE_INTEGER || type == NON_NEGATIVE_INTEGER) {
                    try {
                        long n = Long.parseLong(string);
                        if (type == POSITIVE_INTEGER) {
                            return n > 0L;
                        }
                        if (type == NON_NEGATIVE_INTEGER) {
                            return n >= 0L;
                        }
                        break block14;
                    }
                    catch (Throwable ex) {
                        return false;
                    }
                }
                if (type == FLOAT || type == POSITIVE_FLOAT || type == NON_NEGATIVE_FLOAT) {
                    try {
                        double n = Double.parseDouble(string);
                        if (type == POSITIVE_FLOAT) {
                            return n > 0.0;
                        }
                        if (type == NON_NEGATIVE_FLOAT) {
                            return n >= 0.0;
                        }
                        break block14;
                    }
                    catch (Throwable ex) {
                        return false;
                    }
                }
                if (type == FILE) {
                    File file = new File(string);
                    return !file.exists() || file.isFile();
                }
                if (type == FILE_EXISTING) {
                    File file = new File(string);
                    return file.exists() && file.isFile();
                }
                if (type == DIRECTORY) {
                    File dir = new File(string);
                    return !dir.exists() || dir.isDirectory();
                }
                if (type == DIRECTORY_EXISTING) {
                    File dir = new File(string);
                    return dir.exists() && dir.isDirectory();
                }
            }
            return true;
        }

        static {
            toClass = new HashMap();
            toClass.put(STRING, String.class);
            toClass.put(INTEGER, Integer.class);
            toClass.put(POSITIVE_INTEGER, Integer.class);
            toClass.put(NON_NEGATIVE_INTEGER, Integer.class);
            toClass.put(FLOAT, Float.class);
            toClass.put(POSITIVE_FLOAT, Float.class);
            toClass.put(NON_NEGATIVE_FLOAT, Float.class);
            toClass.put(FILE, File.class);
            toClass.put(FILE_EXISTING, File.class);
            toClass.put(DIRECTORY, File.class);
            toClass.put(DIRECTORY_EXISTING, File.class);
        }
    }

    public static final class Exception
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class Parser {
        @Nullable
        private String name = null;
        @Nullable
        private String header = null;
        @Nullable
        private String footer = null;
        @Nullable
        private Logger logger;
        private final Options options = new Options();
        private final Set<String> mandatoryOptions = new HashSet<String>();

        public Parser withName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Parser withHeader(@Nullable String header) {
            this.header = header;
            return this;
        }

        public Parser withFooter(@Nullable String footer) {
            this.footer = footer;
            return this;
        }

        public Parser withLogger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        public Parser withOption(@Nullable String shortName, @Nullable String longName, @Nullable String description) {
            this.checkOptionNames(shortName, longName);
            Option option = new Option(shortName == null ? null : shortName, longName, false, description);
            this.options.addOption(option);
            return this;
        }

        public Parser withOption(@Nullable String shortName, @Nullable String longName, @Nullable String description, String argName, @Nullable Type argType, boolean argRequired, boolean multiValue, boolean mandatory) {
            this.checkOptionNames(shortName, longName);
            Preconditions.checkNotNull((Object)argName);
            if (argName.isEmpty()) {
                throw new IllegalArgumentException("Empty argName string");
            }
            Option option = new Option(shortName == null ? null : shortName.toString(), longName, true, description);
            option.setArgName(argName);
            option.setOptionalArg(!argRequired);
            option.setArgs(multiValue ? Short.MAX_VALUE : 1);
            option.setType(argType.toClass());
            this.options.addOption(option);
            if (mandatory) {
                this.mandatoryOptions.add(longName);
            }
            return this;
        }

        public CommandLine parse(String ... args) {
            try {
                if (this.logger != null) {
                    this.options.addOption(null, "debug", false, "enable verbose output");
                    this.options.addOption(null, "trace", false, "enable very verbose output");
                }
                this.options.addOption("v", "version", false, "display version information and terminate");
                this.options.addOption("h", "help", false, "display this help message and terminate");
                org.apache.commons.cli.CommandLine cmd = null;
                try {
                    cmd = new DefaultParser().parse(this.options, args);
                }
                catch (Throwable ex) {
                    System.err.println("SYNTAX ERROR: " + ex.getMessage());
                    this.printHelp();
                    throw new Exception(null);
                }
                try {
                    Object level;
                    Class<?> levelClass;
                    String loggerClassName = this.logger.getClass().getName();
                    if (loggerClassName.equals("ch.qos.logback.classic.Logger")) {
                        levelClass = Class.forName("ch.qos.logback.classic.Level");
                        level = CommandLine.call(levelClass, "valueOf", new Object[]{cmd.hasOption("trace") ? "TRACE" : (cmd.hasOption("debug") ? "DEBUG" : "INFO")});
                        CommandLine.call(this.logger, "setLevel", new Object[]{level});
                    } else if (loggerClassName.equals("org.apache.log4j.Logger")) {
                        levelClass = Class.forName("org.apache.log4j.Level");
                        level = CommandLine.call(levelClass, "valueOf", new Object[]{cmd.hasOption("trace") ? "TRACE" : (cmd.hasOption("debug") ? "DEBUG" : "INFO")});
                        CommandLine.call(this.logger, "setLevel", new Object[]{level});
                    } else if (loggerClassName.equals("org.apache.logging.slf4j.Log4jLogger")) {
                        Class<?> managerClass = Class.forName("org.apache.logging.log4j.LogManager");
                        Object ctx = CommandLine.call(managerClass, "getContext", new Object[]{false});
                        Object config = CommandLine.call(ctx, "getConfiguration", new Object[0]);
                        Object logConfig = CommandLine.call(config, "getLoggerConfig", new Object[]{this.logger.getName()});
                        Class<?> levelClass2 = Class.forName("org.apache.logging.log4j.Level");
                        Object level2 = CommandLine.call(levelClass2, "valueOf", new Object[]{cmd.hasOption("trace") ? "TRACE" : (cmd.hasOption("debug") ? "DEBUG" : "INFO")});
                        CommandLine.call(logConfig, "setLevel", new Object[]{level2});
                        CommandLine.call(ctx, "updateLoggers", new Object[0]);
                    }
                }
                catch (Throwable loggerClassName) {
                    // empty catch block
                }
                if (cmd.hasOption('v')) {
                    this.printVersion();
                    throw new Exception(null);
                }
                if (cmd.hasOption('h')) {
                    this.printHelp();
                    throw new Exception(null);
                }
                for (String name : this.mandatoryOptions) {
                    if (cmd.hasOption(name)) continue;
                    System.err.println("SYNTAX ERROR: missing mandatory option " + name);
                    this.printHelp();
                    throw new Exception(null);
                }
                HashMap optionValues = Maps.newHashMap();
                for (Option option : cmd.getOptions()) {
                    ArrayList valueList = Lists.newArrayList();
                    String[] values = cmd.getOptionValues(option.getLongOpt());
                    if (values != null) {
                        for (String value : values) {
                            if (option.getType() instanceof Type) {
                                Type.validate(value, (Type)((Object)option.getType()));
                            }
                            valueList.add(value);
                        }
                    }
                    ImmutableList valueSet = ImmutableList.copyOf((Collection)valueList);
                    optionValues.put(option.getLongOpt(), valueSet);
                    if (option.getOpt() == null) continue;
                    optionValues.put(option.getOpt(), valueSet);
                }
                return new CommandLine((List)ImmutableList.copyOf((Collection)cmd.getArgList()), optionValues);
            }
            catch (Throwable ex) {
                throw new Exception(ex.getMessage(), ex);
            }
        }

        private void checkOptionNames(@Nullable String shortName, @Nullable String longName) {
            if (shortName == null && longName == null) {
                throw new IllegalArgumentException("At least one among short and long option names should be specified");
            }
            if (longName != null && longName.length() <= 1) {
                throw new IllegalArgumentException("Long option name should be longer than one character");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printVersion() {
            String version = "(development)";
            URL url = CommandLine.class.getClassLoader().getResource("META-INF/maven/eu.fbk.nafview/nafview/pom.properties");
            if (url != null) {
                try (InputStream stream = url.openStream();){
                    Properties properties = new Properties();
                    properties.load(stream);
                    version = properties.getProperty("version").trim();
                }
                catch (IOException ex) {
                    version = "(unknown)";
                }
            }
            String name = (String)MoreObjects.firstNonNull((Object)this.name, (Object)"Version");
            System.out.println(String.format("%s %s\nJava %s bit (%s) %s\n", name, version, System.getProperty("sun.arch.data.model"), System.getProperty("java.vendor"), System.getProperty("java.version")));
        }

        private void printHelp() {
            HelpFormatter formatter = new HelpFormatter();
            PrintWriter out = new PrintWriter(System.out);
            String name = (String)MoreObjects.firstNonNull((Object)this.name, (Object)"java");
            formatter.printUsage(out, 80, name, this.options);
            if (this.header != null) {
                out.println();
                formatter.printWrapped(out, 80, this.header);
            }
            out.println();
            formatter.printOptions(out, 80, this.options, 2, 2);
            if (this.footer != null) {
                out.println();
                out.println(this.footer);
            }
            out.flush();
        }
    }
}

