/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.IslamicHoliday;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IslamicHolidayParser
extends AbstractHolidayParser {
    private static final String PREFIX_PROPERTY_ISLAMIC = "islamic.";

    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (IslamicHoliday i : config.getIslamicHoliday()) {
            if (!this.isValid(i, year)) continue;
            Set<LocalDate> islamicHolidays = null;
            switch (i.getType()) {
                case NEWYEAR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 1, 1);
                    break;
                }
                case ASCHURA: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 1, 10);
                    break;
                }
                case ID_AL_FITR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 10, 1);
                    break;
                }
                case ID_UL_ADHA: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 12, 10);
                    break;
                }
                case LAILAT_AL_BARAT: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 8, 15);
                    break;
                }
                case LAILAT_AL_MIRAJ: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 7, 27);
                    break;
                }
                case LAILAT_AL_QADR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 9, 27);
                    break;
                }
                case MAWLID_AN_NABI: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 3, 12);
                    break;
                }
                case RAMADAN: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 9, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown islamic holiday " + (Object)((Object)i.getType()));
                }
            }
            String propertiesKey = PREFIX_PROPERTY_ISLAMIC + i.getType().name();
            HolidayType type = this.xmlUtil.getType(i.getLocalizedType());
            for (LocalDate d : islamicHolidays) {
                holidays.add(new Holiday(d, propertiesKey, type));
            }
        }
    }
}

