/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.it;

import com.google.common.collect.HashMultimap;
import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.DescriptionForm;
import eu.fbk.dh.tint.readability.GlossarioEntry;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.it.ItalianReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

public abstract class ItalianReadability
extends Readability {
    @JSONExclude
    ItalianReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;
    @JSONExclude
    StringBuilder lemmaBuffer = new StringBuilder();
    @JSONExclude
    StringBuilder tokenBuffer = new StringBuilder();
    @JSONExclude
    int lemmaIndex = 0;
    @JSONExclude
    HashMap<Integer, Integer> lemmaIndexes = new HashMap();
    @JSONExclude
    HashMap<Integer, Integer> tokenIndexes = new HashMap();

    @Override
    public void finalizeReadability() {
        super.finalizeReadability();
        double gulpease = 89.0 + (double)(300 * this.getSentenceCount() - 10 * this.getDocLenLettersOnly()) / ((double)this.getWordCount() * 1.0);
        this.labels.put("main", "Gulpease");
        this.measures.put("main", gulpease);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentEasyWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
        String lemmaText = this.lemmaBuffer.toString().trim().toLowerCase();
        String tokenText = this.tokenBuffer.toString().trim().toLowerCase();
        HashMap<String, GlossarioEntry> glossario = this.model.getGlossario();
        ArrayList<String> glossarioKeys = new ArrayList<String>(glossario.keySet());
        Collections.sort(glossarioKeys, new StringLenComparator());
        for (String form : glossarioKeys) {
            int numberOfTokens = form.split("\\s+").length;
            List<Integer> allOccurrences = ItalianReadability.findAllOccurrences(tokenText, form);
            List<Integer> allLemmaOccurrences = ItalianReadability.findAllOccurrences(lemmaText, form);
            for (Integer occurrence : allOccurrences) {
                ItalianReadability.addDescriptionForm(form, this.tokenIndexes, occurrence, numberOfTokens, this.forms, this.annotation, glossario);
            }
            for (Integer occurrence : allLemmaOccurrences) {
                ItalianReadability.addDescriptionForm(form, this.lemmaIndexes, occurrence, numberOfTokens, this.forms, this.annotation, glossario);
            }
        }
    }

    public ItalianReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("it", annotation, localProperties);
        this.hyphenator = new Hyphenator("it", "it", 1, 1);
        this.model = ItalianReadabilityModel.getInstance(globalProperties, localProperties);
        this.minYellowValues.put("propositionsAvg", 2.038);
        this.maxYellowValues.put("propositionsAvg", 2.699);
        this.minValues.put("propositionsAvg", 0.0);
        this.maxValues.put("propositionsAvg", 5.0);
        this.minYellowValues.put("wordsAvg", 9.845);
        this.maxYellowValues.put("wordsAvg", 10.153);
        this.minValues.put("wordsAvg", 0.0);
        this.maxValues.put("wordsAvg", 12.0);
        this.minYellowValues.put("subordinateRatio", 0.263);
        this.maxYellowValues.put("subordinateRatio", 0.325);
        this.minValues.put("subordinateRatio", 0.0);
        this.maxValues.put("subordinateRatio", 1.0);
        this.minYellowValues.put("deepAvg", 5.292);
        this.maxYellowValues.put("deepAvg", 6.532);
        this.minValues.put("deepAvg", 0.0);
        this.maxValues.put("deepAvg", 10.0);
        this.minYellowValues.put("ttrValue", 0.549);
        this.maxYellowValues.put("ttrValue", 0.719);
        this.minValues.put("ttrValue", 0.0);
        this.maxValues.put("ttrValue", 1.0);
        this.minYellowValues.put("density", 0.566);
        this.maxYellowValues.put("density", 0.566);
        this.minValues.put("density", 0.0);
        this.maxValues.put("density", 1.0);
    }

    public static List<Integer> findAllOccurrences(String haystack, String needle) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int index = haystack.indexOf(needle);
        while (index >= 0) {
            try {
                String afterChar = haystack.substring(index + needle.length(), index + needle.length());
                if (!afterChar.matches("\\w+")) {
                    ret.add(index);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            index = haystack.indexOf(needle, index + 1);
        }
        return ret;
    }

    public static void addDescriptionForm(String form, HashMap<Integer, Integer> indexes, int start, int numberOfTokens, TreeMap<Integer, DescriptionForm> forms, Annotation annotation, HashMap<String, GlossarioEntry> glossario) {
        Integer lemmaIndex = indexes.get(start);
        if (lemmaIndex == null) {
            return;
        }
        CoreLabel firstToken = (CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(lemmaIndex);
        CoreLabel endToken = (CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(lemmaIndex + numberOfTokens - 1);
        Integer beginOffset = (Integer)firstToken.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        Integer endOffset = (Integer)endToken.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        GlossarioEntry glossarioEntry = glossario.get(form);
        if (glossarioEntry == null) {
            return;
        }
        DescriptionForm descriptionForm = new DescriptionForm(beginOffset, endOffset, glossarioEntry);
        forms.put(beginOffset, descriptionForm);
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        super.addingContentWord(token);
        HashMap<Integer, HashMultimap<String, String>> easyWords = this.model.getEasyWords();
        String simplePos = this.getGenericPos((String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
        String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
        token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)4);
        if (easyWords.get(3).get((Object)simplePos).contains(lemma)) {
            ++this.level3WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)3);
        }
        if (easyWords.get(2).get((Object)simplePos).contains(lemma)) {
            ++this.level2WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)2);
        }
        if (easyWords.get(1).get((Object)simplePos).contains(lemma)) {
            ++this.level1WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)1);
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
        super.addingWord(token);
    }

    @Override
    public void addingToken(CoreLabel token) {
        this.lemmaIndexes.put(this.lemmaBuffer.length(), this.lemmaIndex);
        this.tokenIndexes.put((Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), this.lemmaIndex);
        ++this.lemmaIndex;
        this.lemmaBuffer.append((String)token.get(CoreAnnotations.LemmaAnnotation.class)).append(" ");
        this.tokenBuffer.append((String)token.get(CoreAnnotations.TextAnnotation.class)).append(" ");
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }

    public static class StringLenComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    }
}

