/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.gl;

import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.gl.GalicianReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.Properties;

abstract class GalicianReadability
extends Readability {
    @JSONExclude
    GalicianReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;

    public static void main(String[] args) {
        Hyphenator hyphenator = new Hyphenator("gl", "es", 1, 1);
        Hyphenation produci\u00f3n = hyphenator.hyphenate("produci\u00f3n");
        System.out.println(produci\u00f3n);
    }

    @Override
    public void finalizeReadability() {
        super.finalizeReadability();
        double fleschSzigriszt = 206.835 - 62.3 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 1.0 * (double)this.getWordCount() / (double)this.getSentenceCount();
        double fernandezHuerta = 206.84 - 0.6 * (100.0 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount()) - 1.02 * (100.0 * (double)this.getSentenceCount() / (double)this.getWordCount());
        this.labels.put("main", "Flesch-Szigriszt");
        this.measures.put("main", fleschSzigriszt);
        this.measures.put("fernandez-huerta", fernandezHuerta);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
    }

    public GalicianReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("gl", annotation, localProperties);
        this.hyphenator = new Hyphenator("es", "es", 1, 1);
        this.model = GalicianReadabilityModel.getInstance(globalProperties, localProperties);
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        super.addingContentWord(token);
        token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)4);
        String lemma = token.lemma();
        if (this.model.getLevel3Lemmas().contains(lemma)) {
            ++this.level3WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)3);
        }
        if (this.model.getLevel2Lemmas().contains(lemma)) {
            ++this.level2WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)2);
        }
        if (this.model.getLevel1Lemmas().contains(lemma)) {
            ++this.level1WordSize;
            token.set(ReadabilityAnnotations.DifficultyLevelAnnotation.class, (Object)1);
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
        super.addingWord(token);
    }

    @Override
    public void addingToken(CoreLabel token) {
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }
}

