/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.en;

import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.en.EnglishReadabilityModel;
import eu.fbk.utils.gson.JSONExclude;
import java.util.Properties;

abstract class EnglishReadability
extends Readability {
    @JSONExclude
    EnglishReadabilityModel model;
    @JSONExclude
    int level1WordSize = 0;
    @JSONExclude
    int level2WordSize = 0;
    @JSONExclude
    int level3WordSize = 0;

    @Override
    public void finalizeReadability() {
        super.finalizeReadability();
        double flesch = 206.835 - 84.6 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 1.015 * (double)this.getWordCount() / (double)this.getSentenceCount();
        double fleschKincaid = 0.39 * (double)this.getWordCount() / (double)this.getSentenceCount() + 11.8 * (double)this.getHyphenCount() / (double)this.getHyphenWordCount() - 15.59;
        this.labels.put("main", "Flesch");
        this.measures.put("main", flesch);
        this.measures.put("flesch-kincaid", fleschKincaid);
        this.measures.put("level1", 100.0 * (double)this.level1WordSize / (double)this.getContentWordSize());
        this.measures.put("level2", 100.0 * (double)this.level2WordSize / (double)this.getContentWordSize());
        this.measures.put("level3", 100.0 * (double)this.level3WordSize / (double)this.getContentWordSize());
    }

    public EnglishReadability(Properties globalProperties, Properties localProperties, Annotation annotation) {
        super("en", annotation, localProperties);
        this.hyphenator = new Hyphenator("en", "en", 1, 1);
        this.model = EnglishReadabilityModel.getInstance(globalProperties, localProperties);
        this.minYellowValues.put("deepAvg", 5.292);
        this.maxYellowValues.put("deepAvg", 6.532);
        this.minValues.put("deepAvg", 0.0);
        this.maxValues.put("deepAvg", 10.0);
        this.minYellowValues.put("deepMax", 9.0);
        this.maxYellowValues.put("deepMax", 12.0);
        this.minValues.put("deepMax", 0.0);
        this.maxValues.put("deepMax", 20.0);
        this.minYellowValues.put("ttrValue", 0.549);
        this.maxYellowValues.put("ttrValue", 0.719);
        this.minValues.put("ttrValue", 0.0);
        this.maxValues.put("ttrValue", 1.0);
        this.minYellowValues.put("density", 0.566);
        this.maxYellowValues.put("density", 0.566);
        this.minValues.put("density", 0.0);
        this.maxValues.put("density", 1.0);
    }

    @Override
    public void addingContentWord(CoreLabel token) {
        super.addingContentWord(token);
        String lemma = token.word();
        if (this.model.getLevel1Lemmas().contains(lemma)) {
            ++this.level1WordSize;
        }
        if (this.model.getLevel2Lemmas().contains(lemma)) {
            ++this.level2WordSize;
        }
        if (this.model.getLevel3Lemmas().contains(lemma)) {
            ++this.level3WordSize;
        }
    }

    @Override
    public void addingEasyWord(CoreLabel token) {
    }

    @Override
    public void addingWord(CoreLabel token) {
        super.addingWord(token);
    }

    @Override
    public void addingToken(CoreLabel token) {
    }

    @Override
    public void addingSentence(CoreMap sentence) {
    }
}

