/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import eu.fbk.dh.tint.verb.VerbMultiToken;
import eu.fbk.utils.core.FrequencyHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SemanticGraphUtils {
    public static void smartRemoveEdge(SemanticGraph semanticGraph, IndexedWord indexedWord) {
        Set parents = semanticGraph.getParents(indexedWord);
    }

    public static Integer getHead(VerbMultiToken verb, SemanticGraph semanticGraph) {
        FrequencyHashSet frequencies = new FrequencyHashSet();
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (CoreLabel token : verb.getTokens()) {
            int index = token.index();
            indexes.add(index);
            try {
                IndexedWord node = semanticGraph.getNodeByIndex(index);
                frequencies.add((Object)index);
                List pathToRoot = semanticGraph.getPathToRoot(node);
                for (IndexedWord indexedWord : pathToRoot) {
                    frequencies.add((Object)indexedWord.index());
                }
            }
            catch (Exception exception) {
            }
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        for (Integer key : frequencies.keySet()) {
            keys.add(key);
        }
        for (Integer index : keys) {
            if (indexes.contains(index)) continue;
            frequencies.remove((Object)index);
        }
        return (Integer)frequencies.mostFrequent();
    }

    public static Map<Integer, String> getParent(VerbMultiToken verb, SemanticGraph semanticGraph) {
        HashMap<Integer, String> parents = new HashMap<Integer, String>();
        HashSet<Integer> removeIndexes = new HashSet<Integer>();
        for (CoreLabel token : verb.getTokens()) {
            int index = token.index();
            removeIndexes.add(index);
            try {
                IndexedWord node = semanticGraph.getNodeByIndex(index);
                List incomingEdgesSorted = semanticGraph.getIncomingEdgesSorted(node);
                for (SemanticGraphEdge edge : incomingEdgesSorted) {
                    int parentIndex = edge.getGovernor().index();
                    parents.put(parentIndex, edge.getRelation().getShortName());
                }
            }
            catch (Exception exception) {
            }
        }
        for (Integer removeIndex : removeIndexes) {
            parents.remove(removeIndex);
        }
        return parents;
    }
}

