/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DistinctIterator<T>
implements Iterator<T> {
    private static final Object NULL = new Object();
    private final Iterator<T> iterator;
    private final MutableSet<T> seenSoFar = UnifiedSet.newSet();
    private Object next = NULL;

    public DistinctIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public DistinctIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a distinct iterator");
    }

    @Override
    public boolean hasNext() {
        if (this.next != NULL) {
            return true;
        }
        while (this.iterator.hasNext()) {
            T temp = this.iterator.next();
            if (!this.seenSoFar.add(temp)) continue;
            this.next = temp;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.next != NULL || this.hasNext()) {
            Object temp = this.next;
            this.next = NULL;
            return (T)temp;
        }
        throw new NoSuchElementException();
    }
}

