/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.time.GenericTimeExpressionPatterns;
import edu.stanford.nlp.time.JodaTimeUtils;
import edu.stanford.nlp.time.Options;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.time.TimeExpressionExtractor;
import edu.stanford.nlp.time.TimeExpressionPatterns;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.joda.time.ReadablePartial;

public class TimeExpressionExtractorImpl
implements TimeExpressionExtractor {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(TimeExpressionExtractorImpl.class);
    private TimeExpressionPatterns timexPatterns;
    private CoreMapExpressionExtractor expressionExtractor;
    private Options options;

    public TimeExpressionExtractorImpl() {
        this.init(new Options());
    }

    public TimeExpressionExtractorImpl(String name, Properties props) {
        this.init(name, props);
    }

    @Override
    public void init(String name, Properties props) {
        this.init(new Options(name, props));
    }

    @Override
    public void init(Options options) {
        this.options = options;
        CoreMapExpressionExtractor.setVerbose(options.verbose);
        if (options.grammarFilename == null) {
            options.grammarFilename = "edu/stanford/nlp/models/sutime/defs.sutime.txt,edu/stanford/nlp/models/sutime/english.sutime.txt,edu/stanford/nlp/models/sutime/english.holidays.sutime.txt";
            logger.warning("Time rules file is not specified: using default rules at " + options.grammarFilename);
        }
        this.timexPatterns = new GenericTimeExpressionPatterns(options);
        this.expressionExtractor = this.timexPatterns.createExtractor();
    }

    @Override
    public List<CoreMap> extractTimeExpressionCoreMaps(CoreMap annotation, CoreMap docAnnotation) {
        String sectionDate;
        SUTime.TimeIndex timeIndex;
        String docDate = null;
        if (docAnnotation != null) {
            timeIndex = (SUTime.TimeIndex)docAnnotation.get(TimeExpression.TimeIndexAnnotation.class);
            if (timeIndex == null) {
                timeIndex = new SUTime.TimeIndex();
                docAnnotation.set(TimeExpression.TimeIndexAnnotation.class, timeIndex);
            }
            if ((docDate = annotation.get(CoreAnnotations.SectionDateAnnotation.class) != null ? (String)annotation.get(CoreAnnotations.SectionDateAnnotation.class) : (String)docAnnotation.get(CoreAnnotations.DocDateAnnotation.class)) == null) {
                Calendar cal = (Calendar)docAnnotation.get(CoreAnnotations.CalendarAnnotation.class);
                if (cal == null) {
                    if (this.options.verbose) {
                        logger.warn("WARNING: No document date specified");
                    }
                } else {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd:hh:mm:ss");
                    docDate = dateFormat.format(cal.getTime());
                }
            }
        } else {
            timeIndex = new SUTime.TimeIndex();
        }
        if (StringUtils.isNullOrEmpty(docDate)) {
            docDate = null;
        }
        if (timeIndex.docDate == null && docDate != null) {
            try {
                timeIndex.docDate = SUTime.parseDateTime(docDate, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse date string: [" + docDate + "]", e);
            }
        }
        String refDate = (sectionDate = (String)annotation.get(CoreAnnotations.SectionDateAnnotation.class)) != null ? sectionDate : docDate;
        return this.extractTimeExpressionCoreMaps(annotation, refDate, timeIndex);
    }

    @Override
    public List<CoreMap> extractTimeExpressionCoreMaps(CoreMap annotation, String docDate) {
        SUTime.TimeIndex timeIndex = new SUTime.TimeIndex();
        return this.extractTimeExpressionCoreMaps(annotation, docDate, timeIndex);
    }

    public List<CoreMap> extractTimeExpressionCoreMaps(CoreMap annotation, String docDate, SUTime.TimeIndex timeIndex) {
        List<TimeExpression> timeExpressions = this.extractTimeExpressions(annotation, docDate, timeIndex);
        return this.toCoreMaps(annotation, timeExpressions, timeIndex);
    }

    @Override
    public void finalize(CoreMap docAnnotation) {
        docAnnotation.remove(TimeExpression.TimeIndexAnnotation.class);
    }

    private List<CoreMap> toCoreMaps(CoreMap annotation, List<TimeExpression> timeExpressions, SUTime.TimeIndex timeIndex) {
        if (timeExpressions == null) {
            return null;
        }
        ArrayList<CoreMap> coreMaps = new ArrayList<CoreMap>(timeExpressions.size());
        for (TimeExpression te : timeExpressions) {
            Timex timex;
            Map<String, String> timexAttributes;
            String text;
            CoreMap cm;
            block8: {
                cm = te.getAnnotation();
                SUTime.Temporal temporal = te.getTemporal();
                if (temporal == null) continue;
                String origText = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
                text = (String)cm.get(CoreAnnotations.TextAnnotation.class);
                if (origText != null) {
                    ChunkAnnotationUtils.annotateChunkText(cm, annotation);
                    text = (String)cm.get(CoreAnnotations.TextAnnotation.class);
                }
                try {
                    SUTime.Range rangeTemporal;
                    timexAttributes = temporal.getTimexAttributes(timeIndex);
                    if (!this.options.includeRange || (rangeTemporal = temporal.getRange()) == null) break block8;
                    timexAttributes.put("range", rangeTemporal.toString());
                }
                catch (Exception e) {
                    if (!this.options.verbose) continue;
                    logger.warn("Failed to get attributes from " + text + ", timeIndex " + timeIndex);
                    logger.warn(e);
                    continue;
                }
            }
            try {
                timex = Timex.fromMap(text, timexAttributes);
            }
            catch (Exception e) {
                if (!this.options.verbose) continue;
                logger.warn("Failed to process timex " + text + " with attributes " + timexAttributes);
                logger.warn(e);
                continue;
            }
            assert (timex != null);
            cm.set(TimeAnnotations.TimexAnnotation.class, timex);
            coreMaps.add(cm);
        }
        return coreMaps;
    }

    public List<TimeExpression> extractTimeExpressions(CoreMap annotation, String refDateStr, SUTime.TimeIndex timeIndex) {
        SUTime.Time refDate = null;
        if (refDateStr != null) {
            try {
                refDate = SUTime.parseDateTime(refDateStr, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse date string: [" + refDateStr + "]", e);
            }
        }
        return this.extractTimeExpressions(annotation, refDate, timeIndex);
    }

    public List<TimeExpression> extractTimeExpressions(CoreMap annotation, SUTime.Time refDate, SUTime.TimeIndex timeIndex) {
        TimeExpression childTe;
        List children;
        if (!annotation.containsKey(CoreAnnotations.NumerizedTokensAnnotation.class)) {
            try {
                List<CoreMap> mergedNumbers = NumberNormalizer.findAndMergeNumbers(annotation);
                annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbers);
            }
            catch (NumberFormatException e) {
                logger.warn("Caught bad number: " + e.getMessage());
                annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, new ArrayList());
            }
        }
        List matchedExpressions = this.expressionExtractor.extractExpressions(annotation);
        ArrayList<TimeExpression> timeExpressions = new ArrayList<TimeExpression>(matchedExpressions.size());
        for (MatchedExpression expr : matchedExpressions) {
            TimeExpression annoTe = (TimeExpression)expr.getAnnotation().get(TimeExpression.Annotation.class);
            if (annoTe == null) continue;
            timeExpressions.add(annoTe);
        }
        if (timeIndex.docDate == null) {
            if (refDate != null) {
                timeIndex.docDate = refDate;
            } else if (this.options.searchForDocDate) {
                timeIndex.docDate = TimeExpressionExtractorImpl.findReferenceDate(timeExpressions);
            }
        }
        if (refDate == null) {
            refDate = timeIndex.docDate;
        }
        this.resolveTimeExpressions(annotation, timeExpressions, refDate);
        if (this.options.restrictToTimex3) {
            ArrayList<TimeExpression> kept = new ArrayList<TimeExpression>(timeExpressions.size());
            for (TimeExpression te : timeExpressions) {
                if (te.getTemporal() != null && te.getTemporal().getTimexValue() != null) {
                    kept.add(te);
                    continue;
                }
                children = (List)te.getAnnotation().get(TimeExpression.ChildrenAnnotation.class);
                if (children == null) continue;
                for (CoreMap child : children) {
                    childTe = (TimeExpression)child.get(TimeExpression.Annotation.class);
                    if (childTe == null) continue;
                    this.resolveTimeExpression(annotation, childTe, refDate);
                    if (childTe.getTemporal() == null || childTe.getTemporal().getTimexValue() == null) continue;
                    kept.add(childTe);
                }
            }
            timeExpressions = kept;
        }
        if (this.options.includeNested) {
            ArrayList<TimeExpression> nestedTimeExpressions = new ArrayList<TimeExpression>();
            for (TimeExpression te : timeExpressions) {
                if (!te.isIncludeNested() || (children = (List)te.getAnnotation().get(TimeExpression.ChildrenAnnotation.class)) == null) continue;
                for (CoreMap child : children) {
                    childTe = (TimeExpression)child.get(TimeExpression.Annotation.class);
                    if (childTe == null) continue;
                    nestedTimeExpressions.add(childTe);
                }
            }
            this.resolveTimeExpressions(annotation, nestedTimeExpressions, refDate);
            timeExpressions.addAll(nestedTimeExpressions);
        }
        Collections.sort(timeExpressions, MatchedExpression.EXPR_TOKEN_OFFSETS_NESTED_FIRST_COMPARATOR);
        this.resolveTimeExpressions(annotation, timeExpressions, refDate);
        return timeExpressions;
    }

    private void resolveTimeExpression(CoreMap annotation, TimeExpression te, SUTime.Time docDate) {
        block5: {
            SUTime.Temporal temporal = te.getTemporal();
            if (temporal != null) {
                try {
                    int flags = this.timexPatterns.determineRelFlags(annotation, te);
                    SUTime.Temporal grounded = temporal.resolve(docDate, flags);
                    if (grounded == null) {
                        logger.debug("Error resolving " + temporal + ", using docDate=" + docDate);
                    }
                    if (grounded != temporal) {
                        te.origTemporal = temporal;
                        te.setTemporal(grounded);
                    }
                }
                catch (Exception ex) {
                    if (!this.options.verbose) break block5;
                    logger.warn("Error resolving " + temporal, ex);
                    logger.warn(ex);
                }
            }
        }
    }

    private void resolveTimeExpressions(CoreMap annotation, List<TimeExpression> timeExpressions, SUTime.Time docDate) {
        for (TimeExpression te : timeExpressions) {
            this.resolveTimeExpression(annotation, te, docDate);
        }
    }

    private static SUTime.Time findReferenceDate(List<TimeExpression> timeExpressions) {
        for (TimeExpression te : timeExpressions) {
            SUTime.Temporal t = te.getTemporal();
            if (!(t instanceof SUTime.Time)) continue;
            if (t.isGrounded()) {
                return t.getTime();
            }
            if (!(t instanceof SUTime.PartialTime)) continue;
            if (JodaTimeUtils.hasYYYYMMDD((ReadablePartial)t.getTime().getJodaTimePartial())) {
                return t.getTime();
            }
            if (!JodaTimeUtils.hasYYMMDD((ReadablePartial)t.getTime().getJodaTimePartial())) continue;
            return t.getTime().resolve(SUTime.getCurrentTime()).getTime();
        }
        return null;
    }
}

