/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.ComplexNodePattern;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.ling.tokensregex.matcher.TrieMap;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class TokensRegexNERAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(TokensRegexNERAnnotator.class);
    protected static final Redwood.RedwoodChannels logger = Redwood.channels("TokenRegexNER");
    protected static final String PATTERN_FIELD = "pattern";
    protected static final String OVERWRITE_FIELD = "overwrite";
    protected static final String PRIORITY_FIELD = "priority";
    protected static final String WEIGHT_FIELD = "weight";
    protected static final String GROUP_FIELD = "group";
    protected static final Set<String> predefinedHeaderFields = CollectionUtils.asSet("pattern", "overwrite", "priority", "weight", "group");
    protected static final String defaultHeader = "pattern,ner,overwrite,priority,group";
    private final boolean ignoreCase;
    private final List<Boolean> ignoreCaseList;
    private final Set<String> commonWords;
    private final List<Entry> entries;
    private final Map<SequencePattern<CoreMap>, Entry> patternToEntry;
    private final MultiPatternMatcher<CoreMap> multiPatternMatcher;
    private final List<Class> annotationFields;
    private final Set<String> myLabels;
    private final Pattern validPosPattern;
    private final List<Pattern> validPosPatternList;
    private final boolean verbose;
    private final Map<Entry, Integer> entryToMappingFileNumber;
    private final Set<String> noDefaultOverwriteLabels;
    private final PosMatchType posMatchType;
    public static final PosMatchType DEFAULT_POS_MATCH_TYPE = PosMatchType.MATCH_AT_LEAST_ONE_TOKEN;
    public static final String DEFAULT_BACKGROUND_SYMBOL = "O,MISC";
    public static PropertiesUtils.Property[] SUPPORTED_PROPERTIES = new PropertiesUtils.Property[]{new PropertiesUtils.Property("mapping", "edu/stanford/nlp/models/regexner/type_map_clean", "List of mapping files to use, separated by commas or semi-colons."), new PropertiesUtils.Property("mapping.header", "pattern,ner,overwrite,priority,group", "Comma separated list specifying order of fields in the mapping file"), new PropertiesUtils.Property("mapping.field.<fieldname>", "", "Class mapping for annotation fields other than ner"), new PropertiesUtils.Property("commonWords", "", "Comma separated list of files for common words to not annotate (in case your mapping isn't very clean)"), new PropertiesUtils.Property("ignorecase", "false", "Whether to ignore case or not when matching patterns."), new PropertiesUtils.Property("validpospattern", "", "Regular expression pattern for matching POS tags."), new PropertiesUtils.Property("posmatchtype", DEFAULT_POS_MATCH_TYPE.name(), "How should 'validpospattern' be used to match the POS of the tokens."), new PropertiesUtils.Property("noDefaultOverwriteLabels", "", "Comma separated list of output types for which default NER labels are not overwritten.\n For these types, only if the matched expression has NER type matching the\n specified overwriteableType for the regex will the NER type be overwritten."), new PropertiesUtils.Property("backgroundSymbol", "O,MISC", "Comma separated list of NER labels to always replace."), new PropertiesUtils.Property("verbose", "false", "")};
    private static final Pattern FILE_DELIMITERS_PATTERN = Pattern.compile("\\s*[,;]\\s*");
    private static final Pattern COMMA_DELIMITERS_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Pattern SEMICOLON_DELIMITERS_PATTERN = Pattern.compile("\\s*;\\s*");
    private static final Pattern EQUALS_DELIMITERS_PATTERN = Pattern.compile("\\s*=\\s*");

    public TokensRegexNERAnnotator(String mapping) {
        this(mapping, false);
    }

    public TokensRegexNERAnnotator(String mapping, boolean ignoreCase) {
        this(mapping, ignoreCase, null);
    }

    public TokensRegexNERAnnotator(String mapping, boolean ignoreCase, String validPosRegex) {
        this("tokenregexner", TokensRegexNERAnnotator.getProperties("tokenregexner", mapping, ignoreCase, validPosRegex));
    }

    private static Properties getProperties(String name, String mapping, boolean ignoreCase, String validPosRegex) {
        String prefix = name != null && !name.isEmpty() ? name + "." : "";
        Properties props = new Properties();
        props.setProperty(prefix + "mapping", mapping);
        props.setProperty(prefix + "ignorecase", String.valueOf(ignoreCase));
        if (validPosRegex != null) {
            props.setProperty(prefix + "validpospattern", validPosRegex);
        }
        return props;
    }

    public TokensRegexNERAnnotator(String name, Properties properties) {
        String prefix = name != null && !name.isEmpty() ? name + "." : "";
        String backgroundSymbol = properties.getProperty(prefix + "backgroundSymbol", DEFAULT_BACKGROUND_SYMBOL);
        String[] backgroundSymbols = COMMA_DELIMITERS_PATTERN.split(backgroundSymbol);
        String mappingFiles = properties.getProperty(prefix + "mapping", "ignorecase=true,validpospattern=^(NN|JJ).*,edu/stanford/nlp/models/kbp/regexner_caseless.tab;edu/stanford/nlp/models/kbp/regexner_cased.tab");
        String[] mappings = TokensRegexNERAnnotator.processListMappingFiles(mappingFiles);
        String validPosRegex = properties.getProperty(prefix + "validpospattern");
        this.posMatchType = PosMatchType.valueOf(properties.getProperty(prefix + "posmatchtype", DEFAULT_POS_MATCH_TYPE.name()));
        String commonWordsFile = properties.getProperty(prefix + "commonWords");
        this.commonWords = new HashSet<String>();
        if (commonWordsFile != null) {
            try {
                String line;
                BufferedReader reader = IOUtils.getBufferedFileReader(commonWordsFile);
                while ((line = reader.readLine()) != null) {
                    this.commonWords.add(line);
                }
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("TokensRegexNERAnnotator " + name + ": Error opening the common words file: " + commonWordsFile, ex);
            }
        }
        String headerProp = properties.getProperty(prefix + "mapping.header", defaultHeader);
        boolean readHeaderFromFile = headerProp.equalsIgnoreCase("true");
        String[] annotationFieldnames = null;
        String[] headerFields = null;
        if (readHeaderFromFile) {
            throw new UnsupportedOperationException("Reading header from file not yet supported!!!");
        }
        headerFields = COMMA_DELIMITERS_PATTERN.split(headerProp);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Class> fieldClasses = new ArrayList<Class>();
        for (String field : headerFields) {
            if (predefinedHeaderFields.contains(field)) continue;
            Class fieldClass = EnvLookup.lookupAnnotationKeyWithClassname(null, field);
            if (fieldClass == null) {
                String classname = properties.getProperty(prefix + "mapping.field." + field);
                fieldClass = EnvLookup.lookupAnnotationKeyWithClassname(null, classname);
            }
            if (fieldClass != null) {
                fieldNames.add(field);
                fieldClasses.add(fieldClass);
                continue;
            }
            logger.warn("TokensRegexNERAnnotator " + name + ": Unknown field: " + field + " cannot find suitable annotation class");
        }
        annotationFieldnames = new String[fieldNames.size()];
        fieldNames.toArray(annotationFieldnames);
        this.annotationFields = fieldClasses;
        String noDefaultOverwriteLabelsProp = properties.getProperty(prefix + "noDefaultOverwriteLabels", "CITY");
        this.noDefaultOverwriteLabels = Collections.unmodifiableSet(CollectionUtils.asSet(noDefaultOverwriteLabelsProp.split("\\s*,\\s*")));
        this.ignoreCase = PropertiesUtils.getBool(properties, prefix + "ignorecase", false);
        this.verbose = PropertiesUtils.getBool(properties, prefix + "verbose", false);
        this.validPosPattern = validPosRegex != null && !validPosRegex.equals("") ? Pattern.compile(validPosRegex) : null;
        this.validPosPatternList = new ArrayList<Pattern>();
        this.ignoreCaseList = new ArrayList<Boolean>();
        this.entryToMappingFileNumber = new HashMap<Entry, Integer>();
        TokensRegexNERAnnotator.processPerFileOptions(name, mappings, this.ignoreCaseList, this.validPosPatternList, this.ignoreCase, this.validPosPattern);
        this.entries = Collections.unmodifiableList(TokensRegexNERAnnotator.readEntries(name, this.noDefaultOverwriteLabels, this.ignoreCaseList, this.entryToMappingFileNumber, this.verbose, headerFields, annotationFieldnames, mappings));
        IdentityHashMap<SequencePattern<CoreMap>, Entry> patternToEntry = new IdentityHashMap<SequencePattern<CoreMap>, Entry>();
        this.multiPatternMatcher = this.createPatternMatcher(patternToEntry);
        this.patternToEntry = Collections.unmodifiableMap(patternToEntry);
        Set<Object> myLabels = Generics.newHashSet();
        Collections.addAll(myLabels, backgroundSymbols);
        myLabels.add(null);
        for (Entry entry : this.entries) {
            Collections.addAll(myLabels, entry.types);
        }
        this.myLabels = Collections.unmodifiableSet(myLabels);
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences;
        if (this.verbose) {
            log.info("Adding TokensRegexNER annotations ... ");
        }
        if ((sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) != null) {
            for (CoreMap sentence : sentences) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                this.annotateMatched(tokens);
            }
        } else {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            if (tokens != null) {
                this.annotateMatched(tokens);
            } else {
                throw new RuntimeException("Unable to find sentences or tokens in " + annotation);
            }
        }
        if (this.verbose) {
            log.info("done.");
        }
    }

    private MultiPatternMatcher<CoreMap> createPatternMatcher(Map<SequencePattern<CoreMap>, Entry> patternToEntry) {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>(this.entries.size());
        for (Entry entry : this.entries) {
            TokenSequencePattern pattern;
            ComplexNodePattern.StringAnnotationRegexPattern posTagPattern;
            Boolean ignoreCaseEntry = this.ignoreCaseList.get(this.entryToMappingFileNumber.get(entry));
            int patternFlags = ignoreCaseEntry != false ? 2 : 0;
            int stringMatchFlags = ignoreCaseEntry != false ? 2 : 0;
            Env env = TokenSequencePattern.getNewEnv();
            env.setDefaultStringPatternFlags(patternFlags);
            env.setDefaultStringMatchFlags(stringMatchFlags);
            ComplexNodePattern.StringAnnotationRegexPattern stringAnnotationRegexPattern = posTagPattern = this.validPosPatternList.get(this.entryToMappingFileNumber.get(entry)) != null && PosMatchType.MATCH_ALL_TOKENS.equals((Object)this.posMatchType) ? new ComplexNodePattern.StringAnnotationRegexPattern(this.validPosPatternList.get(this.entryToMappingFileNumber.get(entry))) : null;
            if (entry.tokensRegex != null) {
                pattern = TokenSequencePattern.compile(env, entry.tokensRegex);
            } else {
                ArrayList<SequencePattern.PatternExpr> nodePatterns = new ArrayList<SequencePattern.PatternExpr>();
                for (String p : entry.regex) {
                    CoreMapNodePattern c = CoreMapNodePattern.valueOf(p, patternFlags);
                    if (posTagPattern != null) {
                        c.add(CoreAnnotations.PartOfSpeechAnnotation.class, posTagPattern);
                    }
                    nodePatterns.add(new SequencePattern.NodePatternExpr(c));
                }
                pattern = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(nodePatterns));
            }
            if (entry.annotateGroup < 0 || entry.annotateGroup > pattern.getTotalGroups()) {
                throw new RuntimeException("Invalid match group for entry " + entry);
            }
            pattern.setPriority(entry.priority);
            pattern.setWeight(entry.weight);
            patterns.add(pattern);
            patternToEntry.put(pattern, entry);
        }
        return TokenSequencePattern.getMultiPatternMatcher(patterns);
    }

    private void annotateMatched(List<CoreLabel> tokens) {
        List<SequenceMatchResult<CoreLabel>> matched = this.multiPatternMatcher.findNonOverlapping(tokens);
        for (SequenceMatchResult<CoreLabel> m : matched) {
            Entry entry = this.patternToEntry.get(m.pattern());
            int g = entry.annotateGroup;
            int start = m.start(g);
            int end = m.end(g);
            String str = m.group(g);
            if (this.commonWords.contains(str)) {
                if (!this.verbose) continue;
                log.info("Not annotating (common word) '" + str + "': " + StringUtils.joinFields(m.groupNodes(g), CoreAnnotations.NamedEntityTagAnnotation.class) + " with " + entry.getTypeDescription() + ", sentence is '" + StringUtils.joinWords(tokens, " ") + "'");
                continue;
            }
            boolean overwriteOriginalNer = this.checkPosTags(tokens, start, end);
            if (overwriteOriginalNer) {
                overwriteOriginalNer = this.checkOrigNerTags(entry, tokens, start, end);
            }
            if (overwriteOriginalNer) {
                for (int i = start; i < end; ++i) {
                    CoreLabel token = tokens.get(i);
                    for (int j = 0; j < this.annotationFields.size(); ++j) {
                        token.set(this.annotationFields.get(j), entry.types[j]);
                    }
                }
                continue;
            }
            if (!this.verbose) continue;
            log.info("Not annotating  '" + m.group(g) + "': " + StringUtils.joinFields(m.groupNodes(g), CoreAnnotations.NamedEntityTagAnnotation.class) + " with " + entry.getTypeDescription() + ", sentence is '" + StringUtils.joinWords(tokens, " ") + "'");
        }
    }

    private boolean checkPosTags(List<CoreLabel> tokens, int start, int end) {
        if (this.validPosPattern != null || TokensRegexNERAnnotator.atLeastOneValidPosPattern(this.validPosPatternList)) {
            switch (this.posMatchType) {
                case MATCH_ONE_TOKEN_PHRASE_ONLY: {
                    if (tokens.size() > 1) {
                        return true;
                    }
                }
                case MATCH_AT_LEAST_ONE_TOKEN: {
                    for (int i = start; i < end; ++i) {
                        CoreLabel token = tokens.get(i);
                        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                        if (pos != null && this.validPosPattern != null && this.validPosPattern.matcher(pos).matches()) {
                            return true;
                        }
                        if (pos == null) continue;
                        for (Pattern pattern : this.validPosPatternList) {
                            if (pattern == null || !pattern.matcher(pos).matches()) continue;
                            return true;
                        }
                    }
                    return false;
                }
                case MATCH_ALL_TOKENS: {
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    private static boolean isLocationOrGpe(CoreLabel token) {
        return "LOCATION".equals(token.ner()) || "GPE".equals(token.ner());
    }

    private boolean checkOrigNerTags(Entry entry, List<CoreLabel> tokens, int start, int end) {
        String ner;
        int prevNerEndIndex;
        boolean specialCasePass = true;
        for (int i = start; i < end; ++i) {
            if (TokensRegexNERAnnotator.isLocationOrGpe(tokens.get(i))) continue;
            specialCasePass = false;
            break;
        }
        if (specialCasePass) {
            return true;
        }
        int nextNerStartIndex = end;
        String startNer = tokens.get(start).ner();
        String endNer = tokens.get(end - 1).ner();
        if (startNer != null && !this.myLabels.contains(startNer)) {
            for (prevNerEndIndex = start - 1; prevNerEndIndex >= 0 && (ner = tokens.get(prevNerEndIndex).ner()) != null && ner.equals(startNer); --prevNerEndIndex) {
            }
        }
        if (endNer != null && !this.myLabels.contains(endNer)) {
            while (nextNerStartIndex < tokens.size() && (ner = tokens.get(nextNerStartIndex).ner()) != null && ner.equals(endNer)) {
                ++nextNerStartIndex;
            }
        }
        boolean overwriteOriginalNer = false;
        if (prevNerEndIndex == start - 1 && nextNerStartIndex == end) {
            if (startNer == null) {
                overwriteOriginalNer = true;
            } else {
                for (int i = start + 1; i < end; ++i) {
                    if (startNer.equals(tokens.get(i).ner())) continue;
                    overwriteOriginalNer = true;
                    break;
                }
                if (!overwriteOriginalNer) {
                    if (entry.overwritableTypes.contains(startNer)) {
                        overwriteOriginalNer = true;
                    } else if (!TokensRegexNERAnnotator.hasNoOverwritableType(this.noDefaultOverwriteLabels, entry.types)) {
                        overwriteOriginalNer = this.myLabels.contains(startNer);
                    }
                }
            }
        }
        return overwriteOriginalNer;
    }

    private static List<Entry> readEntries(String annotatorName, Set<String> noDefaultOverwriteLabels, List<Boolean> ignoreCaseList, Map<Entry, Integer> entryToMappingFileNumber, boolean verbose, String[] headerFields, String[] annotationFieldnames, String ... mappings) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        TrieMap<String, Entry> seenRegexes = new TrieMap<String, Entry>();
        for (int mappingFileIndex = 0; mappingFileIndex < mappings.length; ++mappingFileIndex) {
            String mapping = mappings[mappingFileIndex];
            BufferedReader rd = null;
            try {
                rd = IOUtils.readerFromString(mapping);
                TokensRegexNERAnnotator.readEntries(annotatorName, headerFields, annotationFieldnames, entries, seenRegexes, mapping, rd, noDefaultOverwriteLabels, ignoreCaseList.get(mappingFileIndex), mappingFileIndex, entryToMappingFileNumber, verbose);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeIOException("Couldn't read TokensRegexNER from " + mapping, e);
            }
            finally {
                IOUtils.closeIgnoringExceptions(rd);
            }
        }
        if (mappings.length != 1) {
            logger.log("TokensRegexNERAnnotator " + annotatorName + ": Read " + entries.size() + " unique entries from " + mappings.length + " files");
        }
        return entries;
    }

    private static Map<String, Integer> getHeaderIndexMap(String[] headerFields) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < headerFields.length; ++i) {
            String field = headerFields[i];
            if (map.containsKey(field)) {
                throw new IllegalArgumentException("Duplicate header field: " + field);
            }
            map.put(field, i);
        }
        return map;
    }

    private static int getIndex(Map<String, Integer> map, String name) {
        Integer index = map.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    private static List<Entry> readEntries(String annotatorName, String[] headerFields, String[] annotationFieldnames, List<Entry> entries, TrieMap<String, Entry> seenRegexes, String mappingFilename, BufferedReader mapping, Set<String> noDefaultOverwriteLabels, boolean ignoreCase, Integer mappingFileIndex, Map<Entry, Integer> entryToMappingFileNumber, boolean verbose) throws IOException {
        String line;
        int origEntriesSize = entries.size();
        int isTokensRegex = 0;
        int lineCount = 0;
        Map<String, Integer> headerIndexMap = TokensRegexNERAnnotator.getHeaderIndexMap(headerFields);
        int iPattern = TokensRegexNERAnnotator.getIndex(headerIndexMap, PATTERN_FIELD);
        if (iPattern < 0) {
            throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Header does not contain 'pattern': " + StringUtils.join(headerFields));
        }
        int iOverwrite = TokensRegexNERAnnotator.getIndex(headerIndexMap, OVERWRITE_FIELD);
        int iPriority = TokensRegexNERAnnotator.getIndex(headerIndexMap, PRIORITY_FIELD);
        int iWeight = TokensRegexNERAnnotator.getIndex(headerIndexMap, WEIGHT_FIELD);
        int iGroup = TokensRegexNERAnnotator.getIndex(headerIndexMap, GROUP_FIELD);
        int[] annotationCols = new int[annotationFieldnames.length];
        int iLastAnnotationField = -1;
        for (int i = 0; i < annotationFieldnames.length; ++i) {
            annotationCols[i] = TokensRegexNERAnnotator.getIndex(headerIndexMap, annotationFieldnames[i]);
            if (annotationCols[i] < 0) {
                throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Header does not contain annotation field '" + annotationFieldnames[i] + "': " + StringUtils.join(headerFields));
            }
            if (annotationCols[i] <= iLastAnnotationField) continue;
            iLastAnnotationField = annotationCols[i];
        }
        int minLength = Math.max(iPattern, iLastAnnotationField) + 1;
        int maxLength = headerFields.length;
        while ((line = mapping.readLine()) != null) {
            int i;
            String[] stringArray;
            ++lineCount;
            String[] split = line.split("\t");
            if (split.length < minLength || split.length > maxLength) {
                String err2 = "many";
                if (split.length < minLength) {
                    err2 = "few";
                }
                throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Line " + lineCount + " of provided mapping file has too " + err2 + " tab-separated columns. Line: " + line);
            }
            String regex = split[iPattern].trim();
            String tokensRegex = null;
            String[] regexes = null;
            if (regex.startsWith("( ") && regex.endsWith(" )")) {
                tokensRegex = regex.substring(1, regex.length() - 1).trim();
            } else {
                regexes = regex.split("\\s+");
            }
            if (regexes != null) {
                stringArray = regexes;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = tokensRegex;
            }
            String[] key = stringArray;
            if (ignoreCase) {
                String[] norm = new String[key.length];
                for (i = 0; i < key.length; ++i) {
                    norm[i] = key[i].toLowerCase();
                }
                key = norm;
            }
            String[] types = new String[annotationCols.length];
            for (i = 0; i < annotationCols.length; ++i) {
                types[i] = split[annotationCols[i]].trim();
            }
            Set<String> overwritableTypes = Generics.newHashSet();
            double priority = 0.0;
            if (iOverwrite >= 0 && split.length > iOverwrite) {
                overwritableTypes.addAll(Arrays.asList(split[iOverwrite].trim().split("\\s*,\\s*")));
            }
            if (iPriority >= 0 && split.length > iPriority) {
                try {
                    priority = Double.parseDouble(split[iPriority].trim());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Invalid priority in line " + lineCount + " in regexner file " + mappingFilename + ": \"" + line + "\"!", e);
                }
            }
            double weight = 0.0;
            if (iWeight >= 0 && split.length > iWeight) {
                try {
                    weight = Double.parseDouble(split[iWeight].trim());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Invalid weight in line " + lineCount + " in regexner file " + mappingFilename + ": \"" + line + "\"!", e);
                }
            }
            int annotateGroup = 0;
            if (iGroup >= 0 && split.length > iGroup) {
                String context = split[iGroup].trim();
                try {
                    annotateGroup = Integer.parseInt(context);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Invalid group in line " + lineCount + " in regexner file " + mappingFilename + ": \"" + line + "\"!", e);
                }
            }
            for (int i2 = 0; i2 < types.length; ++i2) {
                String type = types[i2];
                int commaPos = type.indexOf(44);
                if (commaPos <= 0) continue;
                String newType = type.substring(0, commaPos).trim();
                logger.warn("TokensRegexNERAnnotator " + annotatorName + ": Entry has multiple types for " + annotationFieldnames[i2] + ": " + line + ".  Taking type to be " + newType);
                types[i2] = newType;
            }
            Entry entry = new Entry(tokensRegex, regexes, types, overwritableTypes, priority, weight, annotateGroup);
            if (seenRegexes.containsKey(key)) {
                Entry oldEntry = seenRegexes.get((K[])key);
                if (priority > oldEntry.priority) {
                    logger.warn("TokensRegexNERAnnotator " + annotatorName + ": Replace duplicate entry (higher priority): old=" + oldEntry + ", new=" + entry);
                } else {
                    String newTypeDesc;
                    String oldTypeDesc = oldEntry.getTypeDescription();
                    if (oldTypeDesc.equals(newTypeDesc = entry.getTypeDescription()) || !verbose) continue;
                    logger.warn("TokensRegexNERAnnotator " + annotatorName + ": Ignoring duplicate entry: " + split[0] + ", old type = " + oldTypeDesc + ", new type = " + newTypeDesc);
                    continue;
                }
            }
            if (entry.overwritableTypes.isEmpty() && TokensRegexNERAnnotator.hasNoOverwritableType(noDefaultOverwriteLabels, entry.types)) {
                logger.warn("TokensRegexNERAnnotator " + annotatorName + ": Entry doesn't have overwriteable types " + entry + ", but entry type is in noDefaultOverwriteLabels");
            }
            entries.add(entry);
            entryToMappingFileNumber.put(entry, mappingFileIndex);
            seenRegexes.put((String[])key, entry);
            if (entry.tokensRegex == null) continue;
            ++isTokensRegex;
        }
        logger.log("TokensRegexNERAnnotator " + annotatorName + ": Read " + (entries.size() - origEntriesSize) + " unique entries out of " + lineCount + " from " + mappingFilename + ", " + isTokensRegex + " TokensRegex patterns.");
        return entries;
    }

    private static boolean hasNoOverwritableType(Set<String> noDefaultOverwriteLabels, String[] types) {
        for (String type : types) {
            if (!noDefaultOverwriteLabels.contains(type)) continue;
            return true;
        }
        return false;
    }

    private static String[] processListMappingFiles(String mappingFiles) {
        if (mappingFiles.contains(";") && mappingFiles.contains(",")) {
            return SEMICOLON_DELIMITERS_PATTERN.split(mappingFiles);
        }
        if (mappingFiles.contains(",")) {
            return COMMA_DELIMITERS_PATTERN.split(mappingFiles);
        }
        return SEMICOLON_DELIMITERS_PATTERN.split(mappingFiles);
    }

    private static void processPerFileOptions(String annotatorName, String[] mappings, List<Boolean> ignoreCaseList, List<Pattern> validPosPatternList, boolean ignoreCase, Pattern validPosPattern) {
        Integer numMappingFiles = mappings.length;
        for (int index = 0; index < numMappingFiles; ++index) {
            boolean ignoreCaseSet = false;
            boolean validPosPatternSet = false;
            String[] allOptions = COMMA_DELIMITERS_PATTERN.split(mappings[index].trim());
            Integer numOptions = allOptions.length;
            if (numOptions > 1) {
                block9: for (int i = 0; i < numOptions - 1; ++i) {
                    String[] optionAndValue = EQUALS_DELIMITERS_PATTERN.split(allOptions[i].trim());
                    if (optionAndValue.length != 2) {
                        throw new IllegalArgumentException("TokensRegexNERAnnotator " + annotatorName + " ERROR: Incorrectly specified options for mapping file " + mappings[index].trim());
                    }
                    switch (optionAndValue[0].trim().toLowerCase()) {
                        case "ignorecase": {
                            ignoreCaseList.add(Boolean.parseBoolean(optionAndValue[1].trim()));
                            ignoreCaseSet = true;
                            continue block9;
                        }
                        case "validpospattern": {
                            String validPosRegex = optionAndValue[1].trim();
                            if (validPosRegex != null && !validPosRegex.equals("")) {
                                validPosPatternList.add(Pattern.compile(validPosRegex));
                            } else {
                                validPosPatternList.add(validPosPattern);
                            }
                            validPosPatternSet = true;
                            continue block9;
                        }
                    }
                }
                mappings[index] = allOptions[numOptions - 1];
            }
            if (!ignoreCaseSet) {
                ignoreCaseList.add(ignoreCase);
            }
            if (validPosPatternSet) continue;
            validPosPatternList.add(validPosPattern);
        }
    }

    private static boolean atLeastOneValidPosPattern(List<Pattern> validPosPatternList) {
        for (Pattern pattern : validPosPatternList) {
            if (pattern == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(this.annotationFields));
    }

    private static class Entry {
        public final String tokensRegex;
        public final String[] regex;
        public final String[] types;
        public final Set<String> overwritableTypes;
        public final double priority;
        public final double weight;
        public final int annotateGroup;

        public Entry(String tokensRegex, String[] regex, String[] types, Set<String> overwritableTypes, double priority, double weight, int annotateGroup) {
            this.tokensRegex = tokensRegex;
            this.regex = regex;
            this.types = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.types[i] = types[i].intern();
            }
            this.overwritableTypes = overwritableTypes;
            this.priority = priority;
            this.weight = weight;
            this.annotateGroup = annotateGroup;
        }

        public String getTypeDescription() {
            return "[" + StringUtils.join(this.types, ",") + "]";
        }

        public String toString() {
            return "Entry{" + (this.tokensRegex != null ? this.tokensRegex : StringUtils.join(this.regex)) + ' ' + StringUtils.join(this.types) + ' ' + this.overwritableTypes + ' ' + this.priority + '}';
        }
    }

    static enum PosMatchType {
        MATCH_ALL_TOKENS,
        MATCH_AT_LEAST_ONE_TOKEN,
        MATCH_ONE_TOKEN_PHRASE_ONLY;

    }
}

