/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.StanfordCoreNLPClient;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class ServerAnnotatorImplementations
extends AnnotatorImplementations {
    public final String host;
    public final int port;
    public final String key;
    public final String secret;
    public final boolean lazy;

    public ServerAnnotatorImplementations(String host, int port, String key, String secret, boolean lazy) {
        this.host = host;
        this.port = port;
        this.key = key;
        this.secret = secret;
        this.lazy = lazy;
    }

    public ServerAnnotatorImplementations(String host, int port) {
        this(host, port, null, null, false);
    }

    @Override
    public Annotator posTagger(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "pos");
    }

    @Override
    public Annotator ner(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "ner");
    }

    @Override
    public Annotator tokensRegexNER(Properties properties, String name) {
        return new SingletonAnnotator(this.host, this.port, properties, "regexner");
    }

    @Override
    public Annotator gender(Properties properties, boolean verbose) {
        return new SingletonAnnotator(this.host, this.port, properties, "gender");
    }

    @Override
    public Annotator parse(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "parse");
    }

    @Override
    public Annotator trueCase(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "truecase");
    }

    @Override
    public Annotator mention(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "mention");
    }

    @Override
    public Annotator coref(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "coref");
    }

    @Override
    public Annotator dcoref(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "dcoref");
    }

    @Override
    public Annotator relations(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "relation");
    }

    @Override
    public Annotator sentiment(Properties properties, String name) {
        return new SingletonAnnotator(this.host, this.port, properties, "sentiment");
    }

    @Override
    public Annotator dependencies(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "depparse");
    }

    @Override
    public Annotator openie(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "openie");
    }

    @Override
    public Annotator kbp(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "kbp");
    }

    @Override
    public Annotator link(Properties properties) {
        return new SingletonAnnotator(this.host, this.port, properties, "entitylink");
    }

    private class SingletonAnnotator
    implements Annotator {
        private final StanfordCoreNLPClient client;

        public SingletonAnnotator(String host, int port, Properties properties, String annotator) {
            Properties forClient = new Properties();
            for (Object o : properties.keySet()) {
                String key = o.toString();
                String value = properties.getProperty(key);
                forClient.setProperty(key, value);
                forClient.setProperty(annotator + '.' + key, value);
            }
            if (ServerAnnotatorImplementations.this.lazy) {
                forClient.setProperty("annotators", annotator);
                forClient.setProperty("enforceRequirements", "false");
            } else {
                String annotators = "tokenize,ssplit,pos,lemma,ner,parse,mention,coref,natlog,openie,sentiment";
                if (!annotators.contains(annotator)) {
                    annotators = annotators + "," + annotator;
                }
                forClient.setProperty("annotators", annotators);
            }
            this.client = new StanfordCoreNLPClient(forClient, host, port, ServerAnnotatorImplementations.this.key, ServerAnnotatorImplementations.this.secret);
        }

        @Override
        public void annotate(Annotation annotation) {
            this.client.annotate(annotation);
        }

        @Override
        public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
            return Collections.emptySet();
        }

        @Override
        public Set<Class<? extends CoreAnnotation>> requires() {
            return Collections.emptySet();
        }
    }
}

