/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.md.CorefMentionFinder;
import edu.stanford.nlp.coref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.coref.md.HybridCorefMentionFinder;
import edu.stanford.nlp.coref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class MentionAnnotator
extends TextAnnotationCreator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(MentionAnnotator.class);
    HeadFinder headFinder;
    CorefMentionFinder md;
    String mdName;
    Dictionaries dictionaries;
    Properties corefProperties;
    Set<Class<? extends CoreAnnotation>> mentionAnnotatorRequirements = new HashSet<Class<? extends CoreAnnotation>>();

    public MentionAnnotator(Properties props) {
        try {
            this.corefProperties = props;
            this.dictionaries = new Dictionaries(props);
            this.headFinder = MentionAnnotator.getHeadFinder(props);
            this.md = this.getMentionFinder(props, this.headFinder);
            log.info("Using mention detector type: " + this.mdName);
            this.mentionAnnotatorRequirements.addAll(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.TextAnnotation.class, CoreAnnotations.ValueAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("Error with building coref mention annotator!");
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docID == null) {
            docID = "";
        }
        if (docID.contains("nw") && (CorefProperties.conll(this.corefProperties) || this.corefProperties.getProperty("coref.input.type", "raw").equals("conll")) && CorefProperties.getLanguage(this.corefProperties) == Locale.CHINESE && PropertiesUtils.getBool(this.corefProperties, "coref.specialCaseNewswire")) {
            this.corefProperties.setProperty("removeNestedMentions", "false");
        } else {
            this.corefProperties.setProperty("removeNestedMentions", "true");
        }
        List<List<Mention>> mentions = this.md.findMentions(annotation, this.dictionaries, this.corefProperties);
        int mentionIndex = 0;
        int currIndex = 0;
        for (CoreMap sentence : sentences) {
            List<Mention> mentionsForThisSentence = mentions.get(currIndex);
            sentence.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, mentionsForThisSentence);
            ++currIndex;
            for (Mention m : mentionsForThisSentence) {
                m.mentionID = mentionIndex++;
            }
        }
    }

    private static HeadFinder getHeadFinder(Properties props) {
        Locale lang = CorefProperties.getLanguage(props);
        if (lang == Locale.ENGLISH) {
            return new SemanticHeadFinder();
        }
        if (lang == Locale.CHINESE) {
            return new ChineseSemanticHeadFinder();
        }
        throw new RuntimeException("Invalid language setting: cannot load HeadFinder");
    }

    private CorefMentionFinder getMentionFinder(Properties props, HeadFinder headFinder) throws ClassNotFoundException, IOException {
        switch (CorefProperties.mdType(props)) {
            case DEPENDENCY: {
                this.mdName = "dependency";
                return new DependencyCorefMentionFinder(props);
            }
            case HYBRID: {
                this.mdName = "hybrid";
                this.mentionAnnotatorRequirements.add(TreeCoreAnnotations.TreeAnnotation.class);
                this.mentionAnnotatorRequirements.add(CoreAnnotations.BeginIndexAnnotation.class);
                this.mentionAnnotatorRequirements.add(CoreAnnotations.EndIndexAnnotation.class);
                return new HybridCorefMentionFinder(headFinder, props);
            }
        }
        this.mentionAnnotatorRequirements.add(TreeCoreAnnotations.TreeAnnotation.class);
        this.mentionAnnotatorRequirements.add(CoreAnnotations.BeginIndexAnnotation.class);
        this.mentionAnnotatorRequirements.add(CoreAnnotations.EndIndexAnnotation.class);
        this.mdName = "rule";
        return new RuleBasedCorefMentionFinder(headFinder, props);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return this.mentionAnnotatorRequirements;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CorefCoreAnnotations.CorefMentionsAnnotation.class, CoreAnnotations.ParagraphAnnotation.class, CoreAnnotations.SpeakerAnnotation.class, CoreAnnotations.UtteranceAnnotation.class)));
    }
}

