/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefSystem;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CorefAnnotator
extends TextAnnotationCreator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CorefAnnotator.class);
    private final CorefSystem corefSystem;
    private final Properties props;

    public CorefAnnotator(Properties props) {
        this.props = props;
        try {
            props.setProperty("coref.printConLLLoadingMessage", "false");
            this.corefSystem = new CorefSystem(props);
            props.remove("coref.printConLLLoadingMessage");
        }
        catch (Exception e) {
            log.error("cannot create CorefAnnotator!");
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        try {
            if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                log.error("this coreference resolution system requires SentencesAnnotation!");
                return;
            }
            if (CorefAnnotator.hasSpeakerAnnotations(annotation)) {
                annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
            }
            this.corefSystem.annotate(annotation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Pair<IntTuple, IntTuple>> getLinks(Map<Integer, CorefChain> result) {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        CorefChain.CorefMentionComparator comparator = new CorefChain.CorefMentionComparator();
        for (CorefChain c : result.values()) {
            List<CorefChain.CorefMention> s = c.getMentionsInTextualOrder();
            for (CorefChain.CorefMention m1 : s) {
                for (CorefChain.CorefMention m2 : s) {
                    if (comparator.compare(m1, m2) != 1) continue;
                    links.add(new Pair<IntTuple, IntTuple>(m1.position, m2.position));
                }
            }
        }
        return links;
    }

    private static boolean hasSpeakerAnnotations(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel t : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CorefCoreAnnotations.CorefMentionsAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class));
        if (CorefProperties.mdType(this.props) != CorefProperties.MentionDetectionType.DEPENDENCY) {
            requirements.add(TreeCoreAnnotations.TreeAnnotation.class);
            requirements.add(CoreAnnotations.CategoryAnnotation.class);
        }
        return Collections.unmodifiableSet(requirements);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CorefCoreAnnotations.CorefChainAnnotation.class);
    }
}

