/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.dep;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.dep.DataInstanceDep;
import edu.stanford.nlp.patterns.dep.ExtractPhraseFromPattern;
import edu.stanford.nlp.patterns.dep.ExtractedPhrase;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ApplyDepPatterns<E extends Pattern>
implements Callable<Pair<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>> {
    private String label;
    private Map<SemgrexPattern, E> patterns;
    private List<String> sentids;
    private boolean removeStopWordsFromSelectedPhrases;
    private boolean removePhrasesWithStopWords;
    private ConstantsAndVariables constVars;
    private Map<String, DataInstance> sents;
    private Function<CoreLabel, Boolean> matchingWordRestriction = new Function<CoreLabel, Boolean>(){

        @Override
        public Boolean apply(CoreLabel coreLabel) {
            return ApplyDepPatterns.this.matchedRestriction(coreLabel, ApplyDepPatterns.this.label);
        }
    };

    public ApplyDepPatterns(Map<String, DataInstance> sents, List<String> sentids, Map<SemgrexPattern, E> patterns, String label, boolean removeStopWordsFromSelectedPhrases, boolean removePhrasesWithStopWords, ConstantsAndVariables cv) {
        this.sents = sents;
        this.patterns = patterns;
        this.sentids = sentids;
        this.label = label;
        this.removeStopWordsFromSelectedPhrases = removeStopWordsFromSelectedPhrases;
        this.removePhrasesWithStopWords = removePhrasesWithStopWords;
        this.constVars = cv;
    }

    @Override
    public Pair<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>> call() throws Exception {
        TwoDimensionalCounter<CandidatePhrase, E> allFreq = new TwoDimensionalCounter<CandidatePhrase, E>();
        CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat = new CollectionValuedMap<E, Triple<String, Integer, Integer>>();
        for (String sentid : this.sentids) {
            DataInstance sent = this.sents.get(sentid);
            List<CoreLabel> tokens = sent.getTokens();
            for (Map.Entry<SemgrexPattern, E> pEn : this.patterns.entrySet()) {
                if (pEn.getKey() == null) {
                    throw new RuntimeException("why is the pattern " + pEn + " null?");
                }
                SemanticGraph graph = ((DataInstanceDep)sent).getGraph();
                Collection<ExtractedPhrase> matched = this.getMatchedTokensIndex(graph, pEn.getKey(), sent, this.label);
                for (ExtractedPhrase match : matched) {
                    int i;
                    int s = match.startIndex;
                    int e = match.endIndex + 1;
                    String phrase = "";
                    String phraseLemma = "";
                    boolean useWordNotLabeled = false;
                    boolean doNotUse = false;
                    if (this.constVars.clubNeighboringLabeledWords) {
                        int i2 = s - 1;
                        while (i2 >= 0 && ((String)tokens.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label) && e - i2 + 1 <= PatternFactory.numWordsCompoundMapped.get(this.label)) {
                            s = i2--;
                        }
                        i2 = e;
                        while (i2 < tokens.size() && ((String)tokens.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label) && i2 - s + 1 <= PatternFactory.numWordsCompoundMapped.get(this.label)) {
                            e = i2++;
                        }
                    }
                    boolean[] addedindices = new boolean[e - s];
                    for (i = s; i < e; ++i) {
                        CoreLabel l = tokens.get(i);
                        l.set(PatternsAnnotations.MatchedPattern.class, true);
                        if (!l.containsKey(PatternsAnnotations.MatchedPatterns.class) || l.get(PatternsAnnotations.MatchedPatterns.class) == null) {
                            l.set(PatternsAnnotations.MatchedPatterns.class, new HashSet());
                        }
                        Pattern pSur = (Pattern)pEn.getValue();
                        assert (pSur != null) : "Why is " + pEn.getValue() + " not present in the index?!";
                        assert (l.get(PatternsAnnotations.MatchedPatterns.class) != null) : "How come MatchedPatterns class is null for the token. The classes in the key set are " + l.keySet();
                        ((Set)l.get(PatternsAnnotations.MatchedPatterns.class)).add(pSur);
                        for (Map.Entry<Class, Object> ig : this.constVars.getIgnoreWordswithClassesDuringSelection().get(this.label).entrySet()) {
                            if (!l.containsKey(ig.getKey()) || !l.get(ig.getKey()).equals(ig.getValue())) continue;
                            doNotUse = true;
                        }
                        boolean containsStop = ApplyDepPatterns.containsStopWord(l, this.constVars.getCommonEngWords(), PatternFactory.ignoreWordRegex);
                        if (this.removePhrasesWithStopWords && containsStop) {
                            doNotUse = true;
                            continue;
                        }
                        if (containsStop && this.removeStopWordsFromSelectedPhrases) continue;
                        if (this.label == null || l.get(this.constVars.getAnswerClass().get(this.label)) == null || !((String)l.get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) {
                            useWordNotLabeled = true;
                        }
                        phrase = phrase + " " + l.word();
                        phraseLemma = phraseLemma + " " + l.lemma();
                        addedindices[i - s] = true;
                    }
                    for (i = 0; i < addedindices.length; ++i) {
                        if (i <= 0 || i >= addedindices.length - 1 || !addedindices[i - 1] || addedindices[i] || !addedindices[i + 1]) continue;
                        doNotUse = true;
                        break;
                    }
                    if (doNotUse || !useWordNotLabeled) continue;
                    matchedTokensByPat.add(pEn.getValue(), new Triple<String, Integer, Integer>(sentid, s, e - 1));
                    if (!useWordNotLabeled) continue;
                    phrase = phrase.trim();
                    phraseLemma = phraseLemma.trim();
                    allFreq.incrementCount(CandidatePhrase.createOrGet(phrase, phraseLemma, match.getFeatures()), pEn.getValue(), 1.0);
                }
            }
        }
        return new Pair<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>(allFreq, matchedTokensByPat);
    }

    private Collection<ExtractedPhrase> getMatchedTokensIndex(SemanticGraph graph, SemgrexPattern pattern, DataInstance sent, String label) {
        ExtractPhraseFromPattern extract = new ExtractPhraseFromPattern(false, PatternFactory.numWordsCompoundMapped.get(label));
        ArrayList<IntPair> outputIndices = new ArrayList<IntPair>();
        boolean findSubTrees = true;
        List<CoreLabel> tokensC = sent.getTokens();
        List<String> tokens = tokensC.stream().map(x -> x.word()).collect(Collectors.toList());
        ArrayList<String> outputPhrases = new ArrayList<String>();
        ArrayList<ExtractedPhrase> extractedPhrases = new ArrayList<ExtractedPhrase>();
        Function<Pair<IndexedWord, SemanticGraph>, Counter<String>> extractFeatures = new Function<Pair<IndexedWord, SemanticGraph>, Counter<String>>(){

            @Override
            public Counter<String> apply(Pair<IndexedWord, SemanticGraph> indexedWordSemanticGraphPair) {
                ClassicCounter<String> feat = new ClassicCounter<String>();
                IndexedWord vertex = indexedWordSemanticGraphPair.first();
                SemanticGraph graph = indexedWordSemanticGraphPair.second();
                List<Pair<GrammaticalRelation, IndexedWord>> pt = graph.parentPairs(vertex);
                for (Pair<GrammaticalRelation, IndexedWord> en : pt) {
                    feat.incrementCount("PARENTREL-" + en.first());
                }
                return feat;
            }
        };
        extract.getSemGrexPatternNodes(graph, tokens, outputPhrases, outputIndices, pattern, findSubTrees, extractedPhrases, ConstantsAndVariables.matchLowerCaseContext, this.matchingWordRestriction);
        return extractedPhrases;
    }

    private boolean matchedRestriction(CoreLabel coreLabel, String label) {
        boolean use = false;
        if (PatternFactory.useTargetNERRestriction) {
            for (String s : this.constVars.allowedNERsforLabels.get(label)) {
                if (!((String)coreLabel.get(CoreAnnotations.NamedEntityTagAnnotation.class)).matches(s)) continue;
                use = true;
                break;
            }
        } else {
            use = true;
        }
        if (use) {
            String tag = coreLabel.tag();
            if (this.constVars.allowedTagsInitials != null && this.constVars.allowedTagsInitials.containsKey(label)) {
                for (String allowed : this.constVars.allowedTagsInitials.get(label)) {
                    if (tag.startsWith(allowed)) {
                        use = true;
                        break;
                    }
                    use = false;
                }
            }
        }
        if (this.constVars.debug >= 4) {
            if (use) {
                System.out.println(coreLabel.word() + " matched restriction " + (PatternFactory.useTargetNERRestriction ? this.constVars.allowedNERsforLabels.get(label) : "") + "and" + PatternFactory.useTargetNERRestriction + " and " + (this.constVars.allowedTagsInitials != null ? this.constVars.allowedTagsInitials.get(label) : ""));
            } else {
                System.out.println(coreLabel.word() + " did not matched restrict " + (PatternFactory.useTargetNERRestriction ? this.constVars.allowedNERsforLabels.get(label) : "") + "and" + PatternFactory.useTargetNERRestriction + " and " + (this.constVars.allowedTagsInitials != null ? this.constVars.allowedTagsInitials.get(label) : ""));
            }
        }
        return use;
    }

    private static boolean containsStopWord(CoreLabel l, Set<String> commonEngWords, java.util.regex.Pattern ignoreWordRegex) {
        return commonEngWords != null && (commonEngWords.contains(l.lemma()) || commonEngWords.contains(l.word())) || ignoreWordRegex != null && ignoreWordRegex.matcher(l.lemma()).matches();
    }
}

