/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Configuration {
    final List<Integer> stack;
    final List<Integer> buffer;
    final DependencyTree tree;
    final CoreMap sentence;

    public Configuration(Configuration config) {
        this.stack = new ArrayList<Integer>(config.stack);
        this.buffer = new ArrayList<Integer>(config.buffer);
        this.tree = new DependencyTree(config.tree);
        this.sentence = new CoreLabel(config.sentence);
    }

    public Configuration(CoreMap sentence) {
        this.stack = new ArrayList<Integer>();
        this.buffer = new ArrayList<Integer>();
        this.tree = new DependencyTree();
        this.sentence = sentence;
    }

    public boolean shift() {
        int k = this.getBuffer(0);
        if (k == -1) {
            return false;
        }
        this.buffer.remove(0);
        this.stack.add(k);
        return true;
    }

    public boolean removeSecondTopStack() {
        int nStack = this.getStackSize();
        if (nStack < 2) {
            return false;
        }
        this.stack.remove(nStack - 2);
        return true;
    }

    public boolean removeTopStack() {
        int nStack = this.getStackSize();
        if (nStack < 1) {
            return false;
        }
        this.stack.remove(nStack - 1);
        return true;
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public int getSentenceSize() {
        return this.getCoreLabels().size();
    }

    public int getHead(int k) {
        return this.tree.getHead(k);
    }

    public String getLabel(int k) {
        return this.tree.getLabel(k);
    }

    public int getStack(int k) {
        int nStack = this.getStackSize();
        return k >= 0 && k < nStack ? this.stack.get(nStack - 1 - k) : -1;
    }

    public int getBuffer(int k) {
        return k >= 0 && k < this.getBufferSize() ? this.buffer.get(k) : -1;
    }

    public List<CoreLabel> getCoreLabels() {
        return (List)this.sentence.get(CoreAnnotations.TokensAnnotation.class);
    }

    public String getWord(int k) {
        if (k == 0) {
            return "-ROOT-";
        }
        List<CoreLabel> lbls = this.getCoreLabels();
        return --k < 0 || k >= lbls.size() ? "-NULL-" : lbls.get(k).word();
    }

    public String getPOS(int k) {
        if (k == 0) {
            return "-ROOT-";
        }
        List<CoreLabel> lbls = this.getCoreLabels();
        return --k < 0 || k >= lbls.size() ? "-NULL-" : lbls.get(k).tag();
    }

    public void addArc(int h, int t, String l) {
        this.tree.set(t, h, l);
    }

    public int getLeftChild(int k, int cnt) {
        if (k < 0 || k > this.tree.n) {
            return -1;
        }
        int c = 0;
        for (int i = 1; i < k; ++i) {
            if (this.tree.getHead(i) != k || ++c != cnt) continue;
            return i;
        }
        return -1;
    }

    public int getLeftChild(int k) {
        return this.getLeftChild(k, 1);
    }

    public int getRightChild(int k, int cnt) {
        if (k < 0 || k > this.tree.n) {
            return -1;
        }
        int c = 0;
        for (int i = this.tree.n; i > k; --i) {
            if (this.tree.getHead(i) != k || ++c != cnt) continue;
            return i;
        }
        return -1;
    }

    public int getRightChild(int k) {
        return this.getRightChild(k, 1);
    }

    public boolean hasOtherChild(int k, DependencyTree goldTree) {
        for (int i = 1; i <= this.tree.n; ++i) {
            if (goldTree.getHead(i) != k || this.tree.getHead(i) == k) continue;
            return true;
        }
        return false;
    }

    public int getLeftValency(int k) {
        if (k < 0 || k > this.tree.n) {
            return -1;
        }
        int cnt = 0;
        for (int i = 1; i < k; ++i) {
            if (this.tree.getHead(i) != k) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getRightValency(int k) {
        if (k < 0 || k > this.tree.n) {
            return -1;
        }
        int cnt = 0;
        for (int i = k + 1; i <= this.tree.n; ++i) {
            if (this.tree.getHead(i) != k) continue;
            ++cnt;
        }
        return cnt;
    }

    public String getLeftLabelSet(int k) {
        if (k < 0 || k > this.tree.n) {
            return "-NULL-";
        }
        HashSet<String> labelSet = new HashSet<String>();
        for (int i = 1; i < k; ++i) {
            if (this.tree.getHead(i) != k) continue;
            labelSet.add(this.tree.getLabel(i));
        }
        ArrayList ls = new ArrayList(labelSet);
        Collections.sort(ls);
        String s = "";
        for (String l : ls) {
            s = s + "/" + l;
        }
        return s;
    }

    public String getRightLabelSet(int k) {
        if (k < 0 || k > this.tree.n) {
            return "-NULL-";
        }
        HashSet<String> labelSet = new HashSet<String>();
        for (int i = k + 1; i <= this.tree.n; ++i) {
            if (this.tree.getHead(i) != k) continue;
            labelSet.add(this.tree.getLabel(i));
        }
        ArrayList ls = new ArrayList(labelSet);
        Collections.sort(ls);
        String s = "";
        for (String l : ls) {
            s = s + "/" + l;
        }
        return s;
    }

    public String getStr() {
        int i;
        String s = "[S]";
        for (i = 0; i < this.getStackSize(); ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + this.stack.get(i);
        }
        s = s + "[B]";
        for (i = 0; i < this.getBufferSize(); ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + this.buffer.get(i);
        }
        s = s + "[H]";
        for (i = 1; i <= this.tree.n; ++i) {
            if (i > 1) {
                s = s + ",";
            }
            s = s + this.getHead(i) + "(" + this.getLabel(i) + ")";
        }
        return s;
    }
}

