/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;

public class CoreUtilities {
    private CoreUtilities() {
    }

    public static String toSentence(List<? extends CoreMap> sentence) {
        StringBuilder text = new StringBuilder();
        int sz = sentence.size();
        for (int i = 0; i < sz; ++i) {
            CoreMap iw = sentence.get(i);
            text.append((String)iw.get(CoreAnnotations.TextAnnotation.class));
            if (i >= sz - 1) continue;
            text.append(' ');
        }
        return text.toString();
    }

    public static List<CoreLabel> deepCopy(List<CoreLabel> tokens) {
        ArrayList<CoreLabel> copy = new ArrayList<CoreLabel>();
        for (CoreLabel ml : tokens) {
            CoreLabel ml1 = new CoreLabel(ml);
            copy.add(ml1);
        }
        return copy;
    }

    public static List<CoreLabel> toCoreLabelList(String ... words) {
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.length);
        for (String word : words) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(word);
            tokens.add(cl);
        }
        return tokens;
    }

    public static List<CoreLabel> toCoreLabelList(List<String> words) {
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.size());
        for (String word : words) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(word);
            tokens.add(cl);
        }
        return tokens;
    }

    public static List<CoreLabel> toCoreLabelList(String[] words, String[] tags) {
        assert (tags.length == words.length);
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.length);
        int sz = words.length;
        for (int i = 0; i < sz; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(words[i]);
            cl.setTag(tags[i]);
            tokens.add(cl);
        }
        return tokens;
    }

    public static List<CoreLabel> toCoreLabelListWithCharacterOffsets(String[] words, String[] tags) {
        assert (tags.length == words.length);
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.length);
        int offset = 0;
        int sz = words.length;
        for (int i = 0; i < sz; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(words[i]);
            cl.setTag(tags[i]);
            cl.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, offset);
            cl.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, offset += words[i].length());
            ++offset;
            tokens.add(cl);
        }
        return tokens;
    }

    public static List<CoreLabel> toCoreLabelList(String[] words, String[] tags, String[] answers) {
        assert (tags.length == words.length);
        assert (answers.length == words.length);
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.length);
        int sz = words.length;
        for (int i = 0; i < sz; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(words[i]);
            cl.setTag(tags[i]);
            cl.set(CoreAnnotations.AnswerAnnotation.class, answers[i]);
            tokens.add(cl);
        }
        return tokens;
    }
}

