/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.regexp.ChineseNumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChineseQuantifiableEntityNormalizer {
    private static Redwood.RedwoodChannels log = Redwood.channels(ChineseQuantifiableEntityNormalizer.class);
    private static final boolean DEBUG = false;
    public static String BACKGROUND_SYMBOL = "O";
    private static final Set<String> quantifiable;
    private static final ClassicCounter<String> wordsToValues;
    private static final ClassicCounter<String> quantityUnitToValues;
    private static final Map<String, Character> multiCharCurrencyWords;
    private static final Map<String, Character> oneCharCurrencyWords;
    private static final Map<String, String> fullDigitToHalfDigit;
    private static final Map<String, Integer> yearModifiers;
    private static final Map<String, Integer> monthDayModifiers;
    private static final String LITERAL_DECIMAL_POINT = "\u70b9";
    private static final Pattern ARABIC_NUMBERS_PATTERN;
    private static final Pattern CHINESE_LITERAL_NUMBER_SEQUENCE_PATTERN;
    private static final Pattern CHINESE_LITERAL_DECIMAL_PATTERN;
    private static final String greaterEqualThreeWords = "(?:\u5927|\u591a|\u9ad8)\u4e8e\u6216\u8005?\u7b49\u4e8e";
    private static final String lessEqualThreeWords = "(?:\u5c0f|\u5c11|\u4f4e)\u4e8e\u6216\u8005?\u7b49\u4e8e";
    private static final String greaterEqualTwoWords = "(?:\u5927|\u591a)\u4e8e\u7b49\u4e8e|\u4e0d(?:\u5c11|\u5c0f|\u4f4e)\u4e8e";
    private static final String lessEqualTwoWords = "(?:\u5c0f|\u5c11)\u4e8e\u7b49\u4e8e|\u4e0d(?:\u5927|\u5c11|\u9ad8)\u4e8e|\u4e0d\u8d85\u8fc7";
    private static final String approxTwoWords = "\u5927(?:\u6982|\u7ea6|\u81f4)(?:\u662f|\u4e3a)|\u5927\u6982\u5176";
    private static final String greaterThanOneWord = "(?:\u5927|\u591a|\u9ad8)\u4e8e|(?:\u8d85|\u9ad8|\u591a)\u8fc7";
    private static final String lessThanOneWord = "(?:\u5c0f|\u5c11|\u4f4e)\u4e8e|\u4e0d(?:\u5230|\u591f|\u8db3)";
    private static final String approxOneWord = "\u5927(?:\u7ea6|\u6982|\u81f4)|\u63a5?\u8fd1|\u5dee\u4e0d\u591a|\u51e0\u4e4e|\u5de6\u53f3|\u4e0a\u4e0b|\u7ea6(?:\u4e3a|\u7565)";
    private static final String NUMBER_TAG = "NUMBER";
    private static final String DATE_TAG = "DATE";
    private static final String TIME_TAG = "TIME";
    private static final String MONEY_TAG = "MONEY";
    private static final String ORDINAL_TAG = "ORDINAL";
    private static final String PERCENT_TAG = "PERCENT";
    private static final String CHINESE_DATE_NUMERALS_PATTERN = "[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007]";
    private static final String CHINESE_AND_ARABIC_NUMERALS_PATTERN = "[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d]";
    private static final String CHINESE_AND_ARABIC_NUMERALS_PATTERN_WO_TEN = "[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u3007\\d]";
    private static final String YEAR_MODIFIER_PATTERN;
    private static final String MONTH_DAY_MODIFIER_PATTERN;
    private static final String BASIC_DD_PATTERN;
    private static final String BASIC_MMDD_PATTERN;
    private static final String BASIC_YYYYMMDD_PATTERN;
    private static final String ENGLISH_MMDDYYYY_PATTERN = "(\\d{1,2})[/\\-\\.](\\d{1,2})(?:[/\\-\\.](\\d{4}))?";
    private static final String RELATIVE_TIME_PATTERN = "([\u6628\u4eca\u660e])[\u5929\u6668\u665a\u591c\u65e9]";
    private static final String BIRTH_DECADE_PATTERN = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d][0\u96f6\u30075\u4e94])\u540e";

    public static <E extends CoreMap> void addNormalizedQuantitiesToEntities(List<E> list, CoreMap document, CoreMap sentence) {
        ChineseQuantifiableEntityNormalizer.fixupNerBeforeNormalization(list);
        String prevNerTag = BACKGROUND_SYMBOL;
        int beforeIndex = -1;
        ArrayList<CoreMap> collector = new ArrayList<CoreMap>();
        int sz = list.size();
        for (int i = 0; i <= sz; ++i) {
            CoreMap wprev;
            CoreMap wi = null;
            String currNerTag = null;
            String nextWord = "";
            if (i < sz) {
                wi = (CoreMap)list.get(i);
                if (i + 1 < sz && (nextWord = (String)((CoreMap)list.get(i + 1)).get(CoreAnnotations.TextAnnotation.class)) == null) {
                    nextWord = "";
                }
                currNerTag = (String)wi.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            }
            CoreMap coreMap = wprev = i > 0 ? (CoreMap)list.get(i - 1) : null;
            if ((currNerTag == null || !currNerTag.equals(prevNerTag)) && quantifiable.contains(prevNerTag)) {
                String modifier = null;
                switch (prevNerTag) {
                    case "TIME": {
                        break;
                    }
                    case "DATE": {
                        ChineseQuantifiableEntityNormalizer.processEntity(collector, prevNerTag, modifier, nextWord, document);
                        break;
                    }
                    default: {
                        if (prevNerTag.equals(NUMBER_TAG) || prevNerTag.equals(PERCENT_TAG) || prevNerTag.equals(MONEY_TAG)) {
                            modifier = ChineseQuantifiableEntityNormalizer.detectQuantityModifier(list, beforeIndex, i);
                        }
                        ChineseQuantifiableEntityNormalizer.processEntity(collector, prevNerTag, modifier, nextWord);
                    }
                }
                collector = new ArrayList();
            }
            if (quantifiable.contains(currNerTag)) {
                if (collector.isEmpty()) {
                    beforeIndex = i - 1;
                }
                collector.add(wi);
            }
            prevNerTag = currNerTag;
        }
    }

    private static <E extends CoreMap> String detectQuantityModifier(List<E> list, int beforeIndex, int afterIndex) {
        String prev = beforeIndex >= 0 ? ((String)((CoreMap)list.get(beforeIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev2 = beforeIndex - 1 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 1)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev3 = beforeIndex - 2 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 2)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        int sz = list.size();
        String next = afterIndex < sz ? ((String)((CoreMap)list.get(afterIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String longPrev = prev3 + prev2 + prev;
        if (longPrev.matches(lessEqualThreeWords)) {
            return "<=";
        }
        if (longPrev.matches(greaterEqualThreeWords)) {
            return ">=";
        }
        longPrev = prev2 + prev;
        if (longPrev.matches(greaterEqualTwoWords)) {
            return ">=";
        }
        if (longPrev.matches(lessEqualTwoWords)) {
            return "<=";
        }
        if (longPrev.matches(approxTwoWords)) {
            return "~";
        }
        if (prev.matches(greaterThanOneWord)) {
            return ">";
        }
        if (prev.matches(lessThanOneWord)) {
            return "<";
        }
        if (prev.matches(approxOneWord)) {
            return "~";
        }
        if (next.matches(approxOneWord)) {
            return "~";
        }
        if (prev.matches(greaterEqualTwoWords)) {
            return ">=";
        }
        if (prev.matches(lessEqualTwoWords)) {
            return "<=";
        }
        return null;
    }

    private static <E extends CoreMap> List<E> processEntity(List<E> l, String entityType, String compModifier, String nextWord) {
        return ChineseQuantifiableEntityNormalizer.processEntity(l, entityType, compModifier, nextWord, null);
    }

    private static <E extends CoreMap> List<E> processEntity(List<E> l, String entityType, String compModifier, String nextWord, CoreMap document) {
        String s = ChineseQuantifiableEntityNormalizer.singleEntityToString(l);
        StringBuilder sb = new StringBuilder();
        int sz = s.length();
        for (int i = 0; i < sz; ++i) {
            String ch = s.substring(i, i + 1);
            if (fullDigitToHalfDigit.containsKey(ch)) {
                ch = fullDigitToHalfDigit.get(ch);
            }
            sb.append(ch);
        }
        s = sb.toString();
        String p = null;
        switch (entityType) {
            case "NUMBER": {
                String q;
                p = "";
                if (compModifier != null) {
                    p = compModifier;
                }
                if ((q = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s, nextWord, 1.0)) != null) {
                    p = p.concat(q);
                    break;
                }
                p = null;
                break;
            }
            case "ORDINAL": {
                p = ChineseQuantifiableEntityNormalizer.normalizedOrdinalString(s, nextWord);
                break;
            }
            case "PERCENT": {
                p = ChineseQuantifiableEntityNormalizer.normalizedPercentString(s, nextWord);
                break;
            }
            case "MONEY": {
                String q;
                p = "";
                if (compModifier != null) {
                    p = compModifier;
                }
                if ((q = ChineseQuantifiableEntityNormalizer.normalizedMoneyString(s, nextWord)) != null) {
                    p = p.concat(q);
                    break;
                }
                p = null;
                break;
            }
            case "DATE": {
                if (!s.matches(BASIC_YYYYMMDD_PATTERN) && !s.matches(BASIC_MMDD_PATTERN) && !s.matches(ENGLISH_MMDDYYYY_PATTERN) && !s.matches(BASIC_DD_PATTERN) && !s.matches(RELATIVE_TIME_PATTERN) && !s.matches(BIRTH_DECADE_PATTERN)) break;
                String docdate = (String)document.get(CoreAnnotations.DocDateAnnotation.class);
                p = ChineseQuantifiableEntityNormalizer.normalizeDateString(s, docdate);
                break;
            }
        }
        for (CoreMap wi : l) {
            if (p == null) continue;
            wi.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, p);
        }
        return l;
    }

    private static String normalizedMoneyString(String s, String nextWord) {
        String value;
        double multiplier = 1.0;
        char currencySign = '$';
        boolean notMatched = true;
        for (String currencyWord : multiCharCurrencyWords.keySet()) {
            if (!notMatched || !StringUtils.find(s, currencyWord)) continue;
            if (currencyWord.equals("\u7f8e\u5206")) {
                multiplier = 0.01;
            } else if (currencyWord.equals("\u5148\u4ee4")) {
                multiplier = 0.05;
            } else if (currencyWord.equals("\u4fbf\u58eb")) {
                multiplier = 0.004166666666666667;
            }
            s = s.replaceAll(currencyWord, "");
            currencySign = multiCharCurrencyWords.get(currencyWord).charValue();
            notMatched = false;
        }
        if (notMatched) {
            for (String currencyWord : oneCharCurrencyWords.keySet()) {
                if (!notMatched || !StringUtils.find(s, currencyWord)) continue;
                s = s.replaceAll(currencyWord, "");
                currencySign = oneCharCurrencyWords.get(currencyWord).charValue();
                notMatched = false;
            }
        }
        if (notMatched) {
            for (String currencyWord : ChineseNumberSequenceClassifier.CURRENCY_WORDS_VALUES) {
                if (!notMatched || !StringUtils.find(s, currencyWord)) continue;
                s = s.replaceAll(currencyWord, "");
                break;
            }
        }
        if ((value = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s, nextWord, multiplier)) == null) {
            return null;
        }
        return currencySign + value;
    }

    private static String normalizedPercentString(String s, String nextWord) {
        String ns = "";
        if (s.startsWith("\u767e\u5206\u4e4b")) {
            ns = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s.substring(3), nextWord, 1.0);
            if (ns != null) {
                ns = ns + "%";
            }
        } else if (s.startsWith("\u5343\u5206\u4e4b")) {
            ns = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s.substring(3), nextWord, 1.0);
            if (ns != null) {
                ns = ns + "\u2030";
            }
        } else if (s.endsWith("%")) {
            ns = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s.substring(0, s.length() - 1), nextWord, 1.0);
            if (ns != null) {
                ns = ns + "%";
            }
        } else if (s.endsWith("\u2030")) {
            ns = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s.substring(0, s.length() - 1), nextWord, 1.0);
            ns = ns + "\u2030";
        } else {
            ns = ChineseQuantifiableEntityNormalizer.normalizedNumberString(s, nextWord, 1.0);
            if (ns != null) {
                ns = ns + "%";
            }
        }
        return ns;
    }

    private static String normalizedOrdinalString(String s, String nextWord) {
        if (s.startsWith("\u7b2c")) {
            return ChineseQuantifiableEntityNormalizer.normalizedNumberString(s.substring(1), nextWord, 1.0);
        }
        return ChineseQuantifiableEntityNormalizer.normalizedNumberString(s, nextWord, 1.0);
    }

    private static String normalizedNumberString(String s, String nextWord, double multiplier) {
        Double integerValue;
        s = s.trim();
        if (ARABIC_NUMBERS_PATTERN.matcher(s = s.replaceAll("[ \t\n\u0000\f\r,]", "")).matches()) {
            return ChineseQuantifiableEntityNormalizer.prettyNumber(String.format("%f", multiplier * Double.valueOf(s)));
        }
        int decimalIndex = s.indexOf(LITERAL_DECIMAL_POINT);
        Double decimalValue = 0.0;
        if (decimalIndex != -1) {
            decimalValue = ChineseQuantifiableEntityNormalizer.normalizeLiteralDecimalString(s.substring(decimalIndex + 1));
            if (decimalValue == null) {
                return null;
            }
            s = s.substring(0, decimalIndex);
        }
        if ((integerValue = ChineseQuantifiableEntityNormalizer.recurNormalizeLiteralIntegerString(s)) == null) {
            return null;
        }
        return ChineseQuantifiableEntityNormalizer.prettyNumber(String.format("%f", multiplier * Double.valueOf(integerValue + decimalValue)));
    }

    private static Double recurNormalizeLiteralIntegerString(String s) {
        if (s.isEmpty()) {
            return 0.0;
        }
        if (ARABIC_NUMBERS_PATTERN.matcher(s).matches()) {
            return Double.valueOf(s);
        }
        if (s.length() > 1 && (s.startsWith("\u96f6") || s.startsWith("\u3007"))) {
            s = s.substring(1);
        }
        if (s.length() == 1 && wordsToValues.containsKey(s)) {
            return wordsToValues.getCount(s);
        }
        Double value = ChineseQuantifiableEntityNormalizer.compositeAtUnitIfExists(s, "\u4ebf");
        if (value != null) {
            return value;
        }
        value = ChineseQuantifiableEntityNormalizer.compositeAtUnitIfExists(s, "\u4e07");
        if (value != null) {
            return value;
        }
        value = ChineseQuantifiableEntityNormalizer.compositeAtUnitIfExists(s, "\u5343");
        if (value != null) {
            return value;
        }
        value = ChineseQuantifiableEntityNormalizer.compositeAtUnitIfExists(s, "\u767e");
        if (value != null) {
            return value;
        }
        value = ChineseQuantifiableEntityNormalizer.compositeAtUnitIfExists(s, "\u5341");
        if (value != null) {
            return value;
        }
        return null;
    }

    private static Double compositeAtUnitIfExists(String s, String unit) {
        if (!quantityUnitToValues.containsKey(unit)) {
            return null;
        }
        int idx = s.indexOf(unit);
        if (idx != -1) {
            Double first = 1.0;
            if (!"\u5341".equals(unit) && !"\u767e".equals(unit) || idx != 0) {
                first = ChineseQuantifiableEntityNormalizer.recurNormalizeLiteralIntegerString(s.substring(0, idx));
            }
            Double second = ChineseQuantifiableEntityNormalizer.recurNormalizeLiteralIntegerString(s.substring(idx + 1));
            if (first != null && second != null) {
                return first * quantityUnitToValues.getCount(unit) + second;
            }
        }
        return null;
    }

    private static Double normalizeLiteralDecimalString(String s) {
        if (s.isEmpty()) {
            return 0.0;
        }
        if (!CHINESE_LITERAL_DECIMAL_PATTERN.matcher(s).matches()) {
            return null;
        }
        double decimalValue = 0.0;
        double base = 1.0;
        int sz = s.length();
        for (int i = 0; i < sz; ++i) {
            base *= 0.1;
            String c = Character.toString(s.charAt(i));
            if (!wordsToValues.containsKey(c)) {
                return null;
            }
            double v = wordsToValues.getCount(c);
            decimalValue += v * base;
        }
        return decimalValue;
    }

    private static String normalizeMonthOrDay(String s, String context) {
        int ctx = -1;
        if (!context.equals("XX")) {
            ctx = Integer.valueOf(context);
        }
        if (monthDayModifiers.containsKey(s)) {
            if (ctx >= 0) {
                return String.format("%02d", ctx + monthDayModifiers.get(s));
            }
            return "XX";
        }
        if (s == null) {
            return "XX";
        }
        String candidate = s.matches("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007]+") ? ChineseQuantifiableEntityNormalizer.prettyNumber(String.format("%f", ChineseQuantifiableEntityNormalizer.recurNormalizeLiteralIntegerString(s))) : s;
        if (candidate.length() < 2) {
            candidate = "0" + candidate;
        }
        return candidate;
    }

    private static String normalizeYear(String s, String contextYear) {
        return ChineseQuantifiableEntityNormalizer.normalizeYear(s, contextYear, false);
    }

    private static String normalizeYear(String s, String contextYear, boolean strict) {
        int ctx = -1;
        if (!contextYear.equals("XXXX")) {
            ctx = Integer.valueOf(contextYear);
        }
        if (yearModifiers.containsKey(s)) {
            if (ctx >= 0) {
                return String.format("%d", ctx + yearModifiers.get(s));
            }
            return "XXXX";
        }
        StringBuilder yearcandidate = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String t = "" + s.charAt(i);
            if (CHINESE_LITERAL_DECIMAL_PATTERN.matcher(t).matches()) {
                if (wordsToValues.containsKey(t)) {
                    yearcandidate.append((int)wordsToValues.getCount(t));
                    continue;
                }
                return null;
            }
            yearcandidate.append(t);
        }
        String candidate = yearcandidate.toString();
        if (candidate.length() != 2) {
            return candidate;
        }
        if (ctx < 0) {
            ctx = Integer.valueOf(new SimpleDateFormat("yyyy").format(new Date()));
        }
        int cand = Integer.valueOf(candidate);
        cand = strict && cand >= ctx % 100 || cand > ctx % 100 + 10 ? (cand += (ctx / 100 - 1) * 100) : (cand += ctx / 100 * 100);
        return String.format("%d", cand);
    }

    public static String normalizeDateString(String s, String ctxdate) {
        Pattern p;
        Matcher m;
        String ctxyear = "XXXX";
        String ctxmonth = "XX";
        String ctxday = "XX";
        if (ctxdate != null && (m = (p = Pattern.compile("^" + BASIC_YYYYMMDD_PATTERN + "$")).matcher(ctxdate)).find() && m.groupCount() == 3) {
            ctxyear = m.group(1);
            ctxmonth = m.group(2);
            ctxday = m.group(3);
        }
        if ((m = (p = Pattern.compile("^([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d][0\u96f6\u30075\u4e94])\u540e$")).matcher(s)).find() && m.groupCount() == 1) {
            StringBuilder res = new StringBuilder();
            res.append(ChineseQuantifiableEntityNormalizer.normalizeYear(m.group(1), ctxyear, true).substring(0, 3) + "X");
            res.append("-XX-XX");
            return res.toString();
        }
        p = Pattern.compile("^([\u6628\u4eca\u660e])[\u5929\u6668\u665a\u591c\u65e9]$");
        m = p.matcher(s);
        if (m.find() && m.groupCount() == 1) {
            StringBuilder res = new StringBuilder();
            res.append(ctxyear);
            res.append("-");
            res.append(ctxmonth);
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(1), ctxday));
            return res.toString();
        }
        p = Pattern.compile("^" + BASIC_YYYYMMDD_PATTERN + "$");
        m = p.matcher(s);
        if (m.find() && m.groupCount() == 3) {
            StringBuilder res = new StringBuilder();
            res.append(ChineseQuantifiableEntityNormalizer.normalizeYear(m.group(1), ctxyear));
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(2), ctxmonth));
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(3), ctxday));
            return res.toString();
        }
        p = Pattern.compile("^" + BASIC_MMDD_PATTERN + "$");
        m = p.matcher(s);
        if (m.find() && m.groupCount() == 2) {
            StringBuilder res = new StringBuilder();
            res.append(ctxyear);
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(1), ctxmonth));
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(2), ctxday));
            return res.toString();
        }
        p = Pattern.compile("^" + BASIC_DD_PATTERN + "$");
        m = p.matcher(s);
        if (m.find() && m.groupCount() == 1) {
            StringBuilder res = new StringBuilder();
            res.append(ctxyear);
            res.append("-");
            res.append(ctxmonth);
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(1), ctxday));
            return res.toString();
        }
        p = Pattern.compile("^(\\d{1,2})[/\\-\\.](\\d{1,2})(?:[/\\-\\.](\\d{4}))?$");
        m = p.matcher(s);
        if (m.find() && m.groupCount() == 3) {
            StringBuilder res = new StringBuilder();
            if (m.group(3) == null) {
                res.append(ctxyear);
            } else {
                res.append(ChineseQuantifiableEntityNormalizer.normalizeYear(m.group(3), ctxyear));
            }
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(1), ctxmonth));
            res.append("-");
            res.append(ChineseQuantifiableEntityNormalizer.normalizeMonthOrDay(m.group(2), ctxday));
            return res.toString();
        }
        return s;
    }

    public static <E extends CoreMap> String singleEntityToString(List<E> l) {
        String entityType = (String)((CoreMap)l.get(0)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        StringBuilder sb = new StringBuilder();
        for (CoreMap w : l) {
            if (!((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(entityType)) {
                log.error("differing NER tags detected in entity: " + l);
                throw new Error("Error with entity construction, two tokens had inconsistent NER tags");
            }
            sb.append((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        return sb.toString();
    }

    public static String prettyNumber(String s) {
        if (s == null) {
            return null;
        }
        s = s.indexOf(".") < 0 ? s : s.replaceAll("0*$", "").replaceAll("\\.$", "");
        return s;
    }

    public static <E extends CoreMap> void fixupNerBeforeNormalization(List<E> list) {
    }

    static {
        ARABIC_NUMBERS_PATTERN = Pattern.compile("[-+]?\\d*\\.?\\d+");
        CHINESE_LITERAL_DECIMAL_PATTERN = CHINESE_LITERAL_NUMBER_SEQUENCE_PATTERN = Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u3007]+");
        quantifiable = Generics.newHashSet();
        quantifiable.add(NUMBER_TAG);
        quantifiable.add(DATE_TAG);
        quantifiable.add(TIME_TAG);
        quantifiable.add(MONEY_TAG);
        quantifiable.add(PERCENT_TAG);
        quantifiable.add(ORDINAL_TAG);
        quantityUnitToValues = new ClassicCounter();
        quantityUnitToValues.setCount("\u5341", 10.0);
        quantityUnitToValues.setCount("\u767e", 100.0);
        quantityUnitToValues.setCount("\u5343", 1000.0);
        quantityUnitToValues.setCount("\u4e07", 10000.0);
        quantityUnitToValues.setCount("\u4ebf", 1.0E8);
        wordsToValues = new ClassicCounter();
        wordsToValues.setCount("\u96f6", 0.0);
        wordsToValues.setCount("\u3007", 0.0);
        wordsToValues.setCount("\u4e00", 1.0);
        wordsToValues.setCount("\u4e8c", 2.0);
        wordsToValues.setCount("\u4e24", 2.0);
        wordsToValues.setCount("\u4e09", 3.0);
        wordsToValues.setCount("\u56db", 4.0);
        wordsToValues.setCount("\u4e94", 5.0);
        wordsToValues.setCount("\u516d", 6.0);
        wordsToValues.setCount("\u4e03", 7.0);
        wordsToValues.setCount("\u516b", 8.0);
        wordsToValues.setCount("\u4e5d", 9.0);
        wordsToValues.addAll(quantityUnitToValues);
        multiCharCurrencyWords = Generics.newHashMap();
        multiCharCurrencyWords.put("\u7f8e\u5143", Character.valueOf('$'));
        multiCharCurrencyWords.put("\u7f8e\u5206", Character.valueOf('$'));
        multiCharCurrencyWords.put("\u82f1\u9551", Character.valueOf('\u00a3'));
        multiCharCurrencyWords.put("\u5148\u4ee4", Character.valueOf('\u00a3'));
        multiCharCurrencyWords.put("\u4fbf\u58eb", Character.valueOf('\u00a3'));
        multiCharCurrencyWords.put("\u6b27\u5143", Character.valueOf('\u20ac'));
        multiCharCurrencyWords.put("\u65e5\u5143", Character.valueOf('\u00a5'));
        multiCharCurrencyWords.put("\u97e9\u5143", Character.valueOf('\u20a9'));
        oneCharCurrencyWords = Generics.newHashMap();
        oneCharCurrencyWords.put("\u5200", Character.valueOf('$'));
        oneCharCurrencyWords.put("\u9551", Character.valueOf('\u00a3'));
        oneCharCurrencyWords.put("\u5143", Character.valueOf('\u5143'));
        yearModifiers = Generics.newHashMap();
        yearModifiers.put("\u524d", -2);
        yearModifiers.put("\u53bb", -1);
        yearModifiers.put("\u4e0a", -1);
        yearModifiers.put("\u4eca", 0);
        yearModifiers.put("\u540c", 0);
        yearModifiers.put("\u6b64", 0);
        yearModifiers.put("\u8be5", 0);
        yearModifiers.put("\u672c", 0);
        yearModifiers.put("\u660e", 1);
        yearModifiers.put("\u6765", 1);
        yearModifiers.put("\u4e0b", 1);
        yearModifiers.put("\u540e", 2);
        monthDayModifiers = Generics.newHashMap();
        monthDayModifiers.put("\u6628", -1);
        monthDayModifiers.put("\u4e0a", -1);
        monthDayModifiers.put("\u4eca", 0);
        monthDayModifiers.put("\u540c", 0);
        monthDayModifiers.put("\u6b64", 0);
        monthDayModifiers.put("\u8be5", 0);
        monthDayModifiers.put("\u672c", 0);
        monthDayModifiers.put("\u6765", 1);
        monthDayModifiers.put("\u660e", 1);
        monthDayModifiers.put("\u4e0b", 1);
        fullDigitToHalfDigit = Generics.newHashMap();
        fullDigitToHalfDigit.put("\uff11", "1");
        fullDigitToHalfDigit.put("\uff12", "2");
        fullDigitToHalfDigit.put("\uff13", "3");
        fullDigitToHalfDigit.put("\uff14", "4");
        fullDigitToHalfDigit.put("\uff15", "5");
        fullDigitToHalfDigit.put("\uff16", "6");
        fullDigitToHalfDigit.put("\uff17", "7");
        fullDigitToHalfDigit.put("\uff18", "8");
        fullDigitToHalfDigit.put("\uff19", "9");
        fullDigitToHalfDigit.put("\uff10", "0");
        YEAR_MODIFIER_PATTERN = "[" + String.join((CharSequence)"", yearModifiers.keySet()) + "]";
        MONTH_DAY_MODIFIER_PATTERN = "[" + String.join((CharSequence)"", monthDayModifiers.keySet()) + "]";
        BASIC_DD_PATTERN = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d]{1,3}|" + MONTH_DAY_MODIFIER_PATTERN + ")[\u65e5\u53f7&&[^\u5e74\u6708]]?";
        BASIC_MMDD_PATTERN = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d]{1,2}|" + MONTH_DAY_MODIFIER_PATTERN + ")(?:\u6708\u4efd?|\\-|/|\\.)(?:" + BASIC_DD_PATTERN + ")?";
        BASIC_YYYYMMDD_PATTERN = "([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u3007\\d]{2,4}|" + YEAR_MODIFIER_PATTERN + ")(?:\u5e74[\u4efd\u5ea6]?|\\-|/|\\.)?" + "(?:" + BASIC_MMDD_PATTERN + ")?";
    }
}

